﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<PhotoThread>>" %>
<%int applicatonID = ApplicationIDs.Instance().Photo();
  string tagName = HtmlUtils.TrimHtml(ViewData.GetString("tagName", string.Empty), 20);%>

<div id="listPhotosByTag" class="tn-box tn-widget tn-widget-content tn-corner-all spb-photos-main spb-photos-tag">
  <div class="tn-box-content tn-widget-content tn-corner-all">
    <%if (Model != null && Model.TotalRecords > 0)
          { %>
    <ul class="tn-photo-list tn-widget tn-helper-clearfix">
      <%foreach (PhotoThread photo in ViewData.Model.Records)
              {%>
      <%PhotoSection photoSection = photo.Section;%>
      <li class="tn-photo-item">
        <p class="tn-photo-wrap tn-widget-content tn-border-gray"> <a href="<%=SPBUrlHelper.Action("ShowPhoto", "Photo", new RouteValueDictionary { { "userDomainName", UserID2UserNameDictionary.GetUserName(photo.OwnerUserID) }, { "threadID", photo.ThreadID } })%>"
                        class="pohotListImg" target="_blank"> <%=SPBHtmlHelper.Instance().ShowPicture(photo.ThreadID, PhotoImageType.Thumbnail, photo.Subject)%></a></p>
        <p class="tn-text-heading"> <a href="<%=SPBUrlHelper.Action("ShowPhoto", "Photo", new RouteValueDictionary { { "userDomainName", UserID2UserNameDictionary.GetUserName(photo.OwnerUserID) }, { "threadID", photo.ThreadID } })%>"
                        target="_blank"> <%=StringUtils.Trim(photo.Subject, 13)%></a>
        <p class="tn-text-note tn-count">
          <%   Response.Write(string.Format("{0}:<a href=\"{1}\">{2}</a>", GetResourceString("Label_Pattern_Upload", ApplicationIDs.Instance().Photo()), SiteUrls.Instance().UserChannelHome(photo.OwnerUserID, ApplicationIDs.Instance().Photo()), photo.Author));
                    %>
        </p>
      </li>
      <%}%>
    </ul>
    <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7,SPBUrlHelper.Action("Control_ListPhotosByTag","ChannelPhoto",new RouteValueDictionary{{"tagName",WebUtils.UrlEncode(tagName)},{"pageIndex","{0}"}}), "pageIndexChange")%>
      <div class="tn-page-results tn-text-note"> <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
    </div>
    <%}
          else
          {%>
    <div class="tn-no-data"> <%=GetResourceString("Message_NoPhotos", applicatonID)%> </div>
    <%} %>
  </div>
  <script type="text/javascript">
        function pageIndexChange(url) {
            $('#listPhotosByTag').parent().load(url);
        }
    </script>
</div>
