﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<Dictionary<string, KeyValuePair<int, SiteTag>>>" %>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-tags-block">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=ViewData.GetString("controlTitle", GetResourceString("Title_HotTag"))%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <p class="tn-tags-hot">
      <% SiteTagsSortBy sortBy = SiteTagsSortBy.ItemCount;
           if (ViewData["sortBy"] != null)
               sortBy = (SiteTagsSortBy)ViewData["sortBy"]; %>
      <% 
                    foreach (var pair in ViewData.Model)
                    {   %>
      <span> <%=SPBHtmlHelper.Instance().ShowSiteTagHyperLink(pair.Value.Value, Globals.GetFullUrlInMainSite(SiteUrls.Instance().ListPhotosBySiteTag(pair.Key)), GetResourceString("Label_Pattern_UserDefineImage", ApplicationIDs.Instance().Photo()))%> <em class="tn-text-note">(
      <% switch (sortBy)
                            {
                                case SiteTagsSortBy.ItemCount:
                                    Response.Write(pair.Value.Value.ItemCount);
                                    break;
                                case SiteTagsSortBy.LastModified:
                                    break;
                                case SiteTagsSortBy.UserCount:
                                    Response.Write(pair.Value.Value.UserCount);
                                    break;
                                default:
                                    Response.Write(pair.Value.Value.ItemCount.ToString());
                                    break;
                            }
                %>
      )</em></span>
      <%} 
            %>
    </p>
    <p class="tn-more"> <a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("PhotoTagMap","ChannelPhoto")) %>"><%=GetResourceString("Enum_LookTag", ApplicationIDs.Instance().Photo()) %></a> </p>
  </div>
</div>
<div class="tn-blank10"> </div>
