﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<RecommendedItem>>" %>
<%if (Model != null && Model.Count > 0)
  {
      int applicatonID = ApplicationIDs.Instance().Photo();
      UserCategory category = null;
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-albums-recommend-block">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            相册推荐</h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-album-list tn-widget tn-helper-reset tn-helper-clearfix">
            <%
                foreach (RecommendedItem item in Model)
                {
                    category = UserCategoryManager.Instance(UserCategoryItemKeys.Instance().Photo()).GetUserCategory(item.ItemID, false);
                    if (category == null)
                        continue;
            %>
            <li class="tn-album-item tn-helper-clearfix">
                <div class="tn-album-cover tn-widget-content tn-border-gray">
                    <div class="tn-photo-wrap tn-widget-content tn-border-gray">
                        <a target="_blank" href="<%=SiteUrls.Instance().ShowPhotoCategory(UserID2UserNameDictionary.GetUserName(category.UserID),category.CategoryID) %>">
                            <img src="<%=SiteUrls.Instance().CategoryFeaturedPhotoUrl(category) %>" alt="<%=category.CategoryName %>"></a></div>
                </div>
                <p class="tn-text-heading">
                    <a target="_blank" href="<%=SiteUrls.Instance().ShowPhotoCategory(UserID2UserNameDictionary.GetUserName(category.UserID),category.CategoryID) %>"
                        title="<%=category.CategoryName %>">
                        <%=StringUtils.Trim(item.ItemName,7) %></a></p>
                <p class="tn-text-note tn-count">
                    <%=GetResourceString("Label_PictureCount", applicatonID) + GetResourceString("Common_Colon") + category.ItemCount%></p>
                <p class="tn-text-note tn-date">
                    <%=Formatter.FormatDate(category.DateCreated,false) %></p>
            </li>
            <%
                }
            %>
        </ul>
    </div>
</div>
<div class="tn-blank10">
</div>
<%} %>