﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<spb:Script runat="server" ID="Script1" Src="~/Utility/jquery/plugin/jquery.slideshow.lite-0.5.3.js"
    SetExpireDays="30" />
<% IList<PhotoThread> recommendPhotos = ViewData.Get<IList<PhotoThread>>("recommendPhotos", new List<PhotoThread>());
   bool hasBorder = Html.GetParameterFromRouteDateOrQueryString<bool>("hasBorder");
   if (recommendPhotos != null && recommendPhotos.Count > 0)
   {
       if (hasBorder)
       {
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-photos-recommend">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%if (ViewData["RecommendationType"] != null)
              {
                  RecommendationType recommendationType = ViewData.Get<RecommendationType>("recommendationType");
                  Response.Write(recommendationType.GetMultilingualRecommendationTypeName(CurrentUserLanguage));
              }
            %>
        </h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <div class="tn-helper-clearfix">
            <div class="spb-photos-slide">
                <div id="photoimgstore">
                    <%foreach (PhotoThread photo in recommendPhotos)
                      {
                          if (photo != null)
                          {%>
                    <a style="display: none;" href="<%=SPBUrlHelper.Action("ShowPhoto","Photo",new RouteValueDictionary{{"userDomainName",UserID2UserNameDictionary.GetUserName(photo.OwnerUserID)},{"threadID",photo.ThreadID}}) %>">
                        <%=SPBHtmlHelper.Instance().ShowPicture(photo, PhotoImageType.ChannelSlideshow)%>
                    </a>
                    <%}
                  } %>
                </div>
            </div>
            <ul class="tn-thumbs tn-helper-reset">
                <%foreach (PhotoThread photo in recommendPhotos)
                  {
                      if (photo != null)
                      {%>
                <li class="tn-thumb">
                    <%=SPBHtmlHelper.Instance().ShowPicture(photo.ThreadID, PhotoImageType.Icon, photo.Subject, SPBUrlHelper.Action("ShowPhoto", "Photo", new RouteValueDictionary { { "userDomainName", UserID2UserNameDictionary.GetUserName(photo.OwnerUserID) }, { "threadID", photo.ThreadID } }), "_blank")%>
                </li>
                <%}
              } %>
            </ul>
        </div>
    </div>
</div>
<div class="tn-blank10">
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("#photoimgstore a").show();
        $("#photoimgstore").slideshow({ width: 320, height: 240 });
    });
</script>

<%  }
       else
       {%>
<ul class="tn-helper-reset tn-helper-clearfix spb-pic-list">
    <%foreach (PhotoThread photo in recommendPhotos)
      {
          if (photo != null)
          {%>
    <li>
        <%=SPBHtmlHelper.Instance().ShowPicture(photo.ThreadID, PhotoImageType.Icon, photo.Subject, SPBUrlHelper.Action("ShowPhoto", "Photo", new RouteValueDictionary { { "userDomainName", UserID2UserNameDictionary.GetUserName(photo.OwnerUserID) }, { "threadID", photo.ThreadID } }), "_blank")%>
    </li>
    <%}
      } %>
</ul>
<% }
   } %>
