﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<RecommendedItem>>" %>
<% 
    List<RecommendationType> recommendationTypes = (List<RecommendationType>)ViewData["recommendationTypes"];
    bool noRecommendedType = (bool)ViewData["noRecommendationType"];
    int itemID = ViewData.GetInt("itemID", 0);
    int domainUserID = ViewData.GetInt("domainUserID", 0);
    int applicationID = ViewData.GetInt("applicationID", 0);
    string itemName = ViewData.GetString("itemName", string.Empty);
    if (string.IsNullOrEmpty(itemName))
        itemName = TempData.GetString("itemName", string.Empty);
    string commendDescription = ViewData.GetString("description", string.Empty);
    int CommendTypeID = ViewData.GetInt("CommendTypeID", 0);
    int displyOrder = ViewData.GetInt("displyOrder", 100);
    DateTime stopDate = ViewData.Get<DateTime>("stopDate", DateTime.Now.AddYears(1));
%>

<div id="recommendedItemsDiv" class="spb-recommend-form">
  <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js" SetExpireDays="30" />
  <form id="remommendItemForm" class="nyroModal" method="post">
    <input type="hidden" name="CommendTypeID" value="<%=CommendTypeID %>" />
    <input type="hidden" name="CommendID" value="<%=ViewData.GetInt("CommendID", 0) %>" />
    <div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom"> <%=GetResourceString("Common_ManagerRecommend")%></h4>
    <div class="tn-form-row">
      <label class="tn-form-label"> <%=GetResourceString("Title_RecommendationType") %> </label>
      <% if (noRecommendedType)
               {%>
      <label> <%=GetResourceString("Description_NoRecommendationType") %></label>
      <% }
               else
               {%>
      <select id="recommendationTypesDropDownList" name="recommendationTypesDropDownList"
                <%if (CommendTypeID>0) Response.Write("disabled=\"disabled\""); %> class="tn-dropdownlist">
        <%
                    if (recommendationTypes != null && recommendationTypes.Count > 0)
                    {%>
        <option value="0">-- <%=GetResourceString("Common_PleaseChoose") %> --</option>
        <%foreach (RecommendationType recommendationType in recommendationTypes)
                  {%>
        <option value="<%=recommendationType.TypeID %>" <%if (recommendationType.TypeID == CommendTypeID) Response.Write("selected=\"selected\""); %>> <%=recommendationType.Name%></option>
        <% }
                    }
                    else
                    {%>
        <option value="0">-- <%=GetResourceString("Description_NoLaveAnyRecommendationType")%> --</option>
        <%}%>
      </select>
      <%}%>
    </div>
    <%if (CommendTypeID <= 0)
      { %>
    <div class="tn-form-row spb-recommended">
      <label class="tn-form-label"><%=GetResourceString("Title_HasRecommendedToType") %><%=GetResourceString("Common_Colon") %></label>
      <div class="spb-recommended-type tn-border-gray">
        <ul>
          <% if (Model != null && Model.Count > 0)
               {
                   foreach (RecommendedItem recommendedItem in Model)
                   {%>
          <li>&nbsp;<a class="tn-icon tn-icon-cross tn-icon-inline" href="javascript:;"  onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteRecommendedItem") %>')) { $('#recommendedItemsDiv').load('<%=SPBUrlHelper.Action("DeleteRecommendedItem","Channel",new RouteValueDictionary{{"commendID",recommendedItem.CommendID},{"applicationID",applicationID},{"domainUserID",domainUserID},{"itemID",itemID},{"itemName",WebUtils.UrlEncode(itemName)}}) %>')}"></a><span> <%=recommendedItem.RecommendedTypeName %></span><em>【 <%=Formatter.FormatDate(recommendedItem.Deadline) %>&nbsp;&nbsp;<%=GetResourceString("Description_Canceled") %>】</em> </li>
          <%}
               } %>
        </ul>
      </div>
    </div>
    <%} %>
    <div class="tn-form-row tn-textarea-wrap">
      <label class="tn-form-label"> <%=GetResourceString("Label_RecommendationSuject") %> </label>
      <textarea class="tn-textarea tn-input-long tn-border-gray" name="commendName" id="commendName"><%=itemName %></textarea>
      <span style="display:none"></span>
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> <%=GetResourceString("Label_EndDate") %> </label>
      <spb:Script ID="Script1" runat="server" Src="~/Utility/jquery/ui.datepicker.min-1.8.12.js"
                SetExpireDays="30" />
      <script type="text/javascript">
                $(function() {
                    $('#stopTime').datepicker({
                        changeMonth: true,
                        changeYear: true
                    });
                });
            </script>
      <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("stopTime", DateTime.Now.Year, DateTime.Now.Year + 10, stopDate, false, "tn-textbox tn-input-medium tn-ui-border-gray")); %>
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> <%=GetResourceString("Label_OrderNO")%> </label>
      <input type="text" class="tn-textbox tn-input-medium tn-border-gray" name="sortOrder"
                value="<%=displyOrder %>" id="sortOrder" />
    </div>
    <div class="tn-tip-area">
      <%   
        if (TempData["StatusMessageData"] != null)
        {
            StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
            if (messageData.MessageType == StatusMessageType.Success)
            {
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData));
            }
            else if (messageData.MessageType == StatusMessageType.Error)
            {
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData));
            }
            TempData["StatusMessageData"] = null;
        }
    %>
    </div>
    <div class="tn-form-row tn-form-row-button tn-bg-gray tn-border-gray tn-border-top"> <%=SPBHtmlHelper.Instance().LinkButton("saveButton", GetResourceString("Button_Save"), ButtonSizes.Default, HighlightStyles.Primary, new RouteValueDictionary { { "onclick", "submitRemommendForm()" } },null)%> <%=SPBHtmlHelper.Instance().LinkButton("",GetResourceString("Button_Close"),ButtonSizes.Default,HighlightStyles.Default,new RouteValueDictionary {{"onclick","$.nyroModalRemove();"}},null)%> </div>
  </form>
  <script type="text/javascript">
       function submitRemommendForm() {
            if (!$('#remommendItemForm').valid()) { return false; };
            $('#remommendItemForm').ajaxSubmit({ target: '#recommendedItemsDiv', url: '<%=SPBUrlHelper.Action("RecommendItemHandler","Channel",new RouteValueDictionary{{"applicationID",applicationID},{"domainUserID",domainUserID},{"itemID",itemID}}) %>' });
        }
 
    
    
 $(document).ready(function() {
            $("#remommendItemForm").validate({
                rules: {
                    sortOrder: { required: true, digits: true },
                    commendName: { required: true }
                },
                messages: {
                    sortOrder: { required: "<%=GetResourceString("Validate_SortOrderRequired") %>", digits: "<%=GetResourceString("Validate_SortOrderDigits") %>" },
                    commendName: { required: "<%=GetResourceString("Validate_CommendNameRequired") %>" }
                }
            });

            $("#saveButton").click(function() {
                if (!$("#remommendItemForm").valid()) {
                    return false;
                }
            });
        }); 
 
    </script>
</div>
