﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    int applicationID = ApplicationIDs.Instance().Share();
    if (CurrentUser != null)
    {%>
<div id="addShareDialog">
    <form id="CreateUserShareThreadForm" class="tn-helper-reset" action="<%=SPBUrlHelper.Action("CreateShareThread", "UserDomainShare", new RouteValueDictionary { { "userDomainName",CurrentUser.UserName  } })%>"
    method="post">
    <div class="tn-form tn-form-single">
        <input type="text" id="urlForShare" name="urlForShare" class="tn-textbox tn-input-long tn-border-gray"
            value="" />
        <%=SPBHtmlHelper.Instance().SubmitButton("newShareButton", GetResourceString("Common_Share"),ButtonSizes.Default,null,null)%>
        <%=SPBHtmlHelper.Instance().Button("closeButton", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "class", "dialogClose" } }, null)%>
    </div>
    </form>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("#urlForShare").watermark("<%=GetResourceString("Description_ImportYourShareLink", ApplicationIDs.Instance().Share()) %>");
        $("#CreateUserShareThreadForm").validate({
            rules: {
                urlForShare: { required: true, url: true, maxlength: 512 }
            },
            messages: {
                urlForShare: { required: "<%=GetResourceString("Validate_MustImport", applicationID)%>", url: "<%=GetResourceString("Validate_DifferFormat", applicationID)%>", maxlength: "<%=GetResourceString("Validate_CharsMost", applicationID)%>" }
            },
            showErrors: $.dialog.showErrors,
            onfocusout: false,
            onclick: false,
            onkeyup:false,
            onsubmit:true
        });
    });
</script>

<%} %>