﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<ShareThread>" %>
<%
    if (TempData["StatusMessageData"] != null)
    {
        StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData, 2000, false));
        if (messageData.MessageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        TempData["StatusMessageData"] = null;
    }
    
    int applicationID = ApplicationIDs.Instance().Share();
%>

<div class="spb-edit-share">
  <form class="nyroModal" id="UpdateShareThreadForm" method="post"
action="<%=SPBUrlHelper.Action("UpdateShareThread","ChannelShare",new RouteValueDictionary{{"threadID",Model.ThreadID}}) %>">
    <% if ( (CurrentUser!=null && CurrentUser.IsContentAdministrator) || (CurrentUser !=null && CurrentUser.IsAdministrator))
   { %>
    <div class="tn-form tn-label-right">
      <h4 class="tn-text-heading tn-border-gray tn-border-bottom"> <%=GetResourceString("Title_EditSiteShare", applicationID)%> </h4>
      <div class="tn-form-row">
        <label class="tn-form-label"> <%=GetResourceString("Label_NoteAddress", applicationID)%><%=GetResourceString("Common_Colon") %></label>
        <input type="text" value="<%=Model.URL %>" disabled="disabled" class="tn-textbox tn-input-long tn-border-gray"
            name="text" />
      </div>
      <div class="tn-form-row">
        <label class="tn-form-label"> <span class="tn-form-required">*</span> <%=GetResourceString("Label_Subject")%><%=GetResourceString("Common_Colon") %></label>
        <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="subject"
            name="subject" value="<%=Formatter.FormatSingleLinePlainTextForEdit(Model.Subject) %>">
      </div>
      <div class="tn-form-row tn-textarea-wrap">
        <label class="tn-form-label"> <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %></label>
        <textarea id="body" name="body" rows="5" cols="50" class="tn-textarea tn-input-long tn-border-gray"
            rows="" cols="">
        <%=Formatter.FormatMultiLinePlainTextForEdit(Model.Body, true)%>
        </textarea>
        <div class="tn-text-note"> <%=string.Format(GetResourceString("Description_WordCountLimit", applicationID), ShareConfiguration.Instance().MaxLengthForBody)%></div>
      </div>
      <div class="tn-form-row">
        <label class="tn-form-label"> <%=GetResourceString("Label_MiniatureAddress", applicationID)%><%=GetResourceString("Common_Colon") %></label>
        <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="thumbnailUrl"
            name="thumbnailUrl" value="<%=Formatter.FormatSingleLinePlainTextForEdit(Model.ThumbnailUrl) %>" />
      </div>
      <% if (Model.ApplicationID <= 0)
       { %>
      <div class="tn-form-row">
        <label class="tn-form-label"> <%=GetResourceString("Label_PlayAddress", applicationID)%><%=GetResourceString("Common_Colon") %></label>
        <input type="text" id="playerUrl" name="playerUrl" class="tn-textbox tn-input-long tn-border-gray"
            value="<%=Formatter.FormatSingleLinePlainTextForEdit(Model.PlayerUrl) %>" />
      </div>
      <%} %>
      <div class="tn-form-row">
        <label class="tn-form-label"> <%=GetResourceString("Label_SiteShareType", applicationID)%><%=GetResourceString("Common_Colon") %></label>
        <%Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(ApplicationIDs.Instance().Share(), ShareConfiguration.Instance().SiteCategoryLevel - 1, "siteCategoryID", Model.SiteCategoryID, "dropDownList")); %>
      </div>
      <%if (Model.ApplicationID <= 0)
      { %>
      <div class="tn-form-row">
        <label class="tn-form-label"> <%=GetResourceString("Label_MultimediaType", applicationID)%><%=GetResourceString("Common_Colon") %></label>
        <select id="mediaTypeSelect" name="mediaType" class="tn-dropdownlist">
          <option <%if (Model.MediaType == MediaTypes.Website) Response.Write("select=\"select\""); %>
                value="<%=(int)MediaTypes.Website %>"> <%=GetResourceString("Enum_Else", applicationID)%></option>
          <option <%if(Model.MediaType==MediaTypes.Video) Response.Write("select=\"select\""); %>
                value="<%=(int)MediaTypes.Video %>"> <%=GetResourceString("Enum_Media", applicationID)%></option>
          <option <%if(Model.MediaType==MediaTypes.Music) Response.Write("select=\"select\""); %>
                value="<%=(int)MediaTypes.Music %>"> <%=GetResourceString("Enum_Music", applicationID)%></option>
        </select>
      </div>
      <%} %>
      <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label"> </label>
        <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Common_Share"), ButtonSizes.Large, null, null)%> <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Large, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "nyroModalClose" } },null)%> </div>
    </div>
    <%} %>
  </form>
</div>
<script type="text/javascript">
        $(document).ready(function() {
            $("#UpdateShareThreadForm").validate({
                rules: {
                    subject: { required: true, maxBlength: 80 },
                    body: { maxBlength: <%=ShareConfiguration.Instance().MaxLengthForBody %> },
                    thumbnailUrl:{url:true}
                },
                messages: {
                    subject: { required: "<%=GetResourceString("Validate_MustImport", applicationID)%>", maxBlength: "<%=GetResourceString("Validate_MostChar", applicationID)%>" },
                    body: { maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_MostImportChar", applicationID), ShareConfiguration.Instance().MaxLengthForBody)%>" },
                    thumbnailUrl:{ url:"<%=GetResourceString("Validate_AccordUrlFormat", applicationID)%>" }
                }
            });
            $("#saveButton").click(function() {
                if (!$("#UpdateShareThreadForm").valid()) {
                    return false;
                }
                else {
                    $("#saveButton").hide();
                    $("#saveButtonA").show();
                }
            });
        });
</script>
