﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<ShareThread>>" %>
<%
    int sortBy = ViewData.GetInt("sortBy", (int)ShareThreadSortBy.DayHitTimes);
    bool hasBorder = Html.GetParameterFromRouteDateOrQueryString<bool>("hasBorder");

%>
<%if (Model != null && Model.Count > 0)
  {
      if (hasBorder)
      { %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("ShareRanks","ChannelShare",new RouteValueDictionary{{"siteCategoryID",Html.GetParameterFromRouteDateOrQueryString("siteCategoryID")},{"mediaType",Html.GetParameterFromRouteDateOrQueryString("mediaType")},{"applicationID",Html.GetParameterFromRouteDateOrQueryString("applicationID") }}) %>">
            <%=GetResourceString("Action_More") %></a></span>
        <h3 class="tn-helper-reset">
            <%=Html.GetParameterFromRouteDateOrQueryString("moduleTitle") %></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <%} %>
        <ul class="tn-list tn-helper-reset">
            <% foreach (ShareThread thread in Model)
               {
                   string userMicroBlog = string.Empty;
            %>
            <li class="tn-list-item tn-helper-clearfix">
                <div class="tn-list-item-area-left">
                    <div class="tn-avatar">
                        <a href="<%=thread.URL %>" target="_blank">
                            <img src="<%=thread.ThumbnailUrl %>" alt="<%=thread.Subject %>"><span class="tn-round-corner"></span></a>
                    </div>
                </div>
                <div class="tn-list-item-area-main">
                    <div class="tn-list-item-row tn-list-item-heading">
                        <h5 class="tn-helper-reset">
                            <%=SPBHtmlHelper.Instance().UserDisplayName(thread.UserID,true) %>
                        </h5>
                    </div>
                    <%     if (!string.IsNullOrEmpty(MicroBlogUserDatas.GetUserData(thread.UserID, false).MostRecentThreadBody))
                           {
                               userMicroBlog = MicroBlogUserDatas.GetUserData(thread.UserID, false).MostRecentThreadBody; %>
                    <div class="tn-list-item-row tn-list-item-summary">
                        <div class="spb-i-said">
                             &nbsp;<span class="tn-icon tn-icon-quotes-before tn-icon-inline"></span>
                            <%=userMicroBlog%><span class="tn-icon tn-icon-quotes-after tn-icon-inline"> </span>
                        </div>
                    </div>
                    <%} %>
                </div>
            </li>
            <%} %>
        </ul>
        <%   if (hasBorder)
             {%>
    </div>
</div>
<div class="tn-blank10">
</div>
<%}
  } %>
