﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ShareComment>>" %>
<spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
    SetExpireDays="30" />
<% 
    int threadID = Html.GetParameterFromRouteDateOrQueryString<int>("threadID");
    string controlName = "ListShareComments";
    RouteValueDictionary dictionary = new RouteValueDictionary { { "threadID", threadID }, { "controlName", controlName } };
    int applicationID = ApplicationIDs.Instance().Share();
%>
<div class="tn-comment-wrap" id="ListComments_<%=threadID %>">
    <div class="tn-list-header">
        <div class="tn-text-heading tn-border-bottom tn-border-gray">
            <h4>
                <%=GetResourceString("Common_Comment") %><span class="tn-text-note">
                    <%if (Model != null) Response.Write("（" + Model.TotalRecords + "）"); %></span></h4>
        </div>
    </div>
    <%if (Model != null && Model.Records.Count > 0)
      {%>
    <ul class="tn-comments tn-helper-reset">
        <%foreach (var shareComment in ViewData.Model.Records)
          {%>
        <li class="tn-comment-item tn-border-gray tn-border-bottom">
            <a name="<%=shareComment.CommentID %>" id="<%=shareComment.CommentID %>"></a>
            <div class="tn-comment tn-helper-clearfix">
                <div class="tn-comment-avatar">
                    <div class="tn-avatar">
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(shareComment.UserID,true, HyperLinkTarget._blank, AvatarSizeTypes.Small) %>
                    </div>
                </div>
                <%if (CurrentUser != null && (CurrentUser.UserID == shareComment.UserID || CurrentUser.IsContentAdministrator))
                  { %>
                <a class="tn-icon tn-icon-cross tn-helper-right" href="javascript:;" onclick="if(confirm('<%=GetResourceString("Message_ConfirmDeleteComment")%>')){$('#ListComments_<%=threadID %>').load('<%=SPBUrlHelper.Action("DeleteShareComment","ChannelShare",new RouteValueDictionary(dictionary){{"commentID",shareComment.CommentID}, { "pageIndex", Model.PageIndex }}) %>')} return false;">
                </a>
                <%}%>
                <div class="tn-comment-info">
                    <div class="tn-commentator">
                        <h5>
                            <%=SPBHtmlHelper.Instance().UserDisplayNameLink(shareComment.UserID,shareComment.Author,UserDomainSpecialAppIDs.Instance().Home()) %>
                        </h5>
                        <em class="tn-text-note tn-date">
                            <%=Formatter.FormatDate(shareComment.DateCreated)%>
                        </em>
                        <% if (CurrentUser != null && shareComment.UserID != CurrentUser.UserID && CurrentUser != null)
                           { %>
                        <span class="tn-text-note">
                            <a href="javascript:;" onclick="$('#commentBody').focus().attr('value','<%=string.Format("{0}{1}：",GetResourceString("Common_Reply"),shareComment.Author) %>');$('#parentID').attr('value','<%=shareComment.CommentID %>');">
                                <%=GetResourceString("Common_Reply")%></a></span>
                        <%} %>
                    </div>
                    <%if (shareComment.ParentID > 0)
                      { %>
                    <blockquote class="tn-cue-tips tn-bg-gray tn-border-gray">
                        <p>
                            <%=GetResourceString("Common_Reply")%>
                            <%
                                if (shareComment.ParentUserID > 0)
                                { %>
                            <a href="<%=SiteUrls.Instance().UserDomainHome(shareComment.ParentUserID) %>" class="tn-author">
                                <%=shareComment.ParentAuthor%></a>
                            <%} %><em class="tn-text-note tn-date"><%=Formatter.FormatDate(shareComment.ParentCommentDate, true)%></em></p>
                        <p>
                            <%=shareComment.ParentBody%></p>
                    </blockquote>
                    <%} %>
                    <p>
                        <%=shareComment.Body%></p>
                </div>
            </div>
        </li>
        <%} %>
        <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().AjaxPagingButton(Model.TotalRecords, Model.PageSize, Model.PageIndex, 1, SPBUrlHelper.Action("Control_ListShareComments", "ChannelShare", new RouteValueDictionary(dictionary) { { "pageIndex", "{0}" } }), "pageIndexChange")%>
        </div>
    </ul>
    <%} %>
    <%
        if (SiteSettingsManager.GetSiteSettings().EnableAnonymousPosting || CurrentUser != null)
        {

            if (TempData["StatusMessageType"] != null)
            {
                StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
                TempData["StatusMessageType"] = null;
            }
    %>
    <form name="shareCommentForm_<%=threadID %>" id="shareCommentForm_<%=threadID %>"
    class="tn-helper-reset" action="<%=SPBUrlHelper.Action("CreateShareComment","ChannelShare",new RouteValueDictionary(dictionary))%>"
    method="post">
    <div class="tn-form tn-label-top">
        <div class="tn-comment-form-wrap tn-bg-gray">
            <div class="tn-comment-form">
                <div class="tn-comment-form tn-emotion-box">
                    <a name="comments" id="comments"></a>
                    <%  Html.RenderAction<ChannelController>(n => n.Control_SmileySelector("Smiley", "commentBody"));%>
                    <div class="tn-comment-text-wrap tn-border-gray tn-form-row-near">
                        <textarea name="commentBody" id="commentBody" cols="60" rows="5" class="tn-comment-text-area"><%=TempData.GetString("commentBody", string.Empty)%></textarea>
                        <input type="hidden" id="parentID" name="parentID" value="<%=TempData.GetInt("parentID", 0)%>" />
                    </div>
                    <div class="tn-form-row tn-text-note">
                       请您将字数限制在 140 以内
                    </div>
                </div>
            </div>
            <%SiteSettings settings = SiteSettingsManager.GetSiteSettings();
              if (settings.VerifyCodeOption == VerifyCodeOption.Enabled || CurrentUser == null && settings.VerifyCodeOption == VerifyCodeOption.Anonymous)
              {%>
            <div class="tn-form-row tn-form-row-verifycode">
                <label>
                    <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon")%></label>
                <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode", VerificationCodeDifficultyLevel.Low)%>
            </div>
            <%} %>
            <div class="tn-form-row tn-form-row-button">
                <%=SPBHtmlHelper.Instance().SubmitButton("submitComment", GetResourceString("Button_Submit"))%>
            </div>
        </div>
    </div>
    </form>

    <script type="text/javascript">
            $(document).ready(function() {
              
                $("#shareCommentForm_<%=threadID %>").validate({
                    rules: {
                        commentBody: { required: true, maxBlength: 140 },
//                        verifyCode: { required: true }
                    },
                    messages: {
                        commentBody: { required: "<%=GetResourceString("Validate_ImpotrCommont", applicationID)%>", maxBlength: "<%=GetResourceString("Description_MaxLenghtWordLimit", applicationID)%>" },
//                        verifyCode: { required: "<%=GetResourceString("Validate_FillInValidate")%>" }
                    }
                });

                $("#submitComment").click(function() {
                if (!$("#shareCommentForm_<%=threadID %>").valid()) {
                        return false;
                    }
                });

                $('#shareCommentForm_<%=threadID %>').ajaxForm({
                    target: '#ListComments_<%=threadID %>',
                    beforeSubmit: function() {
                        $('#shareCommentForm_<%=threadID %>').block({
                            message: '<%=GetResourceString("Message_Loading")%>'
                        });
                    },
                    success: function() {
                        $('#shareCommentForm_<%=threadID %>').unblock();
                    }
                });

                $('.nyroModal').nyroModal({
                    resizeable: true
                });
           });

            function pageIndexChange(url) {
                $('#ListComments_<%=threadID %>').parent().load(url);
            }

    </script>

    <%}
        else { Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Hint, GetResourceString("Message_PopedomNotComment"), false)); } %>
</div>
