﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ShareComment>>" %>
<spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
    SetExpireDays="30" />
<% 
    int threadID = Html.GetParameterFromRouteDateOrQueryString<int>("threadID");
    string controlName = "ListShareCommentsInShareList";
    string sortBy = Html.GetParameterFromRouteDateOrQueryString("sortBy");
    RouteValueDictionary dictionary = new RouteValueDictionary { { "threadID", threadID }, { "controlName", controlName }, { "sortBy", sortBy } };
    int applicationID = ApplicationIDs.Instance().Share();
%>
<div id="ListComments_<%=threadID %>">
    <div class="tn-comment-wrap">
        <%if (Model != null && Model.Records.Count > 0)
          {%>
        <ul class="tn-comments tn-helper-reset">
            <%foreach (var shareComment in ViewData.Model.Records)
              {%>
            <li class="tn-comment-item tn-border-gray tn-border-bottom">
                <div class="tn-comment tn-helper-clearfix">
                    <div class="tn-comment-avatar">
                        <div class="tn-avatar">
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(shareComment.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small)%>
                        </div>
                    </div>
                    <a href="javascript:;" class="tn-icon tn-icon-cross tn-helper-right" onclick="if(confirm('<%=GetResourceString("Message_ConfirmDeleteComment")%>')){$('#ListComments_<%=threadID %>').load('<%=SPBUrlHelper.Action("DeleteShareComment","ChannelShare",new RouteValueDictionary(dictionary){{"commentID",shareComment.CommentID}, { "pageIndex", Model.PageIndex }}) %>')} return false;">
                    </a>
                    <div class="tn-comment-info">
                        <div class="tn-commentator">
                            <%=SPBHtmlHelper.Instance().UserDisplayNameLink(shareComment.UserID,shareComment.Author) %>
                            <em class="tn-text-note tn-date">
                                <%=Formatter.FormatDate(shareComment.DateCreated, true)%></em>
                            <span class="tn-text-note">
                                <% if (CurrentUser != null && shareComment.UserID != CurrentUser.UserID)
                                   { %>
                                <%--<a href="#">回复</a>--%>
                                <%} %>
                            </span>
                        </div>
                        <p>
                            <%=shareComment.Body%></p>
                    </div>
                </div>
            </li>
            <%} %>
        </ul>
        <%if (Model.TotalRecords > Model.PageSize)
          { %>
        <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().AjaxPagingButton(Model.TotalRecords, Model.PageSize, Model.PageIndex, 1, SPBUrlHelper.Action("Control_ListShareComments", "ChannelShare", new RouteValueDictionary(dictionary) { { "pageIndex", "{0}" } }), "pageIndexChange")%>
            <div class="results">
                <%=string.Format(GetResourceString("Description_Pattern_AllCount", applicationID), Model.TotalRecords)%></div>
        </div>
        <%}
          }%>
    </div>
    <% if (SiteSettingsManager.GetSiteSettings().EnableAnonymousPosting || CurrentUser != null)
       {

           if (TempData["StatusMessageType"] != null)
           {
               StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
               Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
               TempData["StatusMessageType"] = null;
           }
    %>
    <form class="tn-helper-reset" name="shareCommentForm_<%=threadID %>" id="shareCommentForm_<%=threadID %>"
    method="post" action="<%=SPBUrlHelper.Action("CreateShareComment","ChannelShare",new RouteValueDictionary(dictionary))%>">
    <div class="tn-form tn-label-top">
        <div class="tn-comment-form-wrap">
            <div class="tn-comment-form">
                <div class="tn-comment-text-wrap tn-border-gray tn-form-row-near">
                    <textarea class="tn-comment-text-area" rows="5" cols="45" name="commentBody" id="commentBody"><%=TempData.GetString("CommentBody",string.Empty) %></textarea>
                    <input type="hidden" id="parentID_<%=threadID %>" name="parentID" value="<%=TempData.GetInt("parentID", 0)%>" />
                </div>
                <%SiteSettings settings = SiteSettingsManager.GetSiteSettings();
                  if (settings.VerifyCodeOption == VerifyCodeOption.Enabled || CurrentUser == null && settings.VerifyCodeOption == VerifyCodeOption.Anonymous)
                  {%>
                <div class="tn-form-row tn-form-row-verifycode">
                    <label>
                        <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon")%></label>
                    <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode",VerificationCodeDifficultyLevel.Low)%>
                </div>
                <%} %>
                <div class="tn-form-row tn-form-row-button">
                    <%=SPBHtmlHelper.Instance().SubmitButton("submitComment_"+threadID.ToString(), GetResourceString("Common_CommentBody"), ButtonSizes.Default,null, null)%>
                    <%=SPBHtmlHelper.Instance().Button("Cancel", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "onclick", "closeCommetsList();" } }, null)%>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">

        $(document).ready(function() {
            $("#commentBody_<%=threadID %>").keyup(function() {
                $("#subjectHint_<%=threadID %>").html(this.value.length + '/' + 140);
            });
            $("#shareCommentForm_<%=threadID %>").validate({
                rules: {
                    commentBody: { required: true, maxBlength: 140 },
                    verifyCode: { required: true }
                },
                messages: {
                    commentBody: { required: "<%=GetResourceString("Validate_ImpotrCommont", applicationID)%>", maxBlength: "<%=GetResourceString("Validate_WordLenLimit", applicationID)%>" },
                    verifyCode: { required: "<%=GetResourceString("Validate_FillInValidate")%>" }
                }
            });

            $("#submitComment_<%=threadID %>").click(function() {
                if (!$("#shareCommentForm_<%=threadID %>").valid()) {
                    return false;
                }
            });

            $('#shareCommentForm_<%=threadID %>').ajaxForm({
                target: '#ListComments_<%=threadID %>',
                beforeSubmit: function() {
                    $('#shareCommentForm_<%=threadID %>').block({
                        message: '<%=GetResourceString("Message_Loading")%>'
                    });
                },
                success: function() {
                    $('#shareCommentForm_<%=threadID %>').unblock();
                }
            });

            $('.nyroModal').nyroModal({
                resizeable: true
            });
        });
        function closeCommetsList() {
            $("#commentForLoad_<%=sortBy %>_<%=threadID %>").hide();
            if($("#switchButton").length  > 0)
            {
                $("#switchButton").find("a").text('<%=GetResourceString("Common_Comment") %>');
            }
        }
        function pageIndexChange(url) {
            $('#ListComments_<%=threadID %>').parent().load(url);
        }
    </script>

    </form>
    <%}
       else { Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Hint, GetResourceString("Message_PopedomNotComment"), false)); }
    %>
</div>
