﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ShareThread>>" %>
<% 
    bool hasManagePermission = CurrentUser != null && CurrentUser.IsContentAdministrator;
    string tagName = ViewData.GetString("tagName", string.Empty);
    ShareThreadSortBy sortBy = ShareThreadSortBy.DateCreated;
    if (ViewData["sortBy"] != null)
        sortBy = (ShareThreadSortBy)ViewData["sortBy"];
    int? siteCategoryID = null;
    int? applicationID = null;
    int? mediaType = null;
    if (ViewData["siteCategoryID"] != null)
        siteCategoryID = (int)ViewData["siteCategoryID"];
    if (ViewData["shareApplicationID"] != null)
        applicationID = (int)ViewData["shareApplicationID"];
    if (ViewData["mediaType"] != null)
        mediaType = (int)ViewData["mediaType"];

    Dictionary<int, Application> applications = Applications.GetApplications();
    string returnUrl = SPBUrlHelper.Action("Control_ListShareThreads", "ChannelShare", new RouteValueDictionary { { "siteCategoryID", siteCategoryID }, { "mediaType", mediaType }, { "applicationID", applicationID }, { "sortBy", sortBy }, { "tagName", tagName }, { "pageIndex", Model.PageIndex } });
       
%>
<div id="ShareThreads_<%=sortBy %>">
    <div class="tn-list-header">
        <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
            <span class="tn-text-note">
                <%if (Model.TotalRecords > 0)
                      Response.Write(string.Format(GetResourceString("Description_Pattern_ShowSomeInAll", ApplicationIDs.Instance().Share()), Model.TotalRecords, (Model.PageIndex - 1) * Model.PageSize + 1, (Model.TotalRecords < Model.PageSize ? Model.TotalRecords : Model.PageIndex * Model.PageSize)));
                  else
                      Response.Write(GetResourceString("Message_NohaveShareOfType", ApplicationIDs.Instance().Share())); %>
            </span>
        </div>
    </div>
    <ul class="tn-list tn-helper-reset">
        <% foreach (ShareThread thread in Model.Records)
           {
               string shareThreadUrl = string.Empty;
               if (thread.ApplicationID > 0)
                   shareThreadUrl = thread.URL;
               else if (thread.MediaType > 0)
                   shareThreadUrl = SiteUrls.Instance().ShowShareThread(thread.ThreadID);
               string shareIconPath = string.Empty;
               if (thread.ApplicationID > 0 && applications.ContainsKey(thread.ApplicationID))
               {
                   shareIconPath = Globals.GetFullUrlInResourceSite(string.Format("~/Themes/Shared/Styles/ApplicationIcons/{0}.png", applications[thread.ApplicationID].ApplicationKey));
               }

               string bgImage = "background: url(&quot;" + thread.ThumbnailUrl + "&quot;) repeat scroll center center transparent;";
               string noBgImage = "background: url(&quot;images/movie.jpg&quot;) repeat scroll center center transparent;";
        %>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-row">
                <h5 class="tn-helper-reset">
                    <%if ((int)thread.MediaType > 0)
                      {
                          switch (thread.MediaType)
                          {
                              case MediaTypes.Music:
                                  Response.Write("&nbsp;" + SPBHtmlHelper.Instance().Icon(IconTypes.Music, thread.GetMultilingualShareTypeName(CurrentUserLanguage), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                                  break;
                              case MediaTypes.Video:
                                  Response.Write("&nbsp;" + SPBHtmlHelper.Instance().Icon(IconTypes.Movie, thread.GetMultilingualShareTypeName(CurrentUserLanguage), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                                  break;
                              case MediaTypes.Website:
                                  Response.Write("&nbsp;" + SPBHtmlHelper.Instance().Icon(IconTypes.World, thread.GetMultilingualShareTypeName(CurrentUserLanguage), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                                  break;
                              default:
                                  Response.Write("&nbsp;" + SPBHtmlHelper.Instance().Icon(IconTypes.World, thread.GetMultilingualShareTypeName(CurrentUserLanguage), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                                  break;
                          }
                      }
                      else
                      {%>
                    <img src="<%=shareIconPath %>" height="16px" width="16px" />
                    <% }%>
                    <a href="<%=shareThreadUrl %>">
                        <%=StringUtils.Trim(thread.Subject,45) %></a></h5>
            </div>
            <div class="tn-list-item-row tn-helper-clearfix">
                <div class="tn-list-item-area-left">
                    <%if (thread.MediaType == MediaTypes.Video)
                      { %>
                    <div class="spb-video-cover tn-img-sprite">
                        <div class="spb-video-cover-source" <%if (string.IsNullOrEmpty(thread.ThumbnailUrl)) Response.Write("style=\"" + noBgImage + "\""); else Response.Write("style=\"" + bgImage + "\""); %>>
                            <a href="<%=shareThreadUrl %>">
                                <div class="tn-widget-content tn-corner-all">
                                    <span class="tn-icon tn-icon-play">
                                        <%=GetResourceString("Action_Play", ApplicationIDs.Instance().Share())%></span>
                                </div>
                            </a>
                        </div>
                    </div>
                    <%}
                      else if (!string.IsNullOrEmpty(thread.ThumbnailUrl) && thread.ApplicationID != ApplicationIDs.Instance().User())
                      {%>
                    <a href="<%=shareThreadUrl %>" title="<%=thread.Subject %>">
                        <img src="<%=thread.ThumbnailUrl %>" alt="" style="width: 100px; height: 75px" /></a>
                    <%}
                      else if (thread.ApplicationID == ApplicationIDs.Instance().User())
                      {%>
                    <div class="tn-avatar">
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(thread.UserID, true,HyperLinkTarget._blank, AvatarSizeTypes.Small) %>
                    </div>
                    <%}%>
                </div>
                <div class="tn-list-item-area-right">
                    <div class="tn-list-figure tn-widget">
                        <div class="tn-list-figure-count tn-widget-content tn-corner-top">
                            <%=thread.StageUserCount %></div>
                        <%if (CurrentUser == null)
                          { %>
                        <a href="<%=SiteUrls.Instance().Login(true) %>" class="tn-list-figure-button tn-state-default tn-corner-bottom">
                            <%=GetResourceString("Action_Share", ApplicationIDs.Instance().Share())%></a>
                        <%}
                          else
                          { %>
                        <a href="<%=SiteUrls.Instance().ShareInModal(thread.ThreadID,false) %>" id="shareButton_<%=thread.ThreadID %>"
                            name="shareButton" class="tn-list-figure-button tn-state-default tn-corner-bottom nyroModal">
                            <%=GetResourceString("Action_Share", ApplicationIDs.Instance().Share())%></a>
                        <%} %>
                    </div>
                </div>
                <div class="tn-list-item-area-main">
                    <div class="tn-list-item-row tn-list-item-heading">
                        <cite>
                            <a href="<%=thread.URL %>">
                                <%=StringUtils.Trim(WebUtils.FullPath(thread.URL), 24)%></a></cite>
                    </div>
                    <div class="tn-list-item-row">
                        <cite>
                            <%=SPBHtmlHelper.Instance().UserDisplayNameLink(thread.UserID,thread.Author,ApplicationIDs.Instance().Share()) %>
                        </cite><em class="tn-date tn-text-note">
                            <%=GetResourceString("Label_ShareTo",ApplicationIDs.Instance().Share())%>
                            <%=Formatter.FormatFriendlyDate(thread.DateCreated) %></em>
                    </div>
                    <%if (thread.MediaType == MediaTypes.Music)
                      { %>
                    <div class="tn-list-item-row">
                        <span class="tn-button tn-button-text-icon tn-button-default">
                            <span class="tn-first-child">
                                <span class="tn-icon tn-icon-play"></span>
                                <a href="<%=shareThreadUrl %>" class="tn-button-text">
                                    <%=GetResourceString("Action_PlayMusic", ApplicationIDs.Instance().Share())%></a>
                            </span>
                        </span>
                    </div>
                    <%} %>
                    <div class="tn-list-item-row tn-list-item-summary">
                        <p class="tn-helper-reset">
                            <%=StringUtils.Trim(thread.Body,100) %></p>
                    </div>
                </div>
            </div>
            <%if ((int)thread.MediaType > 0)
              { %>
            <div class="tn-list-item-row">
                <span class="tn-action tn-action-text-icon">
                    <span class="tn-icon tn-icon-bubble"></span>
                    <a class="tn-action-text" name="commentButton" id="commentButton" href="javascript:;"
                        value="<%=thread.ThreadID %>">
                        <%=GetResourceString("Common_Comment")%>(<%=thread.CommentCount %>)</a>
                </span>
                <span class="tn-action tn-action-text-icon">
                    <span class="tn-icon tn-icon-view"></span>
                    <a class="tn-action-text" href="<%=shareThreadUrl %>">
                        <%=GetResourceString("Common_Browse") %>(<%=thread.HitTimes %>)</a>
                </span>
            </div>
            <%} %>
            <div class="tn-simple-comments spb-share-comment" style="display: none" id="commentForLoad_<%=sortBy %>_<%=thread.ThreadID %>">
                <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-top">
                    <div class="tn-bubble-box-arrow">
                        <b class="tn-arrow-b1 tn-widget-content"></b>
                        <b class="tn-arrow-b2 tn-widget-content"></b>
                        <b class="tn-arrow-b3 tn-widget-content"></b>
                        <b class="tn-arrow-b4 tn-widget-content"></b>
                        <b class="tn-arrow-b5 tn-widget-content"></b>
                    </div>
                    <div id="comments_<%=sortBy %>_<%=thread.ThreadID %>" class="tn-bubble-box-content tn-widget-content tn-corner-all"
                        value="<%=SPBUrlHelper.Action("Control_ListShareComments","ChannelShare",new RouteValueDictionary{{"threadID",thread.ThreadID},{"controlName","ListShareCommentsInShareList"},{"sortBy",sortBy}}) %>">
                    </div>
                </div>
            </div>
        </li>
        <%} %>
    </ul>
    <%if (Model.TotalRecords > Model.PageSize)
      { %>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(Model.TotalRecords, Model.PageSize, Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListShareThreads", "ChannelShare", new RouteValueDictionary {{ "siteCategoryID", siteCategoryID }, { "mediaType", mediaType }, { "applicationID", applicationID },{"sortBy",sortBy},{ "tagName", WebUtils.UrlEncode(tagName) },{ "pageIndex", "{0}" } }), "pageIndexChange")%>
        <div class="tn-page-results tn-text-note">
        </div>
    </div>
    <%} %>

    <script type="text/javascript">
        var ListShareThreadsID = "ShareThreads_<%=sortBy %>";
        $(document).ready(function() {
            $("a[name='shareButton'],a[name='impeachButton']").nyroModal({
                width: 500
            });
            $("a[name='updateButton']", $('#' + ListShareThreadsID)).nyroModal({
                endRemove: function(elts, settings) {
                    $('#' + ListShareThreadsID).parent().load("<%=returnUrl %>");
                }
            });
            $("a[name='commentButton']", $('#' + ListShareThreadsID)).click(function(e) {
                var $comments = $("#comments_<%=sortBy %>_" + $(this).attr("value"));
                var $commentForLoad = $("#commentForLoad_<%=sortBy %>_" + $(this).attr("value"));
                if ($commentForLoad.is(":hidden")) {
                    $commentForLoad.show();
                    if (!$comments.find("div").length) {
                        $comments.load($comments.attr("value"));
                    }
                }
                else {
                    $commentForLoad.hide();
                }
            });
            $("a[name='deleteButton']").click(function() {
                if (confirm('<%=GetResourceString("Message_ConfirmDeleteShare", ApplicationIDs.Instance().Share())%>'))
                    $('#' + ListShareThreadsID).parent().load($(this).attr("value"));
                return false;
            });
        });
        function pageIndexChange(url) {
            $('#' + ListShareThreadsID).parent().load(url);
        }
    </script>

</div>
