﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<ShareThread>>" %>
<%
    bool hasBorder = Html.GetParameterFromRouteDateOrQueryString<bool>("hasBorder");
    if (Model != null && Model.Count > 0)
    {
        if (hasBorder)
        {%>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-share-today-url">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=Html.GetParameterFromRouteDateOrQueryString("moduleTitle")%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-list">
      <li class="tn-list-first tn-border-gray tn-border-bottom">
        <div class="tn-list-item-area-main">
          <div class="tn-list-item-row tn-list-item-heading">
            <h5 class="tn-helper-reset"> <a title="<%=Model[0].Subject%>" href="<%=SiteUrls.Instance().ShowShareThread(Model[0].ThreadID) %>"> <%=StringUtils.Trim(Model[0].Subject, 15)%></a></h5>
          </div>
          <div class="tn-list-item-row"> <cite class="tn-text-note"> <%=SPBHtmlHelper.Instance().UserDisplayNameLink(Model[0].UserID,Model[0].Author) %> </cite><em class="tn-date tn-text-note">&nbsp;<%=GetResourceString("Label_Share", ApplicationIDs.Instance().Share())%><%=GetResourceString("Common_Colon")%><%=Model[0].UserCount%></em> </div>
          <div class="tn-list-item-row"> <a target="_blank" class="tn-url" title="<%=Model[0].Subject%>" href="<%=SiteUrls.Instance().ShowShareThread(Model[0].ThreadID) %>"> <%=Model[0].URL%></a> </div>
          <div class="tn-list-item-row tn-list-item-summary">
            <p> <%=Model[0].Body%></p>
          </div>
        </div>
      </li>
      <%for (int i = 1; i < Model.Count; i++)
              {
            %>
      <li class="tn-helper-clearfix"><em class="tn-text-note tn-date"> <%=Formatter.FormatDate(Model[i].DateCreated)%></em><em class="tn-count tn-text-note"><%=Model[i].UserCount%></em> <cite class="tn-secondary-text"> <%=SPBHtmlHelper.Instance().UserDisplayNameLink(Model[i].UserID,Model[i].Author) %> </cite><a href="<%=SiteUrls.Instance().ShowShareThread(Model[i].ThreadID) %>" title="<%=Model[i].Subject%>"> <%=StringUtils.Trim(Model[i].Subject, 17)%></a> </li>
      <%}%>
    </ul>
    <p class="tn-more"><a href="<%=SPBUrlHelper.Action("ShareRanks","ChannelShare",new RouteValueDictionary{{"mediaType",(int)MediaTypes.Website},{"applicationID",Html.GetParameterFromRouteDateOrQueryString("applicationID") }}) %>"> <%=GetResourceString("Action_More")%></a></p>
  </div>
</div>
<%
    }
        else
        {%>
<ul class="tn-list">
  <%foreach (ShareThread thread in Model)
      {
    %>
  <li class="tn-img-sprite tn-list-bullet"><cite class="tn-helper-right tn-secondary-text"> <%=SPBHtmlHelper.Instance().UserDisplayNameLink(thread.UserID,thread.Author) %> </cite><a href="<%=SiteUrls.Instance().ShowShareThread(thread.ThreadID) %>" title="<%=thread.Subject%>"> <%=StringUtils.Trim(thread.Subject, 50)%></a> </li>
  <%}%>
</ul>
<%  }
    }%>
