﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<UserShareThread>>" %>
<%int userID = 0;
  if (ViewData["userID"] != null)
      userID = (int)ViewData["userID"];
  ShareThread thread = ViewData.Get<ShareThread>("shareThread", new ShareThread());

  int mediaType = 1;
  if (ViewData["MediaType"] != null)
  {
      mediaType = (int)ViewData["MediaType"];
  }

  int applicationID = ApplicationIDs.Instance().Share();
  IList<UserShareThread> friendShareThreads = null;
  if (ViewData["friendsShareThreads"] != null)
      friendShareThreads = ViewData.Get<IList<UserShareThread>>("friendsShareThreads");
  if (userID > 0 && friendShareThreads != null && friendShareThreads.Count > 0)
  {
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <span class="tn-helper-right"><a href="#"></a></span>
        <h3 class="tn-helper-reset">
            <%if (mediaType == 1)
                  Response.Write(GetResourceString("Title_ShareMediaFriend", applicationID));
              else
                  Response.Write(GetResourceString("Title_ShareMusicFriend", applicationID)); %>
        </h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-avatar-list tn-helper-reset">
            <%  
                int i = 0;
                foreach (UserShareThread friendShareThread in friendShareThreads)
                {
                    if (i > 9)
                        break;
            %>
            <li class="tn-avatar-item">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(friendShareThread.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></div>
                <%=SPBHtmlHelper.Instance().UserDisplayNameLink(friendShareThread.UserID,friendShareThread.Author) %>
            </li>
        </ul>
        <%} %>
    </div>
</div>
<div class="tn-blank10">
</div>
<%  } %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%if (mediaType == 1)
                  Response.Write(GetResourceString("Title_ShareMediaMember", applicationID));
              else
                  Response.Write(GetResourceString("Title_MemberShareMusic", applicationID)); %>
        </h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-avatar-list tn-helper-reset">
            <% int j = 0;
               if (Model.Count > 0)
               {
                   foreach (UserShareThread userShareThread in Model)
                   {
                       if (thread.UserID == userShareThread.UserID || userShareThread.UserID == (CurrentUser != null ? CurrentUser.UserID : 0))
                           continue;%>
            <li class="tn-avatar-item">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(userShareThread.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></div>
                <%=SPBHtmlHelper.Instance().UserDisplayNameLink(userShareThread.UserID, userShareThread.Author)%>
                <span class="tn-text-note"></span></li>
            <%
                j++;
                   }
               }
               if (j <= 0)
               {%>
            <p>
                <%=GetResourceString("Description_MemberShareNotFound", applicationID)%></p>
            <%} %>
        </ul>
    </div>
</div>
