﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<ShareThread>" %>
<div class="spb-share-to">
    <%
        if (TempData["StatusMessageData"] != null)
        {
            StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", null);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData));

            //关闭模式窗口
            if (messageData.MessageType == StatusMessageType.Success)
                Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('if($.nyroModalRemove)$.nyroModalRemove();else self.close();',2000)</script>"));

            TempData["StatusMessageData"] = null;
        }
        else
        {
            int maxLengthForBody = ShareConfiguration.Instance().MaxLengthForBody;
            int maxLengthPerReply = ShareConfiguration.Instance().MaxLengthPerReply;

            string selectedMenu = Html.GetParameterFromRouteDateOrQueryString("selectedMenu");
            string userDomainName = CurrentUser != null ? CurrentUser.UserName : string.Empty;
            RouteValueDictionary routeValueDictionary = new RouteValueDictionary();
            if (Model.ApplicationID > 0)
                routeValueDictionary = new RouteValueDictionary() { { "allowToClub", ViewData.GetBool("allowToClub", false) }, { "url", WebUtils.UrlEncode(Model.URL) }, { "subject", WebUtils.UrlEncode(Model.Subject) }, { "body", WebUtils.UrlEncode(Model.Body) }, { "thumbnailUrl", WebUtils.UrlEncode(Model.ThumbnailUrl) }, { "applicationID", Model.ApplicationID }, { "contentUserID", Model.ContentUserID }, { "contentAuthor", WebUtils.UrlEncode(Model.ContentAuthor) }, { "userDomainName", userDomainName } };%>
    <div class="tn-tabs tn-widget" id="shareTo_<%=Model.ThreadID %>">
        <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
            <li class="tn-widget-content tn-border-gray tn-border-trl tn-tabs-selected"><a href="javascript:;" id="shareToMyShare"><span>
                <%=GetResourceString("Action_AddToMyShare",ApplicationIDs.Instance().Share())%></span></a></li>
            <li class="tn-widget-content tn-border-gray tn-border-trl"><a href="javascript:;" id="shareToMyFriends"><span>
                <%=GetResourceString("Action_ShareToMyFirends",ApplicationIDs.Instance().Share())%></span></a></li>
            <%if (ViewData.GetBool("allowToClub", false) && Applications.IsEnabled(ApplicationIDs.Instance().Club()))
              { %>
            <li class="tn-widget-content tn-border-gray tn-border-trl"><a href="javascript:;" id="shareToMyClubs"><span>
                <%=GetResourceString("Action_ShareToMyClubs",ApplicationIDs.Instance().Share())%></span></a></li>
            <% }%>
        </ul>
        <div class="tn-tabs-panel tn-widget-content tn-border-gray tn-border-top" id="tabsInModal-1">
            <form class="tn-helper-reset nyroModal" action="<%=SPBUrlHelper.Action("CreateUserShareThread","ChannelShare",new RouteValueDictionary{{"threadID",Model.ThreadID}}) %>" id="shareToForm" method="post">
            <input type="hidden" name="applicationID" value="<%=Model.ApplicationID %>" />
            <input type="hidden" name="contentUserID" value="<%=Model.ContentUserID%>" />
            <input type="hidden" name="contentAuthor" value="<%=Model.ContentAuthor%>" />
            <input type="hidden" id="mediaType" name="mediaType" value="<%=(int)Model.MediaType %>" />
            <input type="hidden" id="playerUrl" name="playerUrl" value="<%=Model.PlayerUrl %>" />
            <input type="hidden" id="ThumbnailUrl" name="ThumbnailUrl" value="<%=Model.ThumbnailUrl %>" />
            <input type="hidden" id="body" name="body" value="<%=Model.Body %>" />
            <input type="hidden" id="subject" name="subject" value="<%=Model.Subject %>" />
            <input type="hidden" id="url" name="url" value="<%=Model.URL %>" />
            <div class="tn-form tn-label-right">
                <div class="tn-form-row spb-select-user tn-form-expanded tn-helper-clearfix" id="selectUserFrients" style="display: none">
                    <label class="tn-form-label">
                        <%=GetResourceString("Title_SelectFirends",ApplicationIDs.Instance().Share())%><%=GetResourceString("Common_Colon") %></label>
                    <% Html.RenderAction<ChannelController>(n => n.Control_FriendSelector("receiverIDs", string.Empty, 10)); %>
                </div>
                <div class="tn-form-row tn-helper-clearfix" id="Title" style="display: none">
                    <label class="tn-form-label">
                        <%=GetResourceString("Label_Subject",ApplicationIDs.Instance().Share())%><%=GetResourceString("Common_Colon") %></label>
                    <input type="text" name="Title" class="tn-textbox tn-border-gray" />
                </div>
                <div class="tn-form-row tn-helper-clearfix tn-textarea-wrap">
                    <div class="tn-form-label">
                        <div class="tn-avatar">
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(CurrentUser !=null ? CurrentUser.UserID : 0,true,HyperLinkTarget._blank,AvatarSizeTypes.Small) %></div>
                    </div>
                    <textarea class="tn-textarea tn-border-gray" rows="" cols="" id="commentBody" name="commentBody"></textarea>
                    <span style="display: none"></span>
                </div>
                <div class="tn-form-row tn-helper-clearfix" id="selectPrivacyStatus">
                    <label class="tn-form-label">
                        <%=GetResourceString("Label_BrowsePopedom", ApplicationIDs.Instance().Share())%><%=GetResourceString("Common_Colon") %></label>
                    <%=SPBHtmlHelper.Instance().PrivacyStatusesDropDownList("privacyStatus", "tn-dropdownlist", null, string.Empty)%>
                </div>
                <div class="tn-form-row tn-write-tags tn-form-expanded tn-helper-clearfix" id="selectUserTags">
                    <label class="tn-form-label">
                        <%=ResourceManager.GetString ("Common_UserTag",Globals.GetCurrentUserLanguage())%><%=GetResourceString("Common_Colon") %></label>
                    <%ViewData["TagInputName"] = "userTags";
                      ViewData["userTagItemKey"] = UserTagItemKeys.Instance().UserShareThread();%>
                    <%Html.RenderPartial("Controls/UserTagSelector.ascx", ViewData);%>
                </div>
                <div class="spb-share-details tn-border-gray tn-bg-gray">
                    <% if (Model.UserID > 0)
                       { %>
                    <p>
                        <%=GetResourceString("Description_From", ApplicationIDs.Instance().Share())%>
                        <%=SPBHtmlHelper.Instance().UserDisplayNameLink(Model.ContentUserID, Model.Author)%>
                    </p>
                    <%}
                       else
                       { %>
                    <p>
                        <%=GetResourceString("Description_From", ApplicationIDs.Instance().Share())%><%=Model.Author%></p>
                    <%} %>
                    <p>
                        <strong>
                            <%=Model.Subject %></strong></p>
                    <p>
                        <%=StringUtils.Trim(Model.Body, 100)%></p>
                </div>
                <div class="tn-form-row tn-form-row-button">
                    <label class="tn-form-label">
                    </label>
                    <%=SPBHtmlHelper.Instance().SubmitButton("newShareInDialogButton", GetResourceString("Action_Share", ApplicationIDs.Instance().Share()),ButtonSizes.Large,null,null)%>
                    <%=SPBHtmlHelper.Instance().Button("cancelButton", GetResourceString("Action_CancelInput", ApplicationIDs.Instance().Share()), ButtonSizes.Large, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "nyroModalClose" } },null)%>
                </div>
            </div>
            </form>
        </div>
        <div class="tn-tabs-panel tn-widget-content tn-border-gray tn-border-top" id="tabsInModal-2" style="display: none">
        </div>
    </div>
</div>
<script type="text/javascript">
           $(document).ready(function() {
               $("#shareToForm").validate({
                   rules: {
                       subject: { required: true, maxBlength: 80 },
                       body: { maxBlength:<%=maxLengthForBody %>  },
                       commentBody: { maxBlength:<%=maxLengthPerReply %>  }
                   },
                   messages: {
                       subject: { required: "<%=GetResourceString("Validate_MustImport", ApplicationIDs.Instance().Share())%>", maxBlength: "<%=GetResourceString("Validate_MostChar", ApplicationIDs.Instance().Share())%>" },
                       body: { maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_MostImportChar", ApplicationIDs.Instance().Share()), maxLengthForBody)%>" },
                       commentBody: { maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_MostImportChar", ApplicationIDs.Instance().Share()), maxLengthForBody)%>" }
                   }
               });
               $('ul.tn-tabs-nav',$('#shareTo_<%=Model.ThreadID %>')).find("a").click(function(event){
                   defaultSelected(this.id);
               });
               $('#privacyStatus_Password').attr("style","width:100px");
           });
           function defaultSelected(id)
           {
               $("#"+id).parent().addClass("tn-tabs-selected").siblings().removeClass("tn-tabs-selected");
               $("#tabsInModal-1").show();
               if(id == 'shareToMyShare')
               {

                  $("#shareToForm").attr("action",'<%=SPBUrlHelper.Action("CreateUserShareThread","ChannelShare",new RouteValueDictionary() { { "threadID", Model.ThreadID } }) %>');

                  $("#privacyStatus,#selectPrivacyStatus,#selectUserTags").show();
                  $("#Title,#selectUserFrients,#tabsInModal-2").hide();
               }
               else if(id == 'shareToMyFriends')
               {
                  $("#shareToForm").attr("action",'<%=SPBUrlHelper.Action("ShareToFriends", "UserDomainShare", new RouteValueDictionary() { { "threadID", Model.ThreadID }, { "userDomainName", userDomainName } })%>');

                  $("#privacyStatus,#selectPrivacyStatus,#selectUserTags,#tabsInModal-2").hide();
                  $("#Title,#selectUserFrients").show();
               }
               else if(id == 'shareToMyClubs')
               {
                  $("#tabsInModal-1").hide();
                  $("#tabsInModal-2").show();
                  $("#tabsInModal-2").load('<%=SiteUrls.Instance().ShareToMyClubs(Model.ApplicationID, HtmlUtils.TrimHtml(Model.Subject,30), HtmlUtils.TrimHtml(Model.Body, 150),Model.ThumbnailUrl,Model.URL, Model.Author,CurrentUser !=null ? CurrentUser.DisplayName : string.Empty , Model.ContentUserID,CurrentUser !=null ? CurrentUser.UserID : 0)%>');
               }
           }
</script>
<%} %>