﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    List<Link> ListLinks = null;
    List<LinkCategory> listLinkCategory = null;
    LinkCategory linkCategory = null;
    if (ViewData["ListLinks"] != null)
        ListLinks = ViewData["ListLinks"] as List<Link>;
    if (ViewData["Category"] != null)
        linkCategory = ViewData["Category"] as LinkCategory;
    if (ViewData["Categories"] != null)
        listLinkCategory = ViewData["Categories"] as List<LinkCategory>;
%>
<%        
    if (ListLinks != null && ListLinks.Count > 0)
    {
        if (linkCategory != null)
        {
%>

<div class="tn-net-links tn-border-light tn-border-bottom">
  <ul class="tn-helper-clearfix">
    <li><strong> <%=linkCategory.CategoryName %><%=GetResourceString("Common_Colon") %> </strong></li>
    <%
                bool isShowMore = false;
                int i = 0;
                foreach (var itemLink in ListLinks)
                {
                    i++;
                    if (i > 8)
                    {
                        isShowMore = true;
                        break;
                    }
                    if (itemLink.LinkType == LinkTypes.Text)
                    {
                        Response.Write(string.Format("<li><a target=\"_blank\" title=\"{0}\" href=\"{1}\">{2}</a></li>", itemLink.LinkTitle, itemLink.LinkHref, itemLink.Title));
                    }
                    else
                    {
                        Response.Write(string.Format("<li><a target=\"_blank\" title=\"{0}\" href=\"{1}\"><img src=\"{2}\" /></a></li>", itemLink.LinkTitle, itemLink.LinkHref, SiteUrls.Instance().LinkPhoto(itemLink, LinkPosition.Site)));
                    }
                }
            %>
  </ul>
  <%if (isShowMore)
          {  %>
  <p class="tn-more"> <a target="_blank" title="<%=GetResourceString("Title_MoreLink") %>" href="<%=SPBUrlHelper.Action("ShowAllLinks", "Channel")%>"> <%=GetResourceString("Action_More")%>...</a></p>
  <%} %>
</div>
<%
    }
        else
        {
            if (listLinkCategory != null)
            {
%>
<div class="tn-net-links tn-border-light tn-border-bottom">
  <%
            int i = 0;
            bool isShowMore = false;
            for (int m = 0; m < listLinkCategory.Count; m++)
            {
                Link tempLink = ListLinks.Find(delegate(Link obj) { return obj.CategoryID == listLinkCategory[m].CategoryID; });
                if (tempLink == null)
                {
                    if (m == listLinkCategory.Count - 1 && isShowMore)
                    {
        %>
  <p class="tn-more"> <a target="_blank" title="<%=GetResourceString("Title_MoreLink") %>" href="<%=SPBUrlHelper.Action("ShowAllLinks", "Channel")%>"> <%=GetResourceString("Action_More")%></a></p>
  <%
            }
                    continue;
                }
        %>
  <ul class="tn-helper-clearfix">
    <li><strong> <%=listLinkCategory[m].CategoryName%><%=GetResourceString("Common_Colon") %> </strong></li>
    <%
                foreach (var itemLink in ListLinks)
                {
                    if (itemLink.CategoryID != listLinkCategory[m].CategoryID)
                        continue;
                    i++;
                    if (i > 8)
                    {
                        isShowMore = true;
                        break;
                    }
                    if (itemLink.LinkType == LinkTypes.Text)
                    {
                        Response.Write(string.Format("<li><a target=\"_blank\" title=\"{0}\" href=\"{1}\">{2}</a></li>", itemLink.LinkTitle, itemLink.LinkHref, itemLink.Title));
                    }
                    else
                    {
                        Response.Write(string.Format("<li><a target=\"_blank\" title=\"{0}\" href=\"{1}\"><img src=\"{2}\" /></a></li>", itemLink.LinkTitle, itemLink.LinkHref, SiteUrls.Instance().LinkPhoto(itemLink, LinkPosition.Site)));
                    }
                }
                i = 0;%>
    <%if (m == listLinkCategory.Count - 1 && isShowMore)
              {
            %>
    <p class="tn-more"> <a target="_blank" title="<%=GetResourceString("Title_MoreLink") %>" href="<%=SPBUrlHelper.Action("ShowAllLinks", "Channel")%>"> <%=GetResourceString("Action_More")%></a></p>
    <%    } %>
  </ul>
  <%  } %>
</div>
<%          }
        }
    } 
%>
