﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<PersonUser>>" %>
<ul id="listUsersUL" class="tn-list tn-helper-clearfix">
    <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
      RouteValueDictionary CurrentRouteValueDictionary = ViewData.Get<RouteValueDictionary>("CurrentRouteValueDictionary", new RouteValueDictionary());

      if (Model.Records != null && Model.Records.Count > 0)
      {
          foreach (PersonUser pu in Model.Records)
          {%>
    <li class="tn-list-item">
        <div class="tn-list-item-area-left">
            <input class="tn-checkbox" type="checkbox" name="personUserCheckBoxGroup" value="<%=pu.UserID %>" />
        </div>
        <div class="tn-list-item-area-left">
            <div class="tn-avatar">
                <%=SPBHtmlHelper.Instance().ShowUserAvatar(pu.UserID,true,HyperLinkTarget._blank,AvatarSizeTypes.Small) %></div>
        </div>
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row tn-list-item-heading">
                <strong><a href="<%=SiteUrls.Instance().UserDomainHome(pu.UserID) %>">
                    <%=SPBHtmlHelper.Instance().UserDisplayName(pu) %></a></strong>
            </div>
            <div class="tn-list-item-row tn-list-item-summary">
                <p class="tn-description">
                    <% int gender = (int)pu.Gender;
                       if (gender == 1)
                           Response.Write(GetResourceString("Enum_Genders_Male"));
                       else
                           Response.Write(GetResourceString("Enum_Genders_Female"));
                       if (pu.Age > 0)
                           Response.Write("，" + pu.Age.ToString());
                    %>
                </p>
                <p class="spb-user-tags">
                    <%  List<string> listTags = UserTagManager.Instance(UserTagItemKeys.Instance().Person()).GetUserTagsOfItem(pu.UserID, false);
                        int i = 0;
                        foreach (string tag in listTags)
                        { %>
                    <a href="javascript:;" onclick='$("#listUsersUL").parent().load("<%=SPBUrlHelper.Action("Control_ListPersonInWizardMode", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName }, { "TagName", tag } })%>")'>
                        <%=tag %></a>
                    <%i++;
                      if (i > 1)
                          break;

                        } %>
                </p>
            </div>
        </div>
    </li>
    <%}
      }
      else
      {%>
    <div class="tn-no-data">
        还没有好友可以推荐给你！</div>
    <%} %>
</ul>
<div class="tn-pagination">
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 1, SPBUrlHelper.Action(CurrentRouteValueDictionary.Keys.Count == 0 ? "Control_ListTopPersonInWizardMode" : "Control_ListPersonInWizardMode", "ChannelUser", new RouteValueDictionary(CurrentRouteValueDictionary) { { "userDomainName", WebUtils.UrlEncode(userDomainName) }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
</div>
<div class="tn-form-row">
    <label for="checkboxAll">
        <input class="tn-checkbox" type="checkbox" id="checkboxAll" onclick="checkAll(this,'personUserCheckBoxGroup')" />
        全选</label>
    <em>你已经选择 <strong id="checkNumber">0</strong> 位好友</em>
</div>
<div class="tn-form-row-button">
    <%=SPBHtmlHelper.Instance().LinkButton("addFriends", "添加已选用户为好友", SPBUrlHelper.Action("Control_BatchCreateFriendInvitations", "ChannelUser", new RouteValueDictionary { { "userDomainName",WebUtils.UrlEncode(userDomainName) } }), ButtonSizes.Large, HighlightStyles.Primary, null, TextIconLayout.TextOnly, new RouteValueDictionary { { "class", "nyroModal" } }, null)%>
    <span class="tn-button tn-button-large tn-button-default tn-button-text-icon-right">
        <span class="tn-first-child"><a id="complete" href="<%=SPBUrlHelper.Action("Control_SetShowWizardMode", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"
            class="tn-button-text nyroModal">跳过<span class="tn-icon tn-icon-slide-next"></span></a>
        </span></span>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $('#addFriends').click(function () {
            if ($("input[name='personUserCheckBoxGroup']:checked").length <= 0) {
                alert("至少选择一个用户！");
                return false;
            }
        });

        $('#complete,#addFriends').nyroModal({
            resizeable: true,
            height: 300,
            width: 200
        });
        document.getElementById("checkNumber").innerHTML = $("input[name='personUserCheckBoxGroup']:checked").size();

        $('input:checkbox').change(function () {
            document.getElementById("checkNumber").innerHTML = $("input[name='personUserCheckBoxGroup']:checked").size();
        });

    });
    function pageIndexChange(url) {
        $("#listUsersUL").parent().load(url);
    }
</script>
