﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<div id="loginInModal" class="spb-login-modal">
    <%   int applicationID = ApplicationIDs.Instance().User();
         int? accountType = Request.QueryString.Get<int?>("accountType", null);
         string openID = Html.GetParameterFromRouteDateOrQueryString("openID");
         string OauthToken = Html.GetParameterFromRouteDateOrQueryString("OauthToken");
         string OauthTokenSecret = Html.GetParameterFromRouteDateOrQueryString("OauthTokenSecret");
         bool enableSina = !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["Sina_AppKey"]) && !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["Sina_AppSecret"]);
         bool enableQQ = !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["QQ_AppKey"]) && !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["QQ_AppSecret"]);%>
    <form id="loginInModalForm" name="loginInModalForm" action="<%=SPBUrlHelper.Action("LoginAction","ChannelUser",new RouteValueDictionary{{"loginInModal",true},{"returnUrl",WebUtils.UrlEncode(Html.GetParameterFromRouteDateOrQueryString("returnUrl"))},{"accountType",accountType},{"openID",openID}, { "OauthToken", OauthToken }, { "OauthTokenSecret", OauthTokenSecret }}) %>"
    method="post">
    <div class="tn-form tn-label-right">
        <div class="tn-form-row">
            <label for="loginInModalUserName" class="tn-form-label">
                <%=GetResourceString("Label_UserCount",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input class="tn-textbox tn-input-medium tn-border-gray valid" type="text" id="loginInModalUserName"
                name="loginInModalUserName" size="25" maxlength="64" value="<%=TempData.GetString("userName",string.Empty) %>" />
        </div>
        <div class="tn-form-row">
            <label for="loginInModalPassword" class="tn-form-label">
                <%=GetResourceString("Common_Password")%><%=GetResourceString("Common_Colon") %></label>
            <input class="tn-textbox tn-input-medium tn-border-gray valid" type="password" id="loginInModalPassword"
                name="loginInModalPassword" size="25" maxlength="64" value="<%=TempData.GetString("password",string.Empty) %>" />
        </div>
        <div class="tn-form-row">
            <label class="tn-form-label">
            </label>
            <input class="tn-checkbox" type="checkbox" id="loginInModalAutoLogin" name="loginInModalAutoLogin"
                value="true" />
            <label for="loginInModalAutoLogin">
                <%=GetResourceString("Label_RememberPassword",applicationID)%></label>
            &nbsp;&nbsp; <a href="<%=SiteUrls.Instance().ForgotPassword() %>">
                <%=GetResourceString("Action_ForgetThePassword",applicationID)%></a>
        </div>
        <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label">
            </label>
            <%=SPBHtmlHelper.Instance().SubmitButton("loginInModalSubmitButton", GetResourceString("Action_Login"))%>
            <%=SPBHtmlHelper.Instance().CloseButton(ButtonSizes.Large, new RouteValueDictionary { { "class", "dialogClose" } })%>
        </div>
    </div>
    </form>
    <% if (string.IsNullOrEmpty(openID) && (enableSina || enableQQ))
       { %>
    <div class="spb-third-id-login tn-border-gray tn-border-top">
        <strong>使用第三方账号登录</strong>
        <p class="tn-helper-clearfix">
            <%if (enableSina)
              { %>
            <a href="javascript:;" onclick="openSina();return false;" class="tn-img-sprite spb-third-id-btn spb-third-id-sina">
                使用新浪微博账号登录</a>
            <%}
              if (enableQQ)
              { %>
            <a href="javascript:;" onclick="openQQ();return false;" class="tn-img-sprite spb-third-id-btn spb-third-id-qq">
                使用QQ号登录</a>
            <%} %></p>
    </div>
    <%} %>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $("#loginInModalUserName").watermark('<%=GetResourceString("Validate_PleaseUserNameOrEmail_Required",applicationID)%>').focus();
        $("#loginInModalForm").validate({
            rules: {
                loginInModalUserName: "required",
                loginInModalPassword: "required"
            },
            messages: {
                loginInModalUserName: '<%=GetResourceString("Validate_PleaseUserNameOrEmail_Required",applicationID)%>',
                loginInModalPassword: '<%=GetResourceString("Validate_PleasePassword_Required",applicationID)%>'
            }
        });
        $("#loginInModalForm").keypress(function (e) {
            if (e.which == 13)
                this.submit();
        });
        $("#loginInModalForm").submit(function () {
            if (!$("#loginInModalForm").valid()) {
                return false;
            }
        });
    });
    function openQQ() {
        var A = window.open("<%=SiteUrls.Instance().LoginToQQ() %>", "TencentLogin", "width=600,height=500,menubar=0,scrollbars=0, status=1,titlebar=0,toolbar=0,location=1");
    }
    function openSina() {
        var B = window.open("<%=SiteUrls.Instance().LoginToSina() %>", "SinaLogin", "width=600,height=500,menubar=0,scrollbars=0, status=1,titlebar=0,toolbar=0,location=1");
    }

</script>
