﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    SiteSettings settings = SiteSettingsManager.GetSiteSettings();
    int applicationID = ApplicationIDs.Instance().User();
    bool enableSina = !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["Sina_AppKey"]) && !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["Sina_AppSecret"]);
    bool enableQQ = !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["QQ_AppKey"]) && !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["QQ_AppSecret"]);%>
<div class="spb-login-box">
    <form action="<%=SPBUrlHelper.Action("LoginInSampleAction","ChannelUser") %>" method="post"
    id="LoginInSampleForm">
    <div class="tn-form tn-label-right">
        <div class="tn-form-row">
            <label class="tn-form-label">
                <%=GetResourceString("Label_UserCount", applicationID) %><%=GetResourceString("Common_Colon") %></label>
            <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="LoginUserName"
                name="LoginUserName" />
        </div>
        <div class="tn-form-row">
            <label class="tn-form-label">
                <%=GetResourceString("Common_Password")%><%=GetResourceString("Common_Colon") %></label>
            <input type="password" class="tn-textbox tn-input-medium tn-border-gray" id="Password"
                name="LoginPassword" />
        </div>
        <div class="tn-form-row">
            <label class="tn-form-label">
            </label>
            <input type="checkbox" id="AutoLogin" name="AutoLogin" value="true" class="tn-checkbox" />
            <label for="AutoLogin">
                <%=GetResourceString("Label_RememberPassword",applicationID)%></label>
            <a href="<%=SiteUrls.Instance().ForgotPassword() %>">
                <%=GetResourceString("Action_ForgetThePassword",applicationID)%></a>
        </div>
        <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label">
            </label>
            <%=SPBHtmlHelper.Instance().SubmitButton("SubmitLoginButton", GetResourceString("Action_Login"))%>
            <% if (settings.RegistrationMode == RegistrationModes.EnableAll)
               {
            %>
            <a href="<%=SiteUrls.Instance().UserRegister() %>">
                <%=GetResourceString("Action_RegisterAccount",applicationID)%></a>
            <%} %>
        </div>
    </div>
    </form>
    <%if (enableSina || enableQQ) %>
    <div class="spb-third-id-login tn-border-gray tn-border-top">
        <strong>使用第三方账号登录</strong>
        <p class="tn-helper-clearfix">
            <%if (enableSina)
              { %>
            <a href="javascript:;" onclick="openSina();return false;" class="tn-img-sprite spb-third-id-btn spb-third-id-sina">
                使用新浪微博账号登录</a>
            <%}
      if (enableQQ)
      { %>
            <a href="javascript:;" onclick="openQQ();return false;" class="tn-img-sprite spb-third-id-btn spb-third-id-qq">
                使用QQ号登录</a>
            <%} %></p>
    </div>

    <script type="text/javascript">
    $(document).ready(function() {
        $("#LoginUserName").watermark("<%=GetResourceString("Validate_PleaseUserNameOrEmail_Required",applicationID)%>").focus();
        $("#LoginInSampleForm").validate({
            rules: {
                LoginUserName: {required:true},
                LoginPassword: {required:true}
            },
            messages: {
                LoginUserName: {required:"<%=GetResourceString("Validate_PleaseUserNameOrEmail_Required",applicationID)%>"},
                LoginPassword: {required:"<%=GetResourceString("Validate_PleasePassword_Required",applicationID)%>"}
            }
        });

        $("#SubmitLoginButton").click(function() {
            if (!$("#LoginInSampleForm").valid()) {
                return false;
            }
        });
    });
            function openQQ() {
            var A = window.open("<%=SiteUrls.Instance().LoginToQQ() %>", "TencentLogin", "width=600,height=500,menubar=0,scrollbars=0, status=1,titlebar=0,toolbar=0,location=1");
        }
            function openSina() {
            var B = window.open("<%=SiteUrls.Instance().LoginToSina() %>", "SinaLogin", "width=600,height=500,menubar=0,scrollbars=0, status=1,titlebar=0,toolbar=0,location=1");
        }

    </script>

</div>
