﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<VoteThread>>" %>
<%
    if (Model != null && Model.Count > 0)
    {
        int applicationID = ApplicationIDs.Instance().Vote();
        int style = ViewData.GetInt("Style", (int)ListBlockStyle.Detailed);
%>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-club-votes-block">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=ViewData.GetString("Title", string.Empty)%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="<%if (style == (int)ListBlockStyle.Detailed) Response.Write("tn-list"); else Response.Write("tn-helper-clearfix tn-list tn-list-triserial"); %>">
      <%foreach (VoteThread thread in Model)
        {
            Club ownerClub = Clubs.GetClub(thread.OwnerID, false);
                  if (thread == null || ownerClub==null || !ownerClub.IsPublic)
                      continue;
                
                  if (ownerClub == null)
                      ownerClub = new Club();
                  if (style == (int)ListBlockStyle.Detailed)
                  {%>
      <li><em class="tn-text-note tn-date tn-helper-right"> <%=GetResourceString("Label_FromIssue", applicationID)%><%=GetResourceString("Common_Colon")%><%=Formatter.FormatFriendlyDate(thread.DateCreated)%></em><cite class="tn-helper-right tn-secondary-text"> <%=SPBHtmlHelper.Instance().UserDisplayNameLink(thread.UserID,thread.Author,applicationID) %> </cite><a href="<%=SiteUrls.Instance().ShowClubVoteThread(ownerClub.DomainName,thread.ThreadID) %>" title="<%=thread.Subject %>"> <%=StringUtils.Trim(thread.Subject, 20)%> </a><em class="tn-count tn-text-note">
        <%Response.Write(thread.VoterCount + GetResourceString("Label_PartIn", applicationID));%>
        </em></li>
      <%}
                  else
                  {%>
      <li><a href="<%=SiteUrls.Instance().ShowClubVoteThread(ownerClub.DomainName,thread.ThreadID) %>"
                title="<%=thread.Subject %>"> <%=StringUtils.Trim(thread.Subject, 11)%></a></li>
      <%}
              }%>
    </ul>
  </div>
</div>
<div class="tn-blank10"> </div>
<%} %>
