﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<VoteComment>>" %>
<% VoteThread thread = ViewData.Get<VoteThread>("VoteThread");%>
<div class="tn-comment-wrap" id="commentForLoad">
    <div class="tn-list-header">
        <div class="tn-text-heading tn-border-bottom tn-border-gray">
            <h4>
                <%=GetResourceString("Common_Comment") %><span class="tn-text-note">
                    <%if (Model != null) Response.Write("（" + Model.TotalRecords + "）"); %></span></h4>
        </div>
    </div>
    <%if (Model != null && Model.Records.Count > 0)
      {%>
    <ul class="tn-comments tn-helper-reset">
        <%foreach (var comment in ViewData.Model.Records)
          {
        %>
        <li class="tn-comment-item tn-border-gray tn-border-bottom"><a name="<%=comment.CommentID %>"
            id="<%=comment.CommentID %>"></a>
            <div class="tn-comment tn-helper-clearfix">
                <div class="tn-comment-avatar">
                    <div class="tn-avatar">
                        <a href="<%=SiteUrls.Instance().UserChannelHome(comment.UserID,UserDomainSpecialAppIDs.Instance().Home()) %>">
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(comment.UserID,false, HyperLinkTarget._blank, AvatarSizeTypes.Small) %></a>
                    </div>
                </div>
                <%if (CurrentUser != null && (CurrentUser.UserID == comment.UserID || CurrentUser.IsContentAdministrator))
                  { %>
                <a class="tn-icon tn-icon-cross tn-helper-right" href="javascript:;" onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteComment")%>')) { $('#commentForLoad').load('<%=SPBUrlHelper.Action("DeleteComment","ChannelVote",new RouteValueDictionary{{"commentID",comment.CommentID}}) %>')}">
                </a>
                <%}%>
                <div class="tn-comment-info">
                    <div class="tn-commentator">
                        <h5>
                            <%=SPBHtmlHelper.Instance().UserDisplayNameLink(comment.UserID,comment.Author) %>
                        </h5>
                        <em class="tn-text-note tn-date">
                            <%=Formatter.FormatDate(comment.DateCreated) %>
                        </em>
                        <% if (CurrentUser != null && comment.UserID != CurrentUser.UserID && CurrentUser != null)
                           { %>
                        <span class="tn-text-note"><a href="javascript:;" onclick="$('#commentBody').focus().attr('value','<%=string.Format("{0}{1}：",GetResourceString("Common_Reply"),comment.Author) %>');$('#parentID').attr('value','<%=comment.CommentID %>');">
                            <%=GetResourceString("Common_Reply")%></a> </span>
                        <%} %>
                    </div>
                    <%if (comment.ParentID > 0)
                      { %>
                    <blockquote class="tn-cue-tips tn-bg-gray tn-border-gray">
                        <p>
                            <%=GetResourceString("Common_Reply")%>
                            <%if (comment.ParentUserID > 0)
                              { %>
                            <a href="<%=SiteUrls.Instance().UserDomainHome(comment.ParentUserID) %>" class="tn-author">
                                <%=comment.ParentAuthor%></a>
                            <%} %><em class="tn-text-note tn-date"><%=Formatter.FormatDate(comment.ParentPostDate, true)%></em></p>
                        <p>
                            <%=comment.ParentBody%></p>
                    </blockquote>
                    <%} %>
                    <p>
                        <%=comment.Body %></p>
                </div>
            </div>
        </li>
        <%} %>
    </ul>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListVoteThreadComments", "ChannelVote", new RouteValueDictionary { { "ThreadID", thread.ThreadID }, { "pageIndex", "{0}" } }), "PageIndexChange")%>
    </div>
    <%} %>
    <% if (thread.EnableComments)
       {
           if (SiteSettingsManager.GetSiteSettings().EnableAnonymousPosting || CurrentUser != null)
           {

               if (TempData["StatusMessageType"] != null)
               {
                   StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                   Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
                   TempData["StatusMessageType"] = null;
               }
    %>
    <form id="commentForm" class="tn-helper-reset" action="<%=SPBUrlHelper.Action("CreateComment", "ChannelVote", new RouteValueDictionary { { "ThreadID", Html.GetParameterFromRouteDateOrQueryString("ThreadID", 0) }, { "pageIndex",Model.PageIndex } })%>"
    method="post">
    <div class="tn-form tn-label-top">
        <div class="tn-comment-form-wrap tn-bg-gray">
            <div class="tn-comment-form">
                <div class="tn-comment-form tn-emotion-box">
                    <a name="comments" id="comments"></a>
                    <%  Html.RenderAction<ChannelController>(n => n.Control_SmileySelector("Smiley", "commentBody"));%>
                    <div class="tn-comment-text-wrap tn-border-gray tn-form-row-near">
                        <textarea name="commentBody" id="commentBody" cols="60" rows="5" class="tn-comment-text-area"><%=TempData.GetString("commentBody", string.Empty)%></textarea>
                        <input type="hidden" id="parentID" name="parentID" value="<%=TempData.GetInt("parentID", 0)%>" />
                    </div>
                    <div class="tn-form-row tn-text-note">
                        <%=string.Format(GetResourceString("Description_Pattern_WordCountLimit"), UserDomainConfiguration.Instance().MaxLengthPerReply)%>
                    </div>
                </div>
            </div>
            <%SiteSettings settings = SiteSettingsManager.GetSiteSettings();
              if (settings.VerifyCodeOption == VerifyCodeOption.Enabled || CurrentUser == null && settings.VerifyCodeOption == VerifyCodeOption.Anonymous)
              {%>
            <div class="tn-form-row tn-form-row-verifycode">
                <label>
                    <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon")%></label>
                <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode",VerificationCodeDifficultyLevel.Low)%>
            </div>
            <%} %>
            <div class="tn-form-row tn-form-row-button">
                <%=SPBHtmlHelper.Instance().SubmitButton("submitComment", GetResourceString("Button_Submit"))%>
            </div>
        </div>
    </div>
    </form>

    <script type="text/javascript">
     $(document).ready(function() {
        $("#commentForm").validate({
           rules: { 
            commentBody:{ required: true, maxBlength: <%=UserDomainConfiguration.Instance().MaxLengthPerReply%> },
            verifyCode:{required:true}
           },
           messages:{
            commentBody:{ required: "<%=GetResourceString("Validate_PleaseInputReview", ApplicationIDs.Instance().Vote()) %>", maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_WordMaxLengthCannot",ApplicationIDs.Instance().Vote()),UserDomainConfiguration.Instance().MaxLengthPerReply)%>" },
            verifyCode:{required: "<%=GetResourceString("Validate_PleaseInputValidate", ApplicationIDs.Instance().Vote())%>"}
           }
        }); 
        
       $("#submitComment").click(function() {
            if (!$("#commentForm").valid()) {
                return false;
            }
          });
          
        $('#commentForm').ajaxForm({
            target: '#commentForLoad',
            beforeSubmit: function() {
                $('#commentForm').block({
                    message: '<%=GetResourceString("Message_Loading")%>'
                });
            },
            success: function() {
                $('#commentForm').unblock();
            }
        });
        
        $('.nyroModal').nyroModal({
            resizeable: true
        });
    }); 
    function pageIndexChange(url) {
        $('#commentForLoad').load(url);
    }
    </script>

    <%}
           else { Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Hint, GetResourceString("Message_PopedomNotComment"), false)); }

       }
       else { Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Hint, GetResourceString("Message_ReviewIsClosed", ApplicationIDs.Instance().Vote()), false)); } %>
</div>
