﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<VoteThread>>" %>
<%if (Model != null)
  {
      int sortBy = ViewData.GetInt("sortBy", (int)VoteThreadSortBy.DateCreated);
      VoteStatuses? status = ViewData["status"] as VoteStatuses?;
      int applicationID = ApplicationIDs.Instance().Vote();
%>
<div class="tn-list-header">
    <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom tn-helper-align-right">
        <%=GetResourceString("Action_View") %>： <span class="tn-action <%if(!status.HasValue) Response.Write("tn-selected"); %>">
            <a href="javascript:;" onclick="$('#VoteList_<%=sortBy %>').parent().load('<%=SPBUrlHelper.Action("Control_ListVoteThreads", "ChannelVote", new RouteValueDictionary { { "sortBy", sortBy } }) %>');return false;"
                class="tn-action-text">
                <%=GetResourceString("Label_Total",applicationID) %></a></span> <span class="tn-action <%if (status.HasValue && status.Value == VoteStatuses.Publishing) Response.Write("tn-selected"); %>">
                    <a href="javascript:;" onclick="$('#VoteList_<%=sortBy %>').parent().load('<%=SPBUrlHelper.Action("Control_ListVoteThreads", "ChannelVote", new RouteValueDictionary { { "sortBy", sortBy }, { "status", (int)VoteStatuses.Publishing } }) %>');return false;"
                        class="tn-action-text">
                        <%=GetResourceString("Label_DoingVote",applicationID) %></a></span>
        <span class="tn-action <%if (status.HasValue && status.Value == VoteStatuses.Expired) Response.Write("tn-selected"); %>">
            <a href="javascript:;" class="tn-action-text" onclick="$('#VoteList_<%=sortBy %>').parent().load('<%=SPBUrlHelper.Action("Control_ListVoteThreads", "ChannelVote", new RouteValueDictionary { { "sortBy", sortBy }, { "status", (int)VoteStatuses.Expired } }) %>');return false;">
                <%=GetResourceString("Label_IsOver", applicationID)%></a></span>
    </div>
</div>
<ul class="tn-list tn-helper-reset" id="VoteList_<%=sortBy %>">
    <%foreach (VoteThread thread in Model.Records)
      {%>
    <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
        <div class="tn-list-item-area-left">
            <div class="tn-avatar">
                <%=SPBHtmlHelper.Instance().ShowUserAvatar(thread.UserID,true,HyperLinkTarget._blank,AvatarSizeTypes.Small)%><span
                    class="tn-round-corner"></span></div>
        </div>
        <div class="tn-list-item-area-right">
            <div class="tn-list-figure tn-widget">
                <div class="tn-list-figure-count tn-widget-content tn-corner-top">
                    <%=thread.VoterCount %></div>
                <a class="tn-list-figure-button tn-state-default tn-corner-bottom" href="<%=SiteUrls.Instance().ShowVoteThread(thread.ThreadID) %>">
                    <%=GetResourceString("Action_Vote", applicationID)%></a>
            </div>
        </div>
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row">
                <h5 class="tn-helper-reset">
                    <a target="_blank" href="<%=SiteUrls.Instance().ShowVoteThread(thread.ThreadID) %>"
                        title="<%=thread.Subject %>">
                        <%=StringUtils.Trim(thread.Subject,22) %></a></h5>
            </div>
            <div class="tn-list-item-row">
                <cite>
                    <%=SPBHtmlHelper.Instance().UserDisplayNameLink(thread.OwnerID,thread.Author) %>
                </cite><em class="tn-date tn-text-note">
                    <%=GetResourceString("Title_Posted",applicationID)%>
                    <%=Formatter.FormatFriendlyDate(thread.DateCreated) %></em> <em class="tn-date tn-text-note">
                        <%=GetResourceString("Label_IsTime",applicationID)%><%=GetResourceString("Common_Colon") %>
                        <%=Formatter.FormatFriendlyDate(thread.EndDate)%></em>
            </div>
            <div class="tn-list-item-row tn-list-item-summary">
                <%if (thread.VoteOptions.Count >= 2)
                  {
                      foreach (KeyValuePair<int, VoteOption> pair in thread.VoteOptions.Take(2))
                      {%>
                <%if (thread.IsMultiple)
                  { %>
                <p class="tn-helper-reset">
                    <input class="tn-checkbox" type="checkbox" disabled="disabled" />
                    <%=StringUtils.Trim(pair.Value.OptionName, 7)%>
                </p>
                <%}
                  else
                  { %>
                <p class="tn-helper-reset">
                    <input class="tn-radiobutton" type="radio" disabled="disabled" />
                    <%=StringUtils.Trim(pair.Value.OptionName, 7)%>
                </p>
                <%}%>
                <%}%>
                <p class="tn-helper-reset">
                    ……
                </p>
                <% } %>
            </div>
            <div class="tn-list-item-row">
                <span class="tn-button tn-button-text-icon tn-button-lite"><span class="tn-first-child">
                    <span class="tn-icon tn-icon-bubble"></span><a class="tn-button-text" href="<%=SiteUrls.Instance().ShowVoteThread(thread.ThreadID) %>#comments">
                        <%=GetResourceString("Common_Comment") %>
                        <%=thread.CommentCount %></a> </span></span><span class="tn-button tn-button-text-icon tn-button-lite">
                            <span class="tn-first-child"><span class="tn-icon tn-icon-view"></span><a class="tn-button-text"
                                href="<%=SiteUrls.Instance().ShowVoteThread(thread.ThreadID) %>">
                                <%=GetResourceString("Common_Browse")%>
                                <%=thread.StageHitTimes %></a> </span></span>
            </div>
        </div>
    </li>
    <%} %>
</ul>
<div class="tn-pagination tn-helper-align-center">
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(Model.TotalRecords,Model.PageSize, Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListVoteThreads", "ChannelVote", new RouteValueDictionary { { "sortBy", sortBy }, { "status", status }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
</div>

<script type="text/javascript">
    function pageIndexChange(url) {
        $('#VoteList_<%=sortBy %>').parent().load(url);
    }
</script>

<%} %>