﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<VoteThread>>" %>
<%
    if (Model != null && Model.Count > 0)
    {
        int applicationID = ApplicationIDs.Instance().Vote();
        int sortBy = ViewData.GetInt("sortBy");
        int status = ViewData.GetInt("status");
        int style = ViewData.GetInt("Style", (int)ListBlockStyle.Detailed);
%>

<div class="tn-box tn-widget tn-widget-content tn-corner-all">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=ViewData.GetString("Title", string.Empty)%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="<%if (style == (int)ListBlockStyle.Detailed) Response.Write("tn-list"); else Response.Write("tn-helper-clearfix tn-list tn-list-triserial"); %>">
      <%foreach (VoteThread thread in Model)
              {
                  if (thread == null)
                      continue;
                  if (style == (int)ListBlockStyle.Detailed)
                  {%>
      <li><em class="tn-text-note tn-date tn-helper-right"> <%=GetResourceString("Label_FromIssue", applicationID)%><%=GetResourceString("Common_Colon")%><%=Formatter.FormatFriendlyDate(thread.DateCreated)%></em><cite class="tn-helper-right tn-secondary-text"> <%=SPBHtmlHelper.Instance().UserDisplayNameLink(thread.OwnerID,thread.Author) %> </cite><a href="<%=SiteUrls.Instance().ShowVoteThread(thread.ThreadID) %>" title="<%=thread.Subject %>"> <%=StringUtils.Trim(thread.Subject, 20)%> </a><em class="tn-count tn-text-note">
        <%switch (sortBy)
                      {
                          case (int)VoteThreadSortBy.CommentCount:
                              Response.Write(thread.CommentCount + GetResourceString("Common_Comment"));
                              break;
                          case (int)VoteThreadSortBy.VoterCount:
                              Response.Write(thread.VoterCount + GetResourceString("Label_PartIn", applicationID));
                              break;
                          case (int)VoteThreadSortBy.StageHitTimes:
                              Response.Write(thread.VoterCount + GetResourceString("Common_Browse"));
                              break;
                          default:
                              Response.Write(thread.VoterCount + GetResourceString("Label_PartIn", applicationID));
                              break;
                      }%>
        </em></li>
      <%}
                  else
                  {%>
      <li><a href="<%=SiteUrls.Instance().ShowVoteThread(thread.ThreadID) %>" title="<%=thread.Subject %>"> <%=StringUtils.Trim(thread.Subject, 11)%></a></li>
      <%}
              }%>
    </ul>
    <p class="tn-more"><a href="<%=SPBUrlHelper.Action("VoteThreadRanks","ChannelVote",new RouteValueDictionary{{"sortBy",ViewData.GetInt("sortBy",(int)VoteThreadSortBy.DateCreated)}}) %>"> <%=GetResourceString("Action_More")%></a></p>
  </div>
</div>
<div class="tn-blank10"> </div>
<%} %>
