﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<VoteThread>" %>
<%if (Model != null)
  { %>
<%
    
    bool isVote = ViewData.GetBool("isVote", true);
    bool canVote = CurrentUser != null && !isVote;
%>
<div class="spb-vote-block">
    <form id="VoteForm" name="VoteForm" action="<%=SPBUrlHelper.Action("Vote","ChannelVote",new RouteValueDictionary{{"threadID",Model.ThreadID}}) %>"
    method="post">
    <div class="tn-text-heading">
        <strong>
            <%=StringUtils.Trim(Model.Subject,15) %></strong></div>
    <div class="tn-info-part tn-helper-align-right">
        <a class="tn-user-name tn-helper-left" href="<%=SiteUrls.Instance().UserDomainHome(Model.UserID) %>">
            <%=Model.Author %></a>
        <em class="tn-text-note">
            <%=GetResourceString("Label_PartIn",ApplicationIDs.Instance().Vote())%><%=Model.VoterCount %></em>
    </div>
    <div class="spb-vote-form">
        <div class="tn-histogram">
            <% foreach (VoteOption option in Model.VoteOptions.Values)
               { %>
            <div class="tn-histogram-item tn-helper-clearfix">
                <span class="tn-histogram-input">
                    <% if (Model.IsMultiple)
                       { %>
                    <input type="checkbox" class="tn-checkbox" id="optionID_<%=option.OptionID%>" name="optionID"
                        <% if(!canVote) Response.Write("disabled=\"disabled\""); %> value="<%=option.OptionID %>" />
                    <%}
                       else
                       { %>
                    <input type="radio" class="tn-checkbox" id="optionID_<%=option.OptionID%>" name="optionID"
                        <% if(!canVote) Response.Write("disabled=\"disabled\""); %> value="<%=option.OptionID %>" />
                    <%} %>
                </span>
                <label class="tn-histogram-label" for="optionID_<%=option.OptionID%>">
                    <%=option.OptionName %></label>
            </div>
            <%} %>
        </div>
        <div class="tn-form tn-border-gray tn-border-top">
            <div class="tn-form-row">
                <input name="IsAnonymousVote" type="checkbox" value="true" class="tn-checkbox" id="IsAnonymousVote" />
                <label for="IsAnonymousVote">
                    <%= GetResourceString("Label_AnonymousVote",ApplicationIDs.Instance().Vote())%></label>
            </div>
            <div class="tn-form-row tn-form-row-button">
                <%if (CurrentUser == null)
                  { %>
                <%=SPBHtmlHelper.Instance().Button(string.Empty, GetResourceString("Action_IWillVote", ApplicationIDs.Instance().Vote()), ButtonSizes.Default, HighlightStyles.Primary, new RouteValueDictionary { { "onclick", "window.location.href='"+ SiteUrls.Instance().ShowVoteThread(Model.ThreadID,true) +"'"}}, null)%>
                <%}
                  else if (!isVote)
                  { %>
                <%=SPBHtmlHelper.Instance().SubmitButton("postVoteButton", GetResourceString("Action_Vote", ApplicationIDs.Instance().Vote()),ButtonSizes.Default, null,null)%>
                <%} %>
                <%=SPBHtmlHelper.Instance().Button(string.Empty, GetResourceString("Action_LookResult",ApplicationIDs.Instance().Vote()), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "onclick", "window.location.href='"+ SiteUrls.Instance().ShowVoteThread(Model.ThreadID,true) +"'"}}, null)%>
            </div>
        </div>
    </div>
    </form>
</div>

<script language="javascript">
            $(document).ready(function() {
                $("#VoteForm").validate({
                      rules: {
                          optionID: { required: true, maxlength: <%=Model.MaxChooseCount %> }
                      },
                      messages: {
                          optionID: { required: "<%=GetResourceString("Validate_PleaseSelectVoteOptions",ApplicationIDs.Instance().Vote())%>", maxlength: "<%=string.Format(GetResourceString("Message_TheMostSelect",ApplicationIDs.Instance().Vote()), Model.MaxChooseCount)%>" }
                      }
                  });

                $("#postVoteButton").click(function() {
                    if ($("#VoteForm").valid()) {
                        $("#postVoteButton").hide();
                        $("#postVoteButton_ForHide").show();
                    }
                    else {
                        return false;
                    }
                });
            });
</script>

<%} %>