﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<Announcement>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="ShowAnnouncement"
</asp:content>
<asp:content contentplaceholderid="wideContentRegion" runat="server" id="wideContentRegion">
  <% 
      if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
          TempData["StatusMessageType"] = null;
      }

      
    %>
<div class="spb-header-bottom">
<div class="tn-wrapper-inner tn-helper-clearfix">
    <div class="tn-pagename">
      <spb:BreadCrumb ID="BreadCrumb" runat="server" />
     </div>  
</div>
</div>
<div class="tn-blank10"></div>
<div id="showAnnouncement" class="tn-box tn-widget tn-widget-content tn-corner-all tn-detail spb-blog-post">
<div class="tn-box-content tn-widget-content tn-corner-all">
<div class="tn-text-heading">
<h1 class="tn-title"><%=Model.Subject %><%if (Model.IsSticky) Response.Write("<span title='置顶' class='tn-icon-inline tn-icon-top tn-icon'></span>");%></h1>
</div>

<% if (CurrentUser != null && CurrentUser.IsContentAdministrator)
   { %>
<div class="tn-actions tn-helper-align-right">
<span class="tn-action">
<%if (Model.IsSticky)
                              {%>
                           <a href="<%=Url.Action("SetSticky","Channel", new RouteValueDictionary { { "threadID",Model.ThreadID },{"isSticky",false } })%>" > 取消置顶</a>
                            <%} %>
                            <%else
                                {%>
                               <a href="<%=Url.Action("SetSticky","Channel", new RouteValueDictionary { { "threadID",Model.ThreadID },{"isSticky",true } })%>" > 置顶</a> 
                            <%} %>

</span>
<span class="tn-action"><a href="<%=Url.Action("EditAnnouncement","Auxiliaries", new RouteValueDictionary { { "threadID",Model.ThreadID } })%>" target="_blank">编辑</a></span>
<span class="tn-action"><a onclick="if ( !confirm('确定删除该公告吗？') ) {return false; }"
                            href="<%=Url.Action("DeleteAnnouncement","Channel", new RouteValueDictionary { { "threadID",Model.ThreadID } })%>">
                            删除</a> </span>
</div>
<%} %>

<div class="tn-info-part tn-text-note tn-border-gray tn-border-top tn-detail-info">
<dl><dt>撰稿：</dt> <dd><%=SPBHtmlHelper.Instance().UserDisplayName(Model.UserID) %></dd></dl>
<dl><dt>发布时间：</dt> <dd><%=Formatter.FormatDate(Model.DateCreated) %></dd></dl>
<dl><dt>浏览数：</dt> <dd><%=Model.HitTimes %></dd></dl>
</div>
<div class="tn-detail-text">
<%=Model.Body %>

</div>
<div class="tn-info-part tn-border-gray tn-border-top tn-context">

<% if (Model.PrevThreadID>0)
   { %>
   <dl><dt>上一篇：</dt><dd><a href="<%=Url.Action("ShowAnnouncement", new RouteValueDictionary { {"threadID",Model.PrevThreadID}})%>"><%=Model.PrevThreadSubject %>  </a></dd></dl>
<%} %>
<% if (Model.NextThreadID>0)
   { %>
 <dl><dt> 下一篇：</dt><dd><a href="<%=Url.Action("ShowAnnouncement", new RouteValueDictionary { {"threadID",Model.NextThreadID}})%>"><%=Model.NextThreadSubject %></a></dd></dl>
 <%} %>
</div>

</div>
  </div>   
   <script type="text/javascript">
       function topManage() { 
      
       
       }
   </script>    
</asp:content>
