﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<PagingDataSet<BlogSection>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Blog-BlogRanks"
</asp:content>
<asp:content contentplaceholderid="subMenusContent" runat="server">
    <% Html.RenderAction<ChannelBlogController>(n => n.Control_SubMenus()); %>
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server" id="mainContent">
   <div id="blogRanks" class="ui-tabs ui-widget ui-widget-content ui-corner-all">
    <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
      <%BlogSectionSortBy sortBy = ViewData.Get<BlogSectionSortBy>("sortBy", BlogSectionSortBy.CreateDate);
        int BlogApplicationID = ApplicationIDs.Instance().Blog();%>
      <li id="RankByPostDateLi" <%if(BlogSectionSortBy.CreateDate==sortBy){Response.Write("class='ui-state-default ui-corner-top ui-tabs-selected ui-state-active'");} %>> <a href="<%=SPBUrlHelper.Action("ListBlogRanks","ChannelBlog",new RouteValueDictionary{{"sortBy",BlogSectionSortBy.CreateDate}}) %>"> <span> <%=GetResourceString("Title_NewPost") %></span></a></li>
      <li id="RankByPointsLi"   <%if(BlogSectionSortBy.Points==sortBy){Response.Write("class='ui-state-default ui-corner-top ui-tabs-selected ui-state-active'");} %>> <a href="<%=SPBUrlHelper.Action("ListBlogRanks", "ChannelBlog", new RouteValueDictionary { { "sortBy", BlogSectionSortBy.Points } })%>"> <span> <%=GetResourceString("Title_PointsTiptop")%></span></a></li>
      <li id="RankByPostCountLi" <%if(BlogSectionSortBy.ThreadCount==sortBy){Response.Write("class='ui-state-default ui-corner-top ui-tabs-selected ui-state-active'");} %>> <a href="<%=SPBUrlHelper.Action("ListBlogRanks", "ChannelBlog", new RouteValueDictionary { { "sortBy", BlogSectionSortBy.ThreadCount } })%>"> <span> <%=GetResourceString("Title_ArticleMost", BlogApplicationID)%></span></a></li>
      <li id="RankByCommentCountLi" <%if(BlogSectionSortBy.CommentCount==sortBy){Response.Write("class='ui-state-default ui-corner-top ui-tabs-selected ui-state-active'");} %>> <a href="<%=SPBUrlHelper.Action("ListBlogRanks", "ChannelBlog", new RouteValueDictionary { { "sortBy", BlogSectionSortBy.CommentCount } })%>"> <span> <%=GetResourceString("Title_CommentMost") %></span></a></li>
      <li id="RankByHitTimesLi" <%if(BlogSectionSortBy.HitTimes==sortBy){Response.Write("class='ui-state-default ui-corner-top ui-tabs-selected ui-state-active'");} %>> <a href="<%=SPBUrlHelper.Action("ListBlogRanks", "ChannelBlog", new RouteValueDictionary { { "sortBy", BlogSectionSortBy.HitTimes } })%>"> <span><%=GetResourceString("Title_BrowseMost")%></span></a></li>
      <li id="RankByWeekHitTimesLi" <%if(BlogSectionSortBy.StageHitTimes==sortBy){Response.Write("class='ui-state-default ui-corner-top ui-tabs-selected ui-state-active'");} %>> <a href="<%=SPBUrlHelper.Action("ListBlogRanks", "ChannelBlog", new RouteValueDictionary { { "sortBy", BlogSectionSortBy.StageHitTimes } })%>"> <span> <%=GetResourceString("Title_WeekBrowseMost", BlogApplicationID)%></span></a></li>
    </ul>
     <div class="ui-tabs-panel ui-widget-content ui-corner-bottom">
       <table class="tn-table-grid">
       <tbody>
          <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_BlogName",BlogApplicationID)%></th>
            <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_Author")%></th>
            <%if (sortBy == BlogSectionSortBy.CreateDate)
              { %>
            <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_UpdateDate")%></th>
            <%} if (sortBy == BlogSectionSortBy.Points)
              { %>
            <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_Point", BlogApplicationID)%></th>
            <%} %>
            <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_ArticleNumber",BlogApplicationID)%></th>
            <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Common_Comment") %></th>
            <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_BrowseCount")%></th>
             <%if (sortBy == BlogSectionSortBy.StageHitTimes)
               { %>
            <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_WeekBrowse", BlogApplicationID)%></th>
            <%} %>
          </tr>
          <%foreach (var blogSection in ViewData.Model.Records)
            {
                if (blogSection.Owner == null)
                    continue;
                %>
         <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-width-auto"><a title="<%=string.Format(GetResourceString("Description_Pattern_CheckSeeUserBlog", BlogApplicationID), blogSection.SectionName) %>" href="<%=SPBUrlHelper.Action("Home", "Blog", new RouteValueDictionary { { "userDomainName",blogSection.Owner.UserName } })%>" target="_blank"> <%=StringUtils.Trim(blogSection.SectionName, 15)%></a></td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap"><a title="<%=blogSection.Owner.DisplayName %>" target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(blogSection.OwnerUserID, UserDomainSpecialAppIDs.Instance().Home()) %>"> <%=StringUtils.Trim(blogSection.Owner.DisplayName, 8)%></a></td>
           <%if (sortBy == BlogSectionSortBy.CreateDate)
             { %>
            <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap"><%=Formatter.FormatDate(blogSection.MostRecentPostDate)%></td>
           <%} if (sortBy == BlogSectionSortBy.Points)
             { %>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"><%=blogSection.Points%></td>
            <%} %>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"><%=blogSection.ThreadCount%></td>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"><%=blogSection.CommentCount%></td>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"><%=blogSection.HitTimes%></td>
             <%if (sortBy == BlogSectionSortBy.StageHitTimes)
               { %>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"><%=blogSection.StageHitTimes%></td>
            <%} %>
          </tr>
          <% } %>
          </tbody>
        </table>        
      
        <div class="tn-pagination tn-helper-align-center"> 
        <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex)%> 
          </div>
        </div>  </div>
</asp:content>
<asp:content runat="server" id="sidebarContent" contentplaceholderid="sidebarContent">
<div id="recommend">
  <% Html.RenderAction<ChannelController>(n => n.Control_RecommendUser(11003, 5));%>
  </div>
  <div id="ListBlogSiteTags">
  <% Html.RenderAction<ChannelBlogController>(n => n.Control_ListBlogSiteTags(50, SiteTagsSortBy.UserCount)); %>
  </div>
</asp:content>
