﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<Dictionary<string, KeyValuePair<int, SiteTag>>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Blog-BlogTagMap"
</asp:content>
<asp:content contentplaceholderid="subMenusContent" runat="server">
    <% Html.RenderAction<ChannelBlogController>(n => n.Control_SubMenus());%>
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server" id="mainContent">
    <div id="blogTagMap" class="tn-box tn-widget tn-widget-content tn-corner-all">
          <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <p class="tn-tags-cloud">
                <% 
                    if (Model != null && Model.Count > 0)
                    {
                        foreach (var pair in Model)
                        { 
                            %>
                           <span class="tn-font-size-<%=pair.Value.Key %>">
                <%=SPBHtmlHelper.Instance().ShowSiteTagHyperLink(pair.Value.Value, Globals.GetFullUrlInMainSite(SiteUrls.Instance().ListBlogThreadsBySiteTag(pair.Key)), GetResourceString("Description_Pattern_AllFefineAndArticle", ApplicationIDs.Instance().Blog()))%>
                <%--<em class="tn-text-note">(<%=siteTag.ItemCount %>)</em>--%>
                </span>
                <% }
                    } %>
            </p>
          </div>
        </div>
</asp:content>
<asp:content runat="server" id="sidebarContent" contentplaceholderid="sidebarContent">

    <script type="text/javascript">
        $(document).ready(function() {
            $(".ui-tabs").tabs({ cookie: { expires: 30} });
        });
    </script>

         <% int BlogApplicationID = ApplicationIDs.Instance().Blog(); %>
    <div id="threadTab" class="ui-tabs ui-widget ui-widget-content ui-corner-all">
        <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
            <li class="ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="#blogThreadListTab"><span><%=GetResourceString("Title_HotArticle", BlogApplicationID)%></span></a></li>
            <li class="ui-state-default ui-corner-top"><a href="<%=SPBUrlHelper.Action("Control_ListBlogThreadsInTab","ChannelBlog",new RouteValueDictionary{{"sortBy",BlogThreadSortBy.TotalReplies},{"siteCategoryID",-1},{"tagName",string.Empty},{"pageSize",10}}) %>">
                <span><%=GetResourceString("Title_HotCommentArticle", BlogApplicationID)%></span></a></li>
            <li class="ui-state-default ui-corner-top"><a href="<%=SPBUrlHelper.Action("Control_ListBlogThreadsBlock","ChannelBlog",new RouteValueDictionary{{"sortBy",BlogThreadSortBy.MostRecent},{"siteCategoryID",-1},{"tagName",string.Empty},{"pageSize",10}}) %>">
                <span><%=GetResourceString("Title_NewArticle", BlogApplicationID)%></span></a></li>
        </ul>
        <div id="blogThreadListTab" class="ui-tabs-panel ui-widget-content ui-corner-bottom">
            <% Html.RenderAction<ChannelBlogController>(n => n.Control_ListBlogThreadsInTab(BlogThreadSortBy.TotalViews, -1, 10)); %>
        </div>
    </div>
     <div class="tn-blank10"></div>
<div id="listTab" class="ui-tabs ui-widget ui-widget-content ui-corner-all">
        <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
            <li class="ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="#blogsListTab"><span><%=GetResourceString("Title_WeekBlogTaxis", BlogApplicationID)%></span></a></li>
            <li class="ui-state-default ui-corner-top"><a href="<%=SPBUrlHelper.Action("Control_ListBlogsInTab","ChannelBlog",new RouteValueDictionary{{"sortBy",BlogSectionSortBy.HitTimes},{"pageSize",10}}) %>">
                <span><%=GetResourceString("Title_AllTaxis", BlogApplicationID)%></span></a></li>
        </ul>
        <div id="blogsListTab" class="ui-tabs-panel ui-widget-content ui-corner-bottom">
            <% Html.RenderAction<ChannelBlogController>(n => n.Control_ListBlogsInTab(BlogSectionSortBy.StageHitTimes, 10)); %>
        </div>
    </div>
    
    <%--推荐博客--%>
     <div class="tn-blank10"></div>
<div id="recommend">
    <% Html.RenderAction<ChannelController>(n => n.Control_RecommendUser(11003, 5)); %></div>
</asp:content>
