﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="Blog-BlogThreadRanks" </asp:content>
<asp:content contentplaceholderid="subMenusContent" runat="server">
  <% Html.RenderAction<ChannelBlogController>(n => n.Control_SubMenus());%>
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server" id="mainContent">
  <% BlogThreadSortBy sortBy = ViewData.Get<BlogThreadSortBy>("sortBy", BlogThreadSortBy.MostRecent);
       int categoryID = Html.GetParameterFromRouteDateOrQueryString("categoryID", 0);
       string tagName = Html.GetParameterFromRouteDateOrQueryString("tagName");
       int BlogApplicationID = ApplicationIDs.Instance().Blog(); %>
  <div id="threadRanks" class="ui-tabs ui-widget ui-widget-content ui-corner-all spb-article-rank">
    <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
      <li <% if (sortBy == BlogThreadSortBy.MostRecent) Response.Write("class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\""); %>> <a href="<%=SPBUrlHelper.Action("BlogThreadRanks","ChannelBlog",new RouteValueDictionary{{"rankBy",BlogThreadSortBy.MostRecent},{"categoryID",categoryID},{"tagName",tagName}}) %>"> <span><%=GetResourceString("Title_NewArticle", BlogApplicationID)%></span></a></li>
      <li <% if (sortBy == BlogThreadSortBy.TotalViews) Response.Write("class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\""); %>> <a href="<%=SPBUrlHelper.Action("BlogThreadRanks", "ChannelBlog", new RouteValueDictionary { { "rankBy", BlogThreadSortBy.TotalViews }, { "categoryID", categoryID }, { "tagName", tagName } })%>"> <span><%=GetResourceString("Title_BrowseMost")%></span></a></li>
      <li <% if (sortBy == BlogThreadSortBy.TotalReplies) Response.Write("class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\""); %>> <a href="<%=SPBUrlHelper.Action("BlogThreadRanks", "ChannelBlog", new RouteValueDictionary { { "rankBy", BlogThreadSortBy.TotalReplies }, { "categoryID", categoryID }, { "tagName", tagName } })%>"> <span><%=GetResourceString("Title_ReversionMost", BlogApplicationID)%></span></a></li>
    </ul>
    <div class="ui-tabs-panel ui-widget-content ui-corner-bottom">
      <% Html.RenderAction("Control_SummaryBlogThreads", "ChannelBlog", new RouteValueDictionary { { "sortBy", sortBy }, { "pageIndex", Request.QueryString.GetInt("pageIndex", 1) }, { "categoryID", categoryID }, { "tagName", tagName } }); %>
    </div>
  </div>
</asp:content>
<asp:content runat="server" id="sidebarContent" contentplaceholderid="sidebarContent">
  <% Html.RenderAction<ChannelBlogController>(n => n.Control_ListBlogSiteTags(50, SiteTagsSortBy.UserCount));
       int BlogApplicationID = ApplicationIDs.Instance().Blog(); %>
  <div class="tn-blank10"></div>
  <div class="ui-tabs ui-widget ui-widget-content ui-corner-all" id="blogsTabUl">
    <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
      <li class="ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="#blogsListTab"><span><%=GetResourceString("Title_WeekBlogTaxis", BlogApplicationID)%></span></a></li>
      <li class="ui-state-default ui-corner-top"><a href="<%=SPBUrlHelper.Action("Control_ListBlogsInTab","ChannelBlog",new RouteValueDictionary{{"sortBy",BlogSectionSortBy.HitTimes},{"pageSize",10}}) %>"> <span><%=GetResourceString("Title_AllTaxis", BlogApplicationID)%></span></a></li>
    </ul>
    <div id="blogsListTab">
      <% Html.RenderAction<ChannelBlogController>(n => n.Control_ListBlogsInTab(BlogSectionSortBy.StageHitTimes, 10)); %>
    </div>
  </div>
  <script type="text/javascript">

        $(document).ready(function() {
            $("#blogsTabUl").tabs({ cookie: { expires: 30} });
        });
       
    </script>
</asp:content>
