﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<List<SiteCategory>>" %>

<asp:content contentplaceholderid="head" id="headerContent" runat="server">
    <spb:Header ID="Header1" runat="server">
        <spb:Script runat="server" ID="jquery" Src="~/Utility/jquery/jquery.min-1.4.2.js"
            SetExpireDays="30" />
        <spb:Script runat="server" ID="cookie" Src="~/Utility/jquery/plugin/jquery.cookie.js"
            SetExpireDays="30" />
        <spb:Script runat="server" ID="core" Src="~/Utility/jquery/ui.core.min-1.8.12.js"
            SetExpireDays="30" />
        <spb:Script runat="server" ID="widget" Src="~/Utility/jquery/ui.widget.min-1.8.12.js"
            SetExpireDays="30" />
        <spb:Script runat="server" ID="global" Src="~/Utility/tunynet_web_ui/global.js" />
        <spb:Script runat="server" ID="nyroModal" Src="~/Utility/jquery/plugin/jquery.nyroModal-1.6.2.min.js"
            SetExpireDays="30" />
        <spb:Script runat="server" ID="tabs" Src="~/Utility/jquery/ui.tabs.min-1.8.12.js"
            SetExpireDays="30" />
        <spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
            SetExpireDays="30" />
<spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
    SetExpireDays="30" />
        <spb:Script runat="server" ID="watermarkinput" Src="~/Utility/jquery/plugin/jquery.watermarkinput.js" />
        <spb:Script runat="server" ID="validate" Src="~/Utility/jquery/plugin/jquery.validate-1.7.js"
            SetExpireDays="30" />
            
    </spb:Header>
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="Blog-Home"
</asp:content>
<asp:content contentplaceholderid="subMenusContent" runat="server">
    <% Html.RenderAction<ChannelBlogController>(n => n.Control_SubMenus()); %>
</asp:content>
<asp:content contentplaceholderid="mainContentRegion" runat="server" id="mainContentRegion"> 
<%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001000000001", new RouteValueDictionary { { "class", "spb-ad-banner" } })%>
<div class="tn-main">
                        <div class="tn-block">
                           <div id="stickyBlogThreads">
    <% Html.RenderAction("Control_ListStickyBlogThreads", "ChannelBlog", new RouteValueDictionary { { "categoryID", 0 } }); %>
    </div>
<div id="recommendBlock">
  <% //推荐博文
      Html.RenderAction("Control_RecommendBlogThreadBlock", "ChannelBlog", new RouteValueDictionary { { "commendTypeID", 111001 }, { "displayCount", 9 }, { "hasBorder", true } });
    %>
    </div>
   <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001001110001", new RouteValueDictionary { { "class", "spb-ad-main" } })%>
    <div id="blogThreads">
    <% List<SiteCategory> siteCategories = ViewData.Model;
       if (siteCategories != null && siteCategories.Count > 0)
       {
           foreach (SiteCategory siteCategory in siteCategories)
           {
               Html.RenderAction<ChannelBlogController>(n => n.Control_ListBlogBlock(BlogThreadSortBy.StickyAndMostRecent, "ListBlogThreadsForMain", string.Empty, siteCategory.CategoryID, 10));
           }
       }
       else
       { %>
           <div  class="tn-box tn-widget tn-widget-content tn-corner-all">
          <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
              <h3 class="tn-helper-reset">  <%=GetResourceString("Title_ArticleList", ApplicationIDs.Instance().Blog())%></h3>
            </div>
            <div class="tn-box-content tn-widget-content tn-corner-bottom">
               <% Html.RenderAction("Control_SummaryBlogThreads", "ChannelBlog", new RouteValueDictionary { { "sortBy", BlogThreadSortBy.MostRecent }, { "pageIndex", 0 }, { "categoryID", 0 } }); %>
            </div>
          </div>
    <%} %>
    </div>
                        </div>
                    </div>
 
</asp:content>
<asp:content contentplaceholderid="sidebarContentRegion" runat="server" id="sidebarContentRegion">
<div class="tn-block">
                           <script type="text/javascript">
                               $(document).ready(function() {
                                   $(".ui-tabs").tabs({ cookie: { expires: 30} });
                               });
    </script>

<% int BlogApplicationID = ApplicationIDs.Instance().Blog(); %>
    <div id="threadTab" class="ui-tabs ui-widget ui-widget-content ui-corner-all">
        <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
            <li class="ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="#blogThreadListTab"><span><%=GetResourceString("Title_HotArticle", BlogApplicationID)%></span></a></li>
            <li class="ui-state-default ui-corner-top"><a href="<%=SPBUrlHelper.Action("Control_ListBlogThreadsInTab","ChannelBlog",new RouteValueDictionary{{"sortBy",BlogThreadSortBy.TotalReplies},{"siteCategoryID",-1},{"tagName",string.Empty},{"pageSize",10}}) %>">
                <span><%=GetResourceString("Title_HotCommentArticle", BlogApplicationID)%></span></a></li>
            <li class="ui-state-default ui-corner-top"><a href="<%=SPBUrlHelper.Action("Control_ListBlogThreadsBlock","ChannelBlog",new RouteValueDictionary{{"sortBy",BlogThreadSortBy.MostRecent},{"siteCategoryID",-1},{"tagName",string.Empty},{"pageSize",10}}) %>">
                <span><%=GetResourceString("Title_NewArticle", BlogApplicationID)%></span></a></li>
        </ul>
        <div id="blogThreadListTab" class="ui-tabs-panel ui-widget-content ui-corner-bottom">
            <% Html.RenderAction<ChannelBlogController>(n => n.Control_ListBlogThreadsInTab(BlogThreadSortBy.TotalViews, 0, 10)); %>
        </div>
    </div>
     <div class="tn-blank10"></div>
    <%--文章标签--%>
    <div id="siteTags">
    <% Html.RenderAction<ChannelBlogController>(n => n.Control_ListBlogSiteTags(20, SiteTagsSortBy.ItemCount)); %>
    </div>
    <div class="tn-blank10"></div>

    <%--最新文章--%>
    <%--<div id="newBlogThreads">
    <% Html.RenderAction<ChannelBlogController>(n => n.Control_ListBlogThreadsBlock(BlogThreadSortBy.MostRecent, -1,string.Empty, 5)); %>
    </div>--%>
    <%--推荐博客--%>
    <div id="recommend">
    <% Html.RenderAction<ChannelController>(n => n.Control_RecommendUser(11003, 5)); %>
    </div>
    <div id="listTab" class="ui-tabs ui-widget ui-widget-content ui-corner-all">
        <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
            <li class="ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="#blogsListTab"><span><%=GetResourceString("Title_WeekBlogTaxis", BlogApplicationID)%></span></a></li>
            <li class="ui-state-default ui-corner-top"><a href="<%=SPBUrlHelper.Action("Control_ListBlogsInTab","ChannelBlog",new RouteValueDictionary{{"sortBy",BlogSectionSortBy.HitTimes},{"pageSize",10}}) %>">
                <span><%=GetResourceString("Title_AllTaxis", BlogApplicationID)%></span></a></li>
        </ul>
        <div id="blogsListTab" class="ui-tabs-panel ui-widget-content ui-corner-bottom">
            <% Html.RenderAction<ChannelBlogController>(n => n.Control_ListBlogsInTab(BlogSectionSortBy.StageHitTimes, 10)); %>
        </div>
        
    </div>
     <div class="tn-blank10"></div>
     <div id="listBlogBlock">
    <% Html.RenderAction<ChannelBlogController>(n => n.Control_ListBlogsBlock(9, BlogSectionSortBy.CreateDate)); %>
    </div>
        <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001001110002", new RouteValueDictionary { { "class", "spb-ad-side-bottom" } })%>
    </div>
<%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001000000002", new RouteValueDictionary { { "class", "spb-ad-banner-bottom" } })%>
</asp:content>
