﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="Blog-ListBlogThreadsByCategory" </asp:content>
<asp:content contentplaceholderid="subMenusContent" runat="server">
  <% Html.RenderAction<ChannelBlogController>(n => n.Control_SubMenus()); %>
</asp:content>
<asp:content runat="server" id="mainContent" contentplaceholderid="mainContent">
  <% SiteCategory currenSiteCategory = ViewData.Get<SiteCategory>("currentSiteCategory"); %>
  <div id="listBlogThreadByCategoty" class="tn-box tn-widget tn-widget-content tn-corner-all spb-article-categories">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <% BlogThread topBlogThreadInCategory = ViewData.Get<BlogThread>("topBlogThreadInCategory");
               if (topBlogThreadInCategory != null)
               {%>
      <ul class="tn-list">
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
          <div class="tn-list-item-area-left">
            <% if (topBlogThreadInCategory.ManagerFeaturedImageAttachmentID > 0)
                       {%>
            <img src="<%=SiteUrls.Instance().BlogPhotoUrl(topBlogThreadInCategory.ManagerFeaturedImageAttachmentID, BlogPhotoTypes.BigNews) %>"
                            alt="<%=topBlogThreadInCategory.Subject %>" />
            <%} %>
          </div>
          <div class="tn-list-item-area-main">
          <div class="tn-list-item-row tn-list-item-heading">
            <h5> <a href="<%=SiteUrls.Instance().ShowBlogThread(UserID2UserNameDictionary.GetUserName(topBlogThreadInCategory.OwnerUserID),topBlogThreadInCategory) %>"
                            target="_blank" title="<%=topBlogThreadInCategory.Subject%>"> <%=topBlogThreadInCategory.Subject%></a>
              <% if (topBlogThreadInCategory.IsEssential)
                           {%>
              <%=SPBHtmlHelper.Instance().Icon(IconTypes.Elite, GetResourceString("Common_Essential"), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
              <%}
                           if (topBlogThreadInCategory.SpecialOrder > 0)
                           {%>
              <%=SPBHtmlHelper.Instance().Icon(IconTypes.Top, GetResourceString("Common_SetTop"), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
              <%}%>
            </h5>
          </div>
          <div class="tn-list-item-row tn-list-item-summary">
            <p class="tn-helper-reset"> <%=HtmlUtils.TrimHtml(topBlogThreadInCategory.GetBody(false), 90)%> </p>
            <div class="tn-list-item-row"> <cite> <%=SPBHtmlHelper.Instance().UserDisplayNameLink(topBlogThreadInCategory.OwnerUserID,topBlogThreadInCategory.Author,ApplicationIDs.Instance().Blog()) %> </cite> <cite class="tn-text-note"><em> <%=Formatter.FormatFriendlyDate(topBlogThreadInCategory.PostDate)%></em></cite> <cite class="tn-text-note"> <%=SPBHtmlHelper.Instance().ShowRating(topBlogThreadInCategory.RatingSum,topBlogThreadInCategory.TotalRatings) %></cite>
              <% string title = string.Empty;
                               if (topBlogThreadInCategory.BlogSection.EnableComments)
                               {
                                   title = GetResourceString("Common_Comment") + " (" + topBlogThreadInCategory.CommentCount + ")";
                               }
                               else
                               {
                                   title = GetResourceString("Label_CloseComment", ApplicationIDs.Instance().Blog());
                               } %>
              <%=SPBHtmlHelper.Instance().LinkButton("comment", title, SiteUrls.Instance().ShowBlogThread(UserID2UserNameDictionary.GetUserName(topBlogThreadInCategory.OwnerUserID), topBlogThreadInCategory) + "#Comment", ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Bubble, TextIconLayout.IconText)%> <%=SPBHtmlHelper.Instance().LinkButton("browser", GetResourceString("Common_Browse") + " (" + topBlogThreadInCategory.HitTimes + ")", SiteUrls.Instance().ShowBlogThread(UserID2UserNameDictionary.GetUserName(topBlogThreadInCategory.OwnerUserID), topBlogThreadInCategory), ButtonSizes.Default, HighlightStyles.Lite, IconTypes.View, TextIconLayout.IconText)%> </div>
          </div>
        </li>
      </ul>
      <% }%>
      <% Html.RenderAction("Control_SummaryBlogThreads", "ChannelBlog", new RouteValueDictionary { { "sortBy", BlogThreadSortBy.StickyAndMostRecent }, { "pageIndex", Request.QueryString.GetInt("pageIndex", 1) }, { "categoryID", Html.GetParameterFromRouteDateOrQueryString("categoryID", 0) }, { "tagName", string.Empty } }); %>
    </div>
  </div>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server" id="sidebarContent">
  <script type="text/javascript">
        $(document).ready(function() {
            $(".ui-tabs").tabs({ cookie: { expires: 30} });
        });
    </script>
  <% int BlogApplicationID = ApplicationIDs.Instance().Blog(); %>
  <div id="threadTab" class="ui-tabs ui-widget ui-widget-content ui-corner-all">
    <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
      <li class="ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="#blogThreadListTab"><span><%=GetResourceString("Title_HotArticle", BlogApplicationID)%></span></a></li>
      <li class="ui-state-default ui-corner-top"><a href="<%=SPBUrlHelper.Action("Control_ListBlogThreadsInTab","ChannelBlog",new RouteValueDictionary{{"sortBy",BlogThreadSortBy.TotalReplies},{"siteCategoryID",Html.GetParameterFromRouteDateOrQueryString("CategoryID")},{"tagName",string.Empty},{"pageSize",10}}) %>"> <span><%=GetResourceString("Title_HotCommentArticle", BlogApplicationID)%></span></a></li>
      <li class="ui-state-default ui-corner-top"><a href="<%=SPBUrlHelper.Action("Control_ListBlogThreadsBlock","ChannelBlog",new RouteValueDictionary{{"sortBy",BlogThreadSortBy.MostRecent},{"siteCategoryID",Html.GetParameterFromRouteDateOrQueryString("CategoryID")},{"tagName",string.Empty},{"pageSize",10}}) %>"> <span><%=GetResourceString("Title_NewArticle", BlogApplicationID)%></span></a></li>
    </ul>
    <div id="blogThreadListTab" class="ui-tabs-panel ui-widget-content ui-corner-bottom">
      <% Html.RenderAction<ChannelBlogController>(n => n.Control_ListBlogThreadsInTab(BlogThreadSortBy.MostRecent, Html.GetParameterFromRouteDateOrQueryString("CategoryID", 0), 10)); %>
    </div>
  </div>
  <div class="tn-blank10"></div>
  <div id="siteTags">
    <% Html.RenderAction<ChannelBlogController>(n => n.Control_ListBlogSiteTags(50, SiteTagsSortBy.UserCount)); %>
  </div>
</asp:content>
