﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<SearchResultDataSet<BlogThread>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Blog-Search"
</asp:content>
<asp:content contentplaceholderid="subMenusContent" runat="server">
    <% Html.RenderAction<ChannelBlogController>(n => n.Control_SubMenus()); %>
</asp:content>
<asp:content id="mainContent" contentplaceholderid="mainContent" runat="server">
  <%
      BlogThreadFullTextQuery query = ViewData.Get<BlogThreadFullTextQuery>("Query", null);
    %>
    <div id="search" class="tn-box tn-widget tn-widget-content tn-corner-all spb-photos-main spb-photos-search-results">
              <div class="tn-box-content tn-widget-content tn-corner-all">
                <div class="spb-search-results-box">
                        <form method="post" id="searchForm" class="tn-helper-reset" >

                  <div class="tn-form tn-form-single">
                    <input name="Keyword" id="Keyword" type="text" class="tn-textbox tn-input-longest tn-border-gray" value="<% if (query!=null) Response.Write(query.Keyword); %>" />
                     <%=SPBHtmlHelper.Instance().SubmitButton("SearchButton", GetResourceString("Button_Search"))%>
                     </div>
                  <div class="spb-search-results-select">
                     <%
                         int BlogApplicationID = ApplicationIDs.Instance().Blog();
                         if (Request.IsAuthenticated)
                         {
                             
                %>
  
            <input class="tn-radiobutton" type="radio" name="SearchScopeUserID" id="SearchScopeUserID_all" value="-1" checked="checked" />
            <label for="SearchScopeUserID_all"><%=GetResourceString("Label_SearchAllBlog", BlogApplicationID)%></label>
            <input class="tn-radiobutton" type="radio" name="SearchScopeUserID" id="SearchScopeUserID_my" value="<%= CurrentUser != null ? CurrentUser.UserID : 0%>" <% if (query.SearchScopeUserID == ( CurrentUser != null ? CurrentUser.UserID : 0)) Response.Write("checked=\"checked\""); %> />
            <label for="SearchScopeUserID_my"><%=GetResourceString("Label_SearchMyBlog", BlogApplicationID)%></label>
            <%
                if (CurrentUser != null && query != null && query.SearchScopeUserID > 0 && query.SearchScopeUserID != CurrentUser.UserID)
                {
                    User searchScopeUser = Users.GetUser(query.SearchScopeUserID, false);
                %>
            <input class="tn-radiobutton" type="radio" name="SearchScopeUserID" id="SearchScopeUserID_other" value="<%=searchScopeUser.UserID %>" checked="checked" />
            <label for="SearchScopeUserID_other"><%=string.Format(GetResourceString("Label_Pattern_SearchSomebodyBlog", BlogApplicationID), SPBHtmlHelper.Instance().UserDisplayName(searchScopeUser))%></label>
            <%
                }
                         }
                %>
                  </div>
        </form>
   </div>   
     <% if (ViewData.Model != null)
        {
            if (ViewData.Model.TotalRecords == 0)
            {
                Html.RenderPartial("Controls/Search/NoSearchResult.ascx");
            }
            else
            { %>
     <div class="tn-list-header">
         <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom"><span class="tn-text-note"><%=string.Format(GetResourceString("Description_Pattern_SearchConditionAndTime", BlogApplicationID), ViewData.Model.TotalRecords, ViewData.Model.SearchDuration)%> </span></div>
     </div>
     <ul class="tn-list tn-helper-reset">
          <% foreach (BlogThread blogThread in ViewData.Model.Records)
             { %>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left">
                <% if (blogThread.UserFeaturedImageAttachmentID > 0)
                   { %>
                <img src="<%=SiteUrls.Instance().BlogPhotoUrl(blogThread.UserFeaturedImageAttachmentID, BlogPhotoTypes.Title) %>" />
                <%} %>
            </div>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row tn-list-item-heading">
                    <h5>
                        <a href="<%=SiteUrls.Instance().ShowBlogThread(UserID2UserNameDictionary.GetUserName(blogThread.OwnerUserID),blogThread) %>"
                            target="_blank">
                            <%= blogThread.Subject%></a>
                        <% if (blogThread.IsEssential)
                           {%>
                        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Elite, GetResourceString("Common_Essential"), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
                        <%}
                           if (blogThread.SpecialOrder > 0)
                           {%>
                        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Top, GetResourceString("Common_SetTop"), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
                        <%}%>
                    </h5>                  
                </div>
                 <div class="tn-list-item-row"> 
                 <%if (blogThread.SiteCategory != null)
                   { %>
                  <cite class="tn-text-note"><%=GetResourceString("Common_Category")%><%=GetResourceString("Common_Colon")%><a class="tn-category" href="<%=SPBUrlHelper.Action("ListBlogThreadsByCategory","ChannelBlog",new RouteValueDictionary{{"categoryID",blogThread.SiteCategoryID}}) %>"><%=blogThread.SiteCategory.CategoryName %></a></cite> 
                 <%} %>                 
                  <cite class="tn-text-note"><%=GetResourceString("Label_Author")%><%=GetResourceString("Common_Colon")%>
                  <%=SPBHtmlHelper.Instance().UserDisplayNameLink(blogThread.OwnerUserID,blogThread.Author,ApplicationIDs.Instance().Blog()) %>
                 
                  </cite><em class="tn-date tn-text-note"><%=Formatter.FormatDate(blogThread.PostDate) %></em></div>
                <div class="tn-list-item-row tn-list-item-summary">
                    <p class="tn-helper-reset">
                    <%=blogThread.ForcedExcerpt%>                        
                    </p>
                </div>
 
            </div>
        </li>
          <%	} %>
     </ul>
     <div class="tn-pagination tn-helper-align-center"> 
           <%= SPBHtmlHelper.Instance().PagingButton( PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex)%> 
        </div>
        <%}
        } %>
      </div>
  </div>
</asp:content>
<asp:content id="sidebarContent" contentplaceholderid="sidebarContent" runat="server">
<div id="siteTags">
  <% Html.RenderAction<ChannelBlogController>(n => n.Control_ListBlogSiteTags(20, SiteTagsSortBy.ItemCount)); %>
  </div>
</asp:content>
