﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<PagingDataSet<Club>>" %>

<asp:content contentplaceholderid="subMenusContent" id="topContent" runat="server">
    <% ViewData["currentSubMenu"] = ChannelClubSubMenu.Rank; %>
        <% Html.RenderPartial("Controls/Clubs/ClubSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="Club-ClubRanks"
</asp:content>
<asp:content runat="server" contentplaceholderid="mainContent" id="mainContent">
  <%ClubsSortBy sortBy = (ClubsSortBy)ViewData["sortBy"];
    int applicationId = ApplicationIDs.Instance().Club();
  
      %>  
   <div class="ui-tabs ui-widget ui-widget-content ui-corner-all spb-clubs-list">
    <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
      <li <%if(sortBy== ClubsSortBy.CreateDate){Response.Write(" class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\"");} %>> <a href="<%=SPBUrlHelper.Action("ClubRanks","ChannelClub",new RouteValueDictionary{{"sortBy",ClubsSortBy.CreateDate}}) %>"> <span><%=GetResourceString("Title_CreateDate", applicationId)%></span></a></li>
      <li <%if(sortBy== ClubsSortBy.Points){Response.Write(" class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\"");} %>> <a href="<%=SPBUrlHelper.Action("ClubRanks", "ChannelClub", new RouteValueDictionary { { "sortBy", ClubsSortBy.Points } })%>"> <span><%=GetResourceString("Title_PointsTiptop")%></span></a></li>
      <li <%if(sortBy== ClubsSortBy.MemberCount){Response.Write(" class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\"");} %>> <a href="<%=SPBUrlHelper.Action("ClubRanks", "ChannelClub", new RouteValueDictionary { { "sortBy", ClubsSortBy.MemberCount } })%>"> <span><%=GetResourceString("Title_MemberCount", applicationId)%></span></a></li>
      <li <%if(sortBy== ClubsSortBy.HitTimes){Response.Write(" class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\"");} %>> <a href="<%=SPBUrlHelper.Action("ClubRanks", "ChannelClub", new RouteValueDictionary { { "sortBy", ClubsSortBy.HitTimes } })%>"> <span><%=GetResourceString("Title_HitTimes", applicationId)%></span></a></li>
      <li <%if(sortBy== ClubsSortBy.StageHitTimes){Response.Write(" class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\"");} %>> <a href="<%=SPBUrlHelper.Action("ClubRanks", "ChannelClub", new RouteValueDictionary { { "sortBy", ClubsSortBy.StageHitTimes } })%>"> <span><%=GetResourceString("Title_StageHotClubs", applicationId)%></span></a></li>
    </ul>
     <div class="ui-tabs-panel ui-widget-content ui-corner-bottom">
        <ul class="tn-list tn-helper-reset">
        <% 
           foreach (var club in ViewData.Model.Records)
           { %>
       
          <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left">
              <div class="tn-avatar">
               <a href="<%=SiteUrls.Instance().ClubDomainHome(club.DomainName) %>" target="_blank">
                            <%=SPBHtmlHelper.Instance().ShowClubLogo(club.ClubID, ClubLogoSizeTypes.Small, new RouteValueDictionary { { "alt", club.ClubName } })%>
                        </a>
              </div>
            </div>    <% if (club.IsPublic && CurrentUser != null)
                         {%>
            <div class="tn-list-item-area-right">
              <ul class="tn-list-actions tn-helper-reset">
                <li class="tn-list-action tn-border-gray tn-border-bottom">
             
       <a href="<%=SPBUrlHelper.Action("ApplyClubMember","ClubDomain",new RouteValueDictionary{{"clubDomainName",club.DomainName}}) %>">
            <%=GetResourceString("Action_ApplyClubMember", applicationId)%></a>
      
                </li>
              </ul>
            </div>  <%}%>
            <div class="tn-list-item-area-main">
              <div class="tn-list-item-row tn-list-item-heading">
                <h5 class="tn-helper-reset"><a href="<%=SiteUrls.Instance().ClubDomainHome(club.DomainName) %>" target="_blank"><%=club.ClubName %></a></h5>
              </div>
              <div class="tn-list-item-row tn-list-item-summary">
                <p class="tn-helper-reset"><%=HtmlUtils.TrimHtml(club.Brief,150) %></p>
              </div>
              <div class="tn-list-item-row">
              <em class="tn-count tn-text-note"><%=GetResourceString("Label_ClubMemberCount", applicationId)%><%=GetResourceString("Common_Colon") %><%=club.MemberCount %></em>
              <%if (club.ClubSiteCategoy != null)
                {%>
              <cite class="tn-text-note"><%=GetResourceString("Label_BelongCategory",applicationId )%><%=GetResourceString("Common_Colon") %><a href="<%=SPBUrlHelper.Action("Search","ChannelClub",new RouteValueDictionary{{"categoryID",club.ClubSiteCategoy.CategoryID}}) %>" class="tn-category"><%=club.ClubSiteCategoy.GetMultilingualCategoryName(CurrentUserLanguage)%></a></cite>
              <%} %>
                <%if (!string.IsNullOrEmpty(club.AreaCode))
                  {%>
              <cite class="tn-text-note"><%=GetResourceString("Label_BelongArea",applicationId) %><%=GetResourceString("Common_Colon") %>
                <a class="tn-location" href="<%=SPBUrlHelper.Action("Search","ChannelClub",new RouteValueDictionary{{"areaCode",club.AreaCode}}) %>"><%=Formatter.FormatArea(club.AreaCode,0,2) %></a>
              </cite> <%} %>
              <%if (sortBy == ClubsSortBy.CreateDate)
                {%>
              <em class="tn-date tn-text-note"><%=GetResourceString("Label_ClubCreateDate", applicationId)%><%=GetResourceString("Common_Colon") %><%=Formatter.FormatDate(club.DateCreated) %></em> 
              <%} if (sortBy == ClubsSortBy.HitTimes)
                { %>
              <em class="tn-count tn-text-note"> <%=GetResourceString("Label_PeopleHit", applicationId)%><%=GetResourceString("Common_Colon") %><%=club.HitTimes %></em>
              <%} if (sortBy == ClubsSortBy.StageHitTimes)
                { %>
              <em class="tn-count tn-text-note"><%=GetResourceString("Label_WeekHitTimes", applicationId)%><%=GetResourceString("Common_Colon") %><%=club.StageHitTimes %></em>
              <%} if (sortBy == ClubsSortBy.Points)
                {%>
              <em class="tn-count tn-text-note"><%=GetResourceString("Label_Points", applicationId)%><%=GetResourceString("Common_Colon") %><%=club.Points %></em> <%} %> </div>
            </div>
          </li>

        <%}%>
           </ul>
      <%if (ViewData.Model.TotalRecords > ViewData.Model.PageSize)
        {%>
      <div class="tn-pagination tn-helper-align-center"> <%= SPBHtmlHelper.Instance().PagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7, SPBUrlHelper.Action("ClubRanks","ChannelClub",new RouteValueDictionary{{"sortBy",sortBy},{"pageIndex","{0}"}}))%> 
<div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
      </div>
      <%}%>
    </div>
  </div>
</asp:content>
<asp:content runat="server" contentplaceholderid="sidebarContent" id="sidebarContent">
    <% Html.RenderAction<ChannelClubController>(n => n.Control_ListCategoriesBlock(5)); %>
     <div class="tn-blank10"></div>

    <% Html.RenderAction<ChannelClubController>(n => n.Control_ListAreasBlock()); %>
</asp:content>
<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server">
</asp:content>
