﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage" %>
<asp:content contentplaceholderid="subMenusContent" id="subMenusContent" runat="server">
  <% Html.RenderPartial("Controls/Clubs/ClubSubMenu.ascx"); %>
</asp:content>

<asp:content contentplaceholderid="setPageID" runat="server"> id="Club-CreateClub" </asp:content>
<asp:content runat="server" contentplaceholderid="wideContentRegion" id="wideContentRegion">
  <div class="tn-wrapper">
    <div class="tn-grid">
      <spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js" SetExpireDays="30" />
      <%int applicationId = ApplicationIDs.Instance().Club();  %>
      <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-create-club">
        <div class="tn-box-content tn-widget-content tn-corner-bottom">
          <% int categoryDepth = ViewData.GetInt("SiteCategoryLevel", 1) - 1;
         int areaLevel = ViewData.GetInt("AreaLevel", 1);
         string rootAreaCode = ViewData.GetString("rootAreaCode", string.Empty); %>
          <%
            if (TempData["StatusMessageType"] != null)
            {
                StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessage", string.Empty), false));
            }
            Club club = TempData.Get<Club>("newclub", new Club());
                            %>
          <form id="createClubForm" action="<%=SPBUrlHelper.Action("CreateClub","ChannelClub") %>" method="post">
            <div class="tn-form tn-label-right">
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_ClubName", applicationId)%><%=GetResourceString("Common_Colon") %> </label>
                <input type="text" id="clubName" class="tn-textbox tn-input-long tn-border-gray" name="clubName" value="<%=club.ClubName %>"  />
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"><%=GetResourceString("Label_EspecialUrl", applicationId)%><%=GetResourceString("Common_Colon") %> </label>
                http://
                <input type="text" id="clubDomain" class="tn-textbox tn-input-medium tn-border-gray" name="clubDomain" />
                <% string clubFriendlyUrlPattern = ClubDomainConfiguration.Instance().FriendlyUrlPattern; %>
                <%=clubFriendlyUrlPattern.Substring(clubFriendlyUrlPattern.IndexOf('.'))%>
                <label id="clubDomainLabel" class="tn-message-box"></label>
                <div class="tn-text-note"> <%=GetResourceString("Description_EspecialUrlNotice", applicationId)%></div>
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_ClubBrief", applicationId)%><%=GetResourceString("Common_Colon") %> </label>
                <textarea id="brief" class="tn-textarea tn-input-long tn-border-gray" name="brief"><%=club.Brief %></textarea>
                <div class="tn-text-note"> <%=GetResourceString("Description_ClubBriefNotice", applicationId)%></div>
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_ClubCategory", applicationId)%><%=GetResourceString("Common_Colon") %> </label>
                <% Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(ApplicationIDs.Instance().Club(), categoryDepth, "categoryID", null, "tn-dropdownlist"));%>
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_ClubLocation", applicationId)%><%=GetResourceString("Common_Colon") %> </label>
                <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("areaCode", rootAreaCode, null, areaLevel, "tn-dropdownlist")); %>
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_PublicDegree", applicationId)%><%=GetResourceString("Common_Colon") %> </label>
                <input type="radio" checked="checked" id="clubSecrecyTypePublic" name="clubSecrecyType" class="tn-radiobutton" value="1" />
                <label for="clubSecrecyTypePublic"> <%=GetResourceString("Description_IsPublic", applicationId)%></label>
                <em class="tn-text-note"><%=GetResourceString("Description_ClubSecrecyTypePublic", applicationId)%></em> </div>
              <div id="needApproveDiv" class="tn-form-row">
                <label class="tn-form-label"></label>
                <input type="checkbox" id="needApproveCheckbox" name="needApproveCheckbox" value="1" class="tn-checkbox" />
                <label for="needApproveCheckbox"> <%=GetResourceString("Label_JoinClubNeedApprove", applicationId)%></label>
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"></label>
                <input type="radio" id="clubSecrecyTypePrivate" name="clubSecrecyType" value="0" class="tn-radiobutton" />
                <label for="clubSecrecyTypePrivate"> <%=GetResourceString("Description_IsPrivate", applicationId)%></label>
                <em class="tn-text-note"><%=GetResourceString("Description_clubSecrecyTypePrivate", applicationId)%></em> </div>
              <div class="tn-form-row tn-form-row-button">
                <label class="tn-form-label"></label>
                <%=SPBHtmlHelper.Instance().SubmitButton("createNewClubButton", GetResourceString("Button_CreateClub", applicationId), ButtonSizes.Large, new RouteValueDictionary { { "onclick", "createClubFunction();" } },null)%>
                <% if (Request.UrlReferrer != null)
                   {%>
                <%=SPBHtmlHelper.Instance().CancelButton( Request.UrlReferrer.AbsoluteUri)%>
                <%} %>
              </div>
            </div>
          </form>
          <script type="text/javascript">

                        $(document).ready(function() {

                            $("#createClubForm").validate({
                                rules: {
                                    clubName: { required: true, rangelength: [1, 30] },
                                    clubDomain: { required: true },
                                    categoryID: { required: true, min: 1 },
                                    brief: { required: true, rangelength: [1, 60] }
                                },
                                messages: {
                                    clubName: { required: "<%=GetResourceString("Validate_PleaseWriteClubName", applicationId)%>", rangelength: "<%=GetResourceString("Validate_LengthForClubNameMessage", applicationId)%>" },
                                    clubDomain: { required: "<%=GetResourceString("Validate_PleaseWriteClubUrl", applicationId)%>"},
                                    categoryID: { required: "<%=GetResourceString("Validate_PleaseChooseCategory", applicationId)%>", min: "<%=GetResourceString("Validate_PleaseChooseCategory", applicationId)%>" },
                                    brief: { required: "<%=GetResourceString("Validate_PleaseWriteClubBrief", applicationId)%>", rangelength: "<%=GetResourceString("Validate_LengthForClubBriefMessage", applicationId)%>" }
                                }
                            });
                            
                            $("#clubSecrecyTypePublic").click(function(){
                $("#needApproveDiv").show();
                });
                $("#clubSecrecyTypePrivate").click(function(){
                $("#needApproveDiv").hide();
                });
                <% if (club.IsPublic){%>
                $("#needApproveDiv").show();
                <%}else{ %>
                $("#needApproveDiv").hide();
                <%} %>
                
                $("#clubDomain").blur(function() {
                            if ($('#clubDomain').val() && $('#clubDomain').val() != '')
                                $.getJSON('<%=SPBUrlHelper.Action("ValidateClubDomainName","ChannelClub") %>', { clubDomainName: $('#clubDomain').val() }, function(data) {
                                    $("#clubDomainLabel").text(data.messageContent);
                                    if (data.isSuccess) {
                                        $("#clubDomainLabel").removeClass("tn-cue-error").addClass("tn-cue-success");
                                        $('#createNewClubButton').removeAttr("disabled");
                                    }
                                    else {
                                        $("#clubDomainLabel").removeClass("tn-cue-success").addClass("tn-cue-error");
                                        $('#createNewClubButton').attr("disabled", "disabled");
                                    }
                                });
                        });
                        
                        });

                        var createClubFunction = function() {
                            if ($("#createClubForm").valid()) {
                                $("#createNewClubButton").hide();
                                $("#createNewClubButton_ForHide").show();
                            }
                            else{
                                return false;
                            }
                        }
                            </script>
        </div>
      </div>
    </div>
  </div>
</asp:content>
<asp:content id="templateContentRegion" contentplaceholderid="templateContentRegion"
    runat="server"> </asp:content>
