﻿<%@ Page Title="" Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<PagingDataSet<Club>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Club-Search"
</asp:content>
<asp:content contentplaceholderid="subMenusContent" id="topContent" runat="server">
    <% ViewData["currentSubMenu"] = ChannelClubSubMenu.Search; %>
        <% Html.RenderPartial("Controls/Clubs/ClubSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server">
</asp:content>
<asp:content id="mainContent" contentplaceholderid="mainContent" runat="server">
  <%
      int applicationId = ApplicationIDs.Instance().Club();
      string keyword = Html.GetParameterFromRouteDateOrQueryString("keyword");
      int categoryID = Html.GetParameterFromRouteDateOrQueryString("categoryID", 0);
      string areaCode = Html.GetParameterFromRouteDateOrQueryString("areaCode");
      List<SiteCategory> siteCategories = ViewData.Get<List<SiteCategory>>("siteCategories", null);
      Stack<SiteCategory> categoryStack = ViewData.Get<Stack<SiteCategory>>("categoryStack", null);
      List<ClubAreaStatistics> areas = ViewData.Get<List<ClubAreaStatistics>>("areas", null);
      Stack<ClubAreaStatistics> areaStack = ViewData.Get<Stack<ClubAreaStatistics>>("areaStack", null);
      int maxShowDictionaryCount = 12;
      string currentCategoryName = ViewData.GetString("CurrentCategoryName", string.Empty);
      string currentAreaName = ViewData.Get("CurrentAreaName", string.Empty);
    %>

   <div class="tn-box tn-widget tn-widget-content tn-corner-all">
              <div class="tn-box-content tn-widget-content tn-corner-all">
                <div class="tn-directory">
                  <h5 class="tn-directory-path">
                   <a href="<%=SPBUrlHelper.Action("Search","ChannelClub",new RouteValueDictionary{{"areaCode",areaCode},{"keyword",WebUtils.UrlEncode(keyword)}}) %>"><%=GetResourceString("Title_AlllCategory")%></a>
                   <%
                       SiteCategory category = null;
                       while (categoryStack.Count > 0)
                       {
                           category = categoryStack.Pop();
                           if (categoryStack.Count == 0)
                               Response.Write(string.Format(" &gt; {0}", category.CategoryName));
                           else
                               Response.Write(string.Format(" &gt; <a href=\"{0}\">{1}</a>", SPBUrlHelper.Action("Search", "ChannelClub", new RouteValueDictionary { { "areaCode", areaCode }, { "categoryID", category.CategoryID }, { "keyword", WebUtils.UrlEncode(keyword) } }), category.CategoryName));
                       }
                        %>
                   </h5>
                  <div class="tn-directory-level tn-border-gray tn-border-bottom" id="allSiteCategoryList">
                  <%if (category != null)
                    { %>
                  <span class="tn-directory-item <%if (category != null && category.CategoryID == categoryID) { Response.Write(" tn-text-note tn-selected"); } %>"><a href="<%=SPBUrlHelper.Action("Search", "ChannelClub", new RouteValueDictionary { { "areaCode", areaCode },{"categoryID",category.CategoryID},{"keyword",WebUtils.UrlEncode(keyword)} }) %>"><%=GetResourceString("Enum_Genders_All")%></a></span>
                  <%}
                    else
                    { %>
                  <span class="tn-directory-item <%if (categoryID < 1) { Response.Write(" tn-text-note tn-selected"); } %>"><a href="<%=SPBUrlHelper.Action("Search", "ChannelClub", new RouteValueDictionary { { "areaCode", areaCode },{"keyword",WebUtils.UrlEncode(keyword)} }) %>"><%=GetResourceString("Enum_Genders_All")%></a></span>
                  <%} %>
                  <%int i = 0;
                    foreach (SiteCategory siteCategory in siteCategories)
                    {
                        i++;%>
                  <span <%if (i > maxShowDictionaryCount) { Response.Write("style=\"display:none;\""); } %> class="tn-directory-item <%if (categoryID == siteCategory.CategoryID) { Response.Write(" tn-text-note tn-selected"); } %>"><a href="<%=SPBUrlHelper.Action("Search", "ChannelClub", new RouteValueDictionary { { "areaCode", areaCode },{"categoryID",siteCategory.CategoryID},{"keyword",WebUtils.UrlEncode(keyword)} }) %>"><%=siteCategory.CategoryName %></a> <em class="tn-text-note"><%=siteCategory.ItemCount %></em></span>
                  <%}%>
                  <%if (siteCategories.Count > maxShowDictionaryCount)
                    { %>
                    <span class="tn-action tn-action-text-icon-right"><span id="span-morecategory" class="tn-icon tn-icon-triangle-down"></span>
                        <a id="morecategory" href="javascript:;" class="tn-action-text"><%=GetResourceString("Action_OpenMoreClass")%></a> </span>
                        <%} %>
                  </div>
                  <h5 class="tn-directory-path"> 
                  <a href="<%=SPBUrlHelper.Action("Search","ChannelClub",new RouteValueDictionary{{"categoryID",categoryID},{"keyword",WebUtils.UrlEncode(keyword)}}) %>"><%=GetResourceString("Title_Alllarea")%></a>
                    <%
                        ClubAreaStatistics area = null;
                        while (areaStack.Count > 0)
                        {
                            area = areaStack.Pop();
                            if (areaStack.Count == 0)
                                Response.Write(string.Format(" &gt; {0}", area.Name));
                            else
                                Response.Write(string.Format(" &gt; <a href=\"{0}\">{1}</a>", SPBUrlHelper.Action("Search", "ChannelClub", new RouteValueDictionary { { "areaCode", area.AreaCode }, { "categoryID", categoryID }, { "keyword", WebUtils.UrlEncode(keyword) } }), area.Name));
                        }
                        %>
                   </h5>
                   </div>
                   <div class="tn-directory">
                  <div id="areasList" class="tn-directory-level tn-border-gray tn-border-bottom">
                  <%if (area != null)
                    { %>
                  <span class="tn-directory-item <%if (area != null && area.AreaCode == areaCode) { Response.Write(" tn-text-note tn-selected"); } %>"><a href="<%=SPBUrlHelper.Action("Search", "ChannelClub", new RouteValueDictionary { { "areaCode", area.AreaCode },{"categoryID",categoryID},{"keyword",WebUtils.UrlEncode(keyword)} }) %>"><%=GetResourceString("Enum_Genders_All")%></a></span>
                  <%}
                    else
                    {%>
                  <span class="tn-directory-item <%if (string.IsNullOrEmpty(areaCode)) { Response.Write(" tn-text-note tn-selected"); } %>"><a href="<%=SPBUrlHelper.Action("Search", "ChannelClub", new RouteValueDictionary {{"categoryID",categoryID},{"keyword",WebUtils.UrlEncode(keyword)} }) %>"><%=GetResourceString("Enum_Genders_All")%></a></span>
                  <%} %><%int j = 0;
                          if (areas != null)
                          {
                              foreach (ClubAreaStatistics clubAreaStatistics in areas)
                              {
                                  j++;%><span <%if (j > maxShowDictionaryCount) { Response.Write("style=\"display:none;\""); } %> class="tn-directory-item <%if (clubAreaStatistics.AreaCode == areaCode) { Response.Write(" tn-text-note tn-selected"); } %>">
                                  <a href="<%=SPBUrlHelper.Action("Search", "ChannelClub", new RouteValueDictionary { { "areaCode", clubAreaStatistics.AreaCode }, { "categoryID", categoryID },{"keyword",WebUtils.UrlEncode(keyword)} }) %>"><%=clubAreaStatistics.Name %></a> <em class="tn-text-note"><%=clubAreaStatistics.CumulateTotalCount %></em></span><%}
                    }%> <%if (areas != null && areas.Count > maxShowDictionaryCount)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  { %><span class="tn-action tn-action-text-icon-right"><span id="span-moreAreas" class="tn-icon tn-icon-triangle-down"></span>
                        <a id="moreAreas" href="javascript:;" class="tn-action-text"><%=GetResourceString("Action_OpenMoreArea")%></a> </span><%} %>
                  </div>
                  </div>
                  <div class="tn-directory-search tn-border-gray tn-border-bottom tn-helper-clearfix">
                    <form method="post" id="ManageSearchForm" action="<%=SPBUrlHelper.Action("Search","ChannelClub",new RouteValueDictionary{{"areaCode",areaCode},{"categoryID",categoryID}}) %>">
                    <div class="tn-search-box tn-helper-clearfix">
                      <input type="text" value="<%=keyword %>" name="keyword" class="tn-search-input tn-input-medium tn-border-gray tn-border-tbl"/>
                      <span class="tn-search-button tn-search-ico-button tn-border-gray tn-bg-gray">
                      <button onclick="$('#ManageSearchForm').submit();"><span class="tn-icon tn-icon-find"></span></button>
                      </span>
                      </div>
                      </form>
                    <div class="tn-directory-selected">
                    <%if (!string.IsNullOrEmpty(currentCategoryName))
                      {%>
                    <span class="tn-directory-selected-item tn-border-gray tn-bg-gray"><a class="tn-icon tn-icon-cross" href="<%=SPBUrlHelper.Action("Search","ChannelClub",new RouteValueDictionary{{"areaCode",areaCode},{"keyword",WebUtils.UrlEncode(keyword)}}) %>"></a><%=currentCategoryName %></span>
                    <%} %>
                    <%if (!string.IsNullOrEmpty(currentAreaName))
                      {%>
                    <span class="tn-directory-selected-item tn-border-gray tn-bg-gray"><a class="tn-icon tn-icon-cross" href="<%=SPBUrlHelper.Action("Search","ChannelClub",new RouteValueDictionary{{"categoryID",categoryID},{"keyword",WebUtils.UrlEncode(keyword)}}) %>"></a><%=currentAreaName %></span>
                    <%} %>
                    <%if (!string.IsNullOrEmpty(keyword))
                      {%>
                    <span class="tn-directory-selected-item tn-border-gray tn-bg-gray"><a class="tn-icon tn-icon-cross" href="<%=SPBUrlHelper.Action("Search","ChannelClub",new RouteValueDictionary{{"categoryID",categoryID},{"areaCode",areaCode}}) %>"></a><%=keyword %></span>
                    <%} %>
                    </div>
                  </div>
                <div class="tn-directory-result">
                <ul class="tn-list tn-helper-reset">
        <% 
            foreach (var club in ViewData.Model.Records)
            {%>
       
          <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left">
              <div class="tn-avatar">
               <a href="<%=SiteUrls.Instance().ClubDomainHome(club.DomainName) %>" target="_blank">
                            <%=SPBHtmlHelper.Instance().ShowClubLogo(club.ClubID, ClubLogoSizeTypes.Small, new RouteValueDictionary { { "alt", club.ClubName } })%>
                        </a>
              </div>
            </div>    <% if (club.IsPublic && CurrentUser != null)
                         {%>
            <div class="tn-list-item-area-right">
              <ul class="tn-list-actions tn-helper-reset">
                <li class="tn-list-action tn-border-gray tn-border-bottom">
             
       <a href="<%=SPBUrlHelper.Action("ApplyClubMember","ClubDomain",new RouteValueDictionary{{"clubDomainName",club.DomainName}}) %>">
            <%=GetResourceString("Action_ApplyClubMember", applicationId)%></a>
      
                </li>
              </ul>
            </div>  <%}%>
            <div class="tn-list-item-area-main">
              <div class="tn-list-item-row tn-list-item-heading">
                <h5 class="tn-helper-reset"><a href="<%=SiteUrls.Instance().ClubDomainHome(club.DomainName) %>" target="_blank"><%=club.ClubName %></a></h5>
              </div>
              <div class="tn-list-item-row tn-list-item-summary">
                <p class="tn-helper-reset"><%=HtmlUtils.TrimHtml(club.Brief,150) %></p>
              </div>
              <div class="tn-list-item-row">
              <em class="tn-count tn-text-note"><%=GetResourceString("Label_ClubMemberCount", applicationId)%><%=GetResourceString("Common_Colon") %><%=club.MemberCount %></em>
              <%if (club.ClubSiteCategoy != null)
                {%>
              <cite class="tn-text-note"><%=GetResourceString("Label_BelongCategory",applicationId )%><%=GetResourceString("Common_Colon") %><a href="<%=SPBUrlHelper.Action("Search","ChannelClub",new RouteValueDictionary{{"categoryID",club.ClubSiteCategoy.CategoryID}}) %>" class="tn-category"><%=club.ClubSiteCategoy.GetMultilingualCategoryName(CurrentUserLanguage)%></a></cite>
              <%} %>
                <%if (!string.IsNullOrEmpty(club.AreaCode))
                  {%>
              <cite class="tn-text-note"><%=GetResourceString("Label_BelongArea",applicationId) %><%=GetResourceString("Common_Colon") %>
                <a class="tn-location" href="<%=SPBUrlHelper.Action("Search","ChannelClub",new RouteValueDictionary{{"areaCode",club.AreaCode}}) %>"><%=Formatter.FormatArea(club.AreaCode,0,2) %></a>
              </cite> 
              <%} %>
              <em class="tn-date tn-text-note"><%=GetResourceString("Label_ClubCreateDate", applicationId)%><%=GetResourceString("Common_Colon") %><%=Formatter.FormatDate(club.DateCreated) %></em> 
              </div>
            </div>
          </li>

        <%}%>
           </ul>
      <%if (ViewData.Model.TotalRecords > ViewData.Model.PageSize)
        {%>
      <div class="tn-pagination tn-helper-align-center"> <%= SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious,ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex)%> 
<div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
      </div>
      <%}%>
                </div>
              </div>
            </div>
            
            <script type="text/javascript">
                $(document).ready(function() {

                    $("#moreAreas").click(function() {
                        var $moreAreas = $('#areasList span.tn-directory-item:gt(<%=maxShowDictionaryCount %>)');
                        $moreAreas.toggle();
                        if ($moreAreas.is(":visible")) {
                            $(this).text('<%=GetResourceString("Action_EasyArea")%>');
                            $("#span-moreAreas").attr({ className: "tn-icon tn-icon-triangle-up", style: "display:block" });
                        }
                        else {
                            $(this).text('<%=GetResourceString("Action_OpenMoreArea")%>');
                            $("#span-moreAreas").attr({ className: "tn-icon tn-icon-triangle-down", style: "display:block" });
                        };
                    });

                    $("#morecategory").click(function() {
                        var $moreCategories = $('#allSiteCategoryList span:not(.tn-action):gt(<%=maxShowDictionaryCount %>)');
                        $moreCategories.toggle();
                        if ($moreCategories.is(":visible")) {
                            $(this).text('<%=GetResourceString("Action_EasyClass")%>');
                            $("#span-morecategory").attr({ className: "tn-icon tn-icon-triangle-up", style: "display:block" });
                        }
                        else {
                            $(this).text('<%=GetResourceString("Action_OpenMoreClass")%>');
                            $("#span-morecategory").attr({ className: "tn-icon tn-icon-triangle-down", style: "display:block" });
                        };
                    });

                });
            
            
            </script>
            
            
</asp:content>
<asp:content id="sidebarContent" contentplaceholderid="sidebarContent" runat="server">
        <%  PersonUser currentPersonUser = Globals.GetCurrentUser() as PersonUser;
            if (currentPersonUser != null && currentPersonUser != null && !string.IsNullOrEmpty(currentPersonUser.NowAreaCode))
            {
                Html.RenderAction<ChannelClubController>(n => n.Control_ListClubsBySameArea(ClubsSortBy.CreateDate, 4, currentPersonUser.NowAreaCode));
            } %>
      <%     //推荐群组
          Html.RenderAction("Control_RecommendClubBlock", "ChannelClub", new RouteValueDictionary { { "commendTypeID", 231001 }, { "displayCount", 4 }, { "hasBorder", true } });
          Html.RenderAction<ChannelClubController>(n => n.Control_ListNewClubs(4));
%>
<%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001002310005", new RouteValueDictionary { { "class", "spb-ad-side-bottom" } })%>
</asp:content>
