﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<PagingDataSet<ConvertibleGift>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="ConvertibleGift-ListGifts"
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server" id="mainContent">
  <%ConvertibleGiftSortBy sortBy = (ConvertibleGiftSortBy)ViewData["sortBy"];
    int minPrice = ViewData.GetInt("minPrice", 0);
    int maxPrice = ViewData.GetInt("maxPrice", ValueHelper.GetSqlMaxInt());
    RouteValueDictionary dictionary = new RouteValueDictionary { { "minPrice", minPrice }, { "maxPrice", maxPrice } };
    int userApplicationID = ApplicationIDs.Instance().User();  %>
    <%Html.RenderPartial("Controls/ConvertibleGifts/PriceArea.ascx"); %>
    <div class="tn-blank10"></div>
    
  <div id="listGifts" class="ui-tabs ui-widget ui-widget-content ui-corner-all spb-gifts-list-all">
 
  <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
    <li class="ui-state-default ui-corner-top  <%if(sortBy== ConvertibleGiftSortBy.DateCreated){Response.Write(" ui-tabs-selected ui-state-active");} %>"> <a href="<%=SPBUrlHelper.Action("ListGifts","ChannelConvertibleGift",new RouteValueDictionary(dictionary){{"sortBy",ConvertibleGiftSortBy.DateCreated}}) %>"> <span><%=GetResourceString("Label_TheLatestShelves", userApplicationID)%></span></a></li>
    <li class="ui-state-default ui-corner-top <%if(sortBy== ConvertibleGiftSortBy.ExchangedCount){Response.Write(" ui-tabs-selected ui-state-active");} %>"> <a href="<%=SPBUrlHelper.Action("ListGifts", "ChannelConvertibleGift", new RouteValueDictionary (dictionary){ { "sortBy", ConvertibleGiftSortBy.ExchangedCount } })%>"> <span><%=GetResourceString("Label_PurchaseAtMost", userApplicationID)%></span></a></li>
    <li class="ui-state-default ui-corner-top <%if(sortBy== ConvertibleGiftSortBy.Price){Response.Write(" ui-tabs-selected ui-state-active");} %>"> <a href="<%=SPBUrlHelper.Action("ListGifts", "ChannelConvertibleGift", new RouteValueDictionary(dictionary) { { "sortBy", ConvertibleGiftSortBy.Price } })%>"> <span><%=GetResourceString("Label_TheLowestPrice", userApplicationID)%></span></a></li>
  </ul>
          <div class="ui-tabs-panel ui-widget-content ui-corner-bottom">
      <ul class="tn-list tn-helper-reset">
        <%foreach (ConvertibleGift gift in ViewData.Model.Records)
          { %>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
          <div class="tn-list-item-area-left"><a  href="<%=SPBUrlHelper.Action("ShowGift", "ChannelConvertibleGift",new RouteValueDictionary {{"giftID",gift.GiftID}})%>">
            <%if (gift != null && !string.IsNullOrEmpty(gift.ImageFileName))
              {
                  Response.Write(string.Format("<img src=\"{0}\" width=\"60\" height=\"60\" /><br/>", SiteUrls.Instance().GiftPhoto(gift)));
              } %>
            </a> </div>
          <div class="tn-list-item-area-right"> 
          <div class="tn-list-figure tn-widget">
           <div class=" tn-list-figure-count tn-widget-content tn-corner-top">
<%=gift.ExchangedCount %><br />
          <%=GetResourceString("Title_PeopleBuy",userApplicationID)%></div>
          
          
          
          <% if (CurrentUser == null)
             {%>
<a href="<%=SiteUrls.Instance().Login(true)%>" class="tn-list-figure-button tn-state-default tn-corner-bottom">
          <%=GetResourceString("Button_WantToCash",userApplicationID)%>
          </a>                     <%}
             else
             {%>
<a href="<%=SPBUrlHelper.Action("Control_NewGiftApply", "ChannelConvertibleGift",new RouteValueDictionary {{"giftID",gift.GiftID}}) %>" class="tn-list-figure-button tn-state-default tn-corner-bottom nyroModal">
          <%=GetResourceString("Button_WantToCash",userApplicationID)%>
          </a>                     <%} %>
          
          </div> </div>
          <div class="tn-list-item-area-main">
          <div class="tn-list-item-row tn-list-item-heading">
          <h5 class="tn-helper-reset"><a href="<%=SPBUrlHelper.Action("ShowGift", "ChannelConvertibleGift",new RouteValueDictionary {{"giftID",gift.GiftID}})%>"><%=gift.Subject %></a></h5></div>
          
                    <div class="tn-list-item-row">
                    <span class="tn-icon tn-icon-coins tn-icon-inline"></span>
                   <%=GetResourceString("Common_Colon")%><%=gift.Price%><em class="tn-count"><%=GetResourceString("Label_AtPresentNumber",userApplicationID)%><%=GetResourceString("Common_Colon")%><%=gift.TotalCount %></em>  </div>

          
          <div class="tn-list-item-row tn-list-item-summary">
          <p  class="tn-helper-reset"><%=HtmlUtils.TrimHtml(gift.Body,130) %></p>
          </div>
        </div>
        </li>
        <%}%>
      </ul>
 
  </div>
  <div class="tn-pagination tn-helper-align-center"> <%= SPBHtmlHelper.Instance().PagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7, SPBUrlHelper.Action("ListGifts", "ChannelConvertibleGift", new RouteValueDictionary(dictionary) { { "sortBy", sortBy }, { "pageIndex", "{0}" } }))%>
    <div class="tn-page-results tn-text-note">
    <%=string.Format(GetResourceString("Label_Pattern_TotalRecords", userApplicationID), ViewData.Model.TotalRecords)%>
    </div>
  </div>
  <script type="text/javascript">

      $(document).ready(function() {
          $('a.nyroModal').nyroModal({
              resizeable: true,
              width: 300,
              height: 400
          });
      });

</script>
</div>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server" id="sidebarContent">
<div id="recommend">
      <%
          //推荐礼品
          Html.RenderAction("Control_RecommendContibleGiftBlock", "ChannelConvertibleGift", new RouteValueDictionary { { "commendTypeID", 40001 }, { "displayCount", 8 }, { "hasBorder", true } });
    %></div>
</asp:content>
<asp:content contentplaceholderid="wideContentRegion" runat="server" id="wideContentRegion" />
