﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<PagingDataSet<ConvertibleGiftExchangeRecord>>" %>

<asp:content id="templateContentRegion" contentplaceholderid="templateContentRegion"
    runat="server" />
<asp:content contentplaceholderid="setPageID" runat="server">
    id="ConvertibleGift-ShowGift"
</asp:content>
<asp:content id="Content2" contentplaceholderid="wideCenterContent" runat="server">
<%ConvertibleGift gift = ViewData.Get<ConvertibleGift>("gift");
  int userApplicationID = ApplicationIDs.Instance().User();
     %>
  <div id="showGift" class="tn-box tn-widget tn-widget-content tn-corner-all spb-gift-show">
          <div class="tn-box-content tn-widget-content tn-corner-all">
        <div class="spb-gift-details tn-helper-clearfix">
            <div class="spb-gift-box tn-bg-light tn-border-light">
              <%if (gift != null && !string.IsNullOrEmpty(gift.ImageFileName))
                {
                    Response.Write(string.Format("<img src=\"{0}\" width=\"100\" height=\"100\" /><br/>", SiteUrls.Instance().GiftPhoto(gift)));
                } %>
            
               <%if (gift.IsEnabled)
                 {%>
              <div class="spb-gift-action">
             
            <% if (CurrentUser == null)
               {%>
                    <%=SPBHtmlHelper.Instance().LinkButton(gift.GiftID.ToString(), GetResourceString("Button_WantToCash", userApplicationID), SiteUrls.Instance().Login(true), ButtonSizes.Large, HighlightStyles.Primary, null, TextIconLayout.TextOnly, null, null)%>
                    <%}
               else
               {%>
                    <%=SPBHtmlHelper.Instance().LinkButton(gift.GiftID.ToString(), GetResourceString("Button_WantToCash", userApplicationID), SPBUrlHelper.Action("Control_NewGiftApply", "ChannelConvertibleGift", new RouteValueDictionary { { "giftID", gift.GiftID } }), ButtonSizes.Large, HighlightStyles.Primary, null, TextIconLayout.TextOnly, new RouteValueDictionary { { "class", "nyroModal" } }, null)%>
                    <%} %>
            </div>
            <%} %>
        </div>
            <div class="tn-info-part tn-helper-flowfix">
                <dl>
                    <dt><%=GetResourceString("Label_GiftName", userApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
                    <dd><%=gift.Subject%></dd>
                    </dl>
                   <dl>
                    <dt><%=GetResourceString("Label_ResidualQuantity", userApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
                    <dd><%=gift.TotalCount%></dd>
                    </dl>
                     <dl>
                    <dt><%=GetResourceString("Label_ThePurchasePrice", userApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
                    <dd><%=gift.Price%></dd>
                  </dl>
                  <dl>
                    <dt><%=GetResourceString("Label_HaveBuy", userApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
                    <dd><%=gift.ExchangedCount%></dd>
                </dl> <dl>
               <dt><%=GetResourceString("Label_GiftDescription", userApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
               <dd>
               <%=gift.Body %></dd> </dl>
            </div>
          </div>
          <table class="tn-table-grid">
             <tr class="tn-table-grid-header">
              <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_BuyGiftName", userApplicationID)%></th>
              <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_BuyingTime", userApplicationID)%></th>
            </tr>
            <%foreach (ConvertibleGiftExchangeRecord record in ViewData.Model.Records)
              {
                  if (record.GiftID > 0)
                  {
               %>
               <tr class="tn-table-grid-row">
                <th class="tn-border-gray tn-border-bottom tn-width-auto">
                 <a href="<%=SiteUrls.Instance().UserChannelHome(record.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"> <%=string.IsNullOrEmpty(record.UserDisplayName)?SPBHtmlHelper.Instance().UserDisplayName(record.UserID):record.UserDisplayName %></a><%=string.Format(GetResourceString("Label_SpendPointForBuy",userApplicationID),record.Price)%><a  href="<%=SPBUrlHelper.Action("ShowGift", "ChannelConvertibleGift",new RouteValueDictionary {{"giftID",record.GiftID}})%>"><%=ConvertibleGifts.GetGift(record.GiftID, false).Subject%></a>
                    <%=record.TotalCount%><%=GetResourceString("Label_ge",userApplicationID) %>
                </th>
                <td class="tn-border-gray tn-border-bottom tn-width-datetime tn-nowrap">
                <%=Formatter.FormatDate(record.DateCreated,true)%>
                </td>
              </tr>

            <%}
              }%>
          </table>
           <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().PagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("ShowGift", "ChannelConvertibleGift", new RouteValueDictionary {{"giftID",gift.GiftID},{ "pageIndex", "{0}" } }))%>
                <div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords", ApplicationIDs.Instance().User()), ViewData.Model.TotalRecords)%></div>
          </div>
     
      </div>
    </div>
</asp:content>
