﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<EventThread>" %>

<asp:content id="templateContentRegion" contentplaceholderid="templateContentRegion"
    runat="server"></asp:content>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
    <% Html.RenderPartial("Controls/Events/ChannelEventSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server">
    <spb:Script runat="server" ID="swfupload" Src="~/Utility/UploadFiles/js/swfupload.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="swfupload_queue" Src="~/Utility/UploadFiles/js/swfupload.queue.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="fileprogress" Src="~/Utility/UploadFiles/js/fileprogress.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="handlers" Src="~/Utility/UploadFiles/js/handlers.js"
        SetExpireDays="30" />
        

  <% 
      EventThread eventThread = ViewData.Model;

      string actionUrl = string.Empty;
      if (eventThread.EventID > 0)
          actionUrl = SPBUrlHelper.Action("UpdateEvent", "ChannelEvent", new RouteValueDictionary { { "eventID", eventThread.EventID } });
      else
          actionUrl = SPBUrlHelper.Action("CreateEvent", "ChannelEvent", new RouteValueDictionary { { "clubID", Request.QueryString.GetInt("ClubID", -1) } });
      int EventApplicationID = ApplicationIDs.Instance().Event();
      int UserApplicationID = ApplicationIDs.Instance().User();
      string body = eventThread.GetBodyForEdit();
    
    %>
    <div class="tn-wrapper">
<div class="tn-grid">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-new-event">
        <div class="tn-box-content tn-widget-content tn-corner-all">
            <div class="tn-instructions">
                <div class="tn-progress-bar tn-widget-content tn-corner-all">
                    <div style="width: 250px;" class="tn-progress-bar-value tn-widget-header tn-corner-left tn-border-tbl">
                    </div>
                </div>
                <ul class="tn-helper-clearfix">
                    <% if (eventThread.EventID <= 0)  //正在创建活动
                       { %>
                    <li class="tn-step tn-selected"><b class="tn-widget-content tn-widget-header tn-corner-all">
                    </b><span><a href="#">
                        <%=GetResourceString("Description_FirstStepEventBody", EventApplicationID)%></a></span></li>
                    <li class="tn-step"><b class="tn-widget-content tn-corner-all"></b><span>
                        <%=GetResourceString("Description_SecondStepEventSet", EventApplicationID)%></span></li>
                    <%}
                       else      //编辑活动
                       { %>
                    <% if (CurrentUser != null && EventPermission.Validate(eventThread, CurrentUser, PermissionItemKeys.Instance().EditEvent()))
                       { %>
                    <li class="tn-step tn-selected"><b class="tn-widget-content tn-widget-header tn-corner-all">
                    </b><span><a href="<%=SPBUrlHelper.Action("EditEvent","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID}}) %>">
                        <%=GetResourceString("Description_FirstStepEventBody", EventApplicationID)%></a></span>
                    </li>
                    <li class="tn-step"><b class="tn-widget-content tn-corner-all"></b><span><a href="<%=SPBUrlHelper.Action("ShowEventSettings","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID}}) %>">
                        <%=GetResourceString("Description_SecondStepEventSet", EventApplicationID)%></a></span> </li>
                    <%}
               }%>
                </ul>
            </div>
            <% if (TempData["StatusMessageType"] != null)
               {
                   StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                   if (messageType == StatusMessageType.Success)
                       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
                   else
                       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), false));
                   TempData["StatusMessageType"] = null;
               }
            %>
            <form id="EditEventForm" name="EditEventForm" action="<%=actionUrl %>" method="post"
            class="tn-helper-reset">
            <div class="tn-form-box">
                <table>
                    <tbody>
                        <tr>
                            <th>
                                <%=GetResourceString("Label_Subject")%><%=GetResourceString("Common_Colon") %>
                            </th>
                            <td>
                                <input name="eventName" type="text" class="tn-textbox tn-input-longest tn-border-gray"
                                    id="eventName" value="<%=Formatter.FormatSingleLinePlainTextForEdit(eventThread.EventName) %>" />
                                <span class="tn-form-required">
                                    <%=GetResourceString("Description_Required")%></span> <span class="tn-text-note">
                                        <%=GetResourceString("Description_TitleLimit",EventApplicationID)%></span>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <%=GetResourceString("Label_StartTime",EventApplicationID)%><%=GetResourceString("Common_Colon") %>
                            </th>
                            <td>
                                <span id="showTime" <%if (eventThread.IsWholeDay) Response.Write("style=\"display:none;\""); %>>
                                    <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("startTime", null, null, eventThread.StartTime, true, "tn-textbox tn-input-medium tn-border-gray")); %>到
                                    <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("endTime", null, null, eventThread.EndTime, true, "tn-textbox tn-input-medium tn-border-gray")); %>
                                </span><span id="notShowTime" <%if (!eventThread.IsWholeDay) Response.Write("style=\"display:none;\""); %>>
                                    <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("startTimeIsNotWholeDay", null, null, eventThread.StartTime, false, "tn-textbox tn-input-medium tn-border-gray")); %>
                                    到
                                    <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("endTimeIsNotWholeDay", null, null, eventThread.EndTime, false, "tn-textbox tn-input-medium tn-border-gray")); %>
                                </span>
                                <input type="checkbox" value="true" id="isWholeDay" name="isWholeDay" <%if (eventThread.IsWholeDay) Response.Write("checked=\"checked\""); %> /><label
                                    for="isWholeDay"><%=GetResourceString("Title_WholeDay",EventApplicationID)%></label>

                                <script type="text/javascript">
                                    $(document).ready(function () {
                                        $('#isWholeDay').click(function () {
                                            if ($("#isWholeDay").attr("checked") == true) {

                                                $('#showTime').css('display', 'none');
                                                $('#notShowTime').css('display', '');
                                            }
                                            else {

                                                $('#showTime').css('display', '');
                                                $('#notShowTime').css('display', 'none');
                                            }
                                        });
                                    });
                                </script>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <%=GetResourceString("Label_SignUpEndTime",EventApplicationID)%><%=GetResourceString("Common_Colon") %>
                            </th>
                            <td>
                                <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("signEndTime", null, null, eventThread.SignEndTime, true, "tn-textbox tn-input-medium tn-border-gray")); %>
                                <em class="tn-text-note">
                                    <%=GetResourceString("Description_DateNoFillSelectCurrentDate",EventApplicationID)%></em>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <%=GetResourceString("Label_LocalArea",EventApplicationID)%><%=GetResourceString("Common_Colon") %>
                            </th>
                            <td>
                                <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("areaCode", EventConfiguration.Instance().RootAreaCode, eventThread.AreaCode, EventConfiguration.Instance().AreaLevel, "tn-dropdownlist")); %>
                                <input name="location" type="text" class="tn-textbox tn-input-long tn-border-gray"
                                    id="location" value="<%=eventThread.Location %>" />
                                <span class="tn-form-required">
                                    <%=GetResourceString("Description_Required")%></span>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %>
                            </th>
                            <td>
                                <% string uploadPhotoUrl = SPBUrlHelper.Action("UserContentSelector_UpdateEventAttachments", "ChannelEvent", new RouteValueDictionary { { "threadID", eventThread.EventID } }); %>
                                <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Enhanced, "body", body, new RouteValueDictionary { { "style", "height: 328px; width:100%" } }, uploadPhotoUrl,string.Empty)%>
                                <input type="hidden" value="<%=eventThread.FeaturedPhotoID %>" id="featuredPhotoID"
                                    name="featuredPhotoID" />
                            </td>
                        </tr>
                        <tr>
                            <th>
                            </th>
                            <td>
                                <span class="tn-text-note">
                                    <%=string.Format(GetResourceString("Description_Pattern_WordCountLimit"),EventConfiguration.Instance().EventDescriptionMaxLength) %>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <%=GetResourceString("Label_EventOpenDegree",EventApplicationID)%><%=GetResourceString("Common_Colon") %>
                            </th>
                            <td>
                            <%if (Model != null && Model.EventID > 0)
                              {
                                  Response.Write(eventThread.IsPublic ? "公开活动" : "私有活动");
                              }
                              else
                              { %>
                                <input name="isPublic" id="isPublic-true" type="radio" class="tn-radiobutton" value="1"
                                    <%if(eventThread.IsPublic || eventThread.EventID<=0) Response.Write("checked=\"checked\""); %> />
                                <label for="isPublic-true">
                                    <%=GetResourceString("Description_OpenEvent", EventApplicationID)%></label>
                                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Question, GetResourceString("Description_AllUserCanSee", EventApplicationID), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
                                <input name="isPublic" id="isPublic-false" type="radio" class="tn-radiobutton" value="0"
                                    <%if(!eventThread.IsPublic) Response.Write("checked=\"checked\""); %> />
                                <label for="isPublic-false">
                                    <%=GetResourceString("Description_PrivateEvent", EventApplicationID)%></label>
                                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Question, GetResourceString("Description_OnlyEventMemberCanSee", EventApplicationID), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
                               
                                <span class="tn-text-note">
                                    设置后不可修改</span> <%} %>
                            </td>
                        </tr>
                        <tr id="showCategory" <%if(!eventThread.IsPublic) Response.Write("style=\"display:none\""); %> >
                            <th>
                                <%=GetResourceString("Label_EventCategory",EventApplicationID)%><%=GetResourceString("Common_Colon") %>
                            </th>
                            <td>
                                <% Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(ApplicationIDs.Instance().Event(), EventConfiguration.Instance().SiteCategoryLevel - 1, "siteCategoryID", eventThread.SiteCategoryID, "tn-dropdownlist"));%>
                                <span class="tn-form-required">
                                    <%=GetResourceString("Description_Required")%></span>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <%=GetResourceString("Title_Contact",UserApplicationID) %><%=GetResourceString("Common_Colon") %>
                            </th>
                            <td>
                                <%string privateEmail = CurrentUser != null ? CurrentUser.PrivateEmail : string.Empty;
                                  string mobile = CurrentUser != null ? CurrentUser.Mobile : string.Empty;
                                %>
                                <input name="email" type="text" class="tn-textbox tn-input-long  tn-border-gray"
                                    id="email" value="<%= eventThread.EventID > 0 ? eventThread.Email: privateEmail %>" />
                                <input name="telephone" type="text" class="tn-textbox tn-input-medium  tn-border-gray"
                                    id="telephone" value="<%=eventThread.Telephone %>" />
                                <input name="moblie" type="text" class="tn-textbox tn-input-medium  tn-border-gray"
                                    id="moblie" value="<%= eventThread.EventID > 0 ? eventThread.Moblie: mobile %>" />
                            </td>
                        </tr>
                        <tr>
                            <th>
                            </th>
                            <td>
                                <%=SPBHtmlHelper.Instance().SubmitButton("createNewEventButton", eventThread.EventID > 0 ? GetResourceString("Button_Save") : GetResourceString("Button_ReleaseNewEvent",EventApplicationID),ButtonSizes.Large,null, null)%>
                                <% if (Request.UrlReferrer != null)
                                   {%>
                                <%=SPBHtmlHelper.Instance().CancelButton(Request.UrlReferrer.AbsoluteUri)%>
                                <%} %>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            </form>
        </div>
        <% int descriptionMaxLength = EventConfiguration.Instance().EventDescriptionMaxLength; %>
        
        <script type="text/javascript">
        $(document).ready(function() {
          $("input[name='isPublic']").click(function(){
            if($(this).val()=='0')
            {
                $("#showCategory").hide();
                $("#siteCategoryID").attr("disabled","disabled");
            }
            else
            {
                $("#showCategory").show();
                $("#siteCategoryID").removeAttr("disabled");
             }
        });
        <%if(Model!=null && Model.EventID>0)
  { %>
   $('input[name="isPublic"]').attr("disabled","disabled");
  <%} %>
       $("#location").watermark("<%=GetResourceString("Label_ParticularAddress", EventApplicationID)%>");
         $("#email").watermark("<%=GetResourceString("Label_UserEamilAddress", UserApplicationID)%>");
             $("#telephone").watermark("<%=GetResourceString("Label_PersonUserTel", UserApplicationID)%>");
              $("#moblie").watermark("<%=GetResourceString("Label_PersonUserMobile", UserApplicationID)%>");
        
            $("#EditEventForm").validate({
                rules: {
                    eventName: { required: true, maxBlength: 30 },
                    body: { htmlEditorRequired: true, htmlEditorRange: [1, <%=descriptionMaxLength %>] },
                    <%if(Model!=null && (Model.IsPublic || Model.EventID<=0)){ %>
                    siteCategoryID: { required: true, min: 1 },
                    <%} %>
                    areaCode: { required: true, min: 1 },
                    location: { maxBlength: 128 },
                    email: { required: true, email: true },
                    telephone: {  minBlength: 4, maxBlength: 20 },
                    moblie: { digits: true, minlength: 11, maxlength: 20 }
                },
                messages: {
                    eventName: { required: "<%=GetResourceString("Validate_InputTitle")%>", maxBlength: "<%=GetResourceString("Validate_MaxLengthThird", EventApplicationID)%>" },
                    body: { htmlEditorRequired: "<%=GetResourceString("Validate_InputEventBody", EventApplicationID)%>", htmlEditorRange: "<%=string.Format(GetResourceString("Validate_Pattern_NewsContentMaxLength", EventApplicationID), descriptionMaxLength)%>" },
                    <%if(Model!=null && (Model.IsPublic || Model.EventID<=0)){ %>
                    siteCategoryID: { required: "<%=GetResourceString("Validate_SelectCategory", EventApplicationID)%>", min: "<%=GetResourceString("Validate_SelectCategory", EventApplicationID)%>" },
                    <%} %>
                    areaCode: { required: "<%=GetResourceString("Validate_SelectEventLocalArea", EventApplicationID)%>", min: "<%=GetResourceString("Validate_SelectEventLocalArea", EventApplicationID)%>" },
                    location: { maxBlength: "<%=GetResourceString("Validate_MaxLengthForth", EventApplicationID)%>" },
                    email: { required: "<%=GetResourceString("Validate_PrivateEmailRequired", UserApplicationID)%>", email: "<%=GetResourceString("Validate_PrivateEmailStyle", UserApplicationID)%>" },
                    telephone: { minBlength: "<%=GetResourceString("Validate_LinkTelMinlength", UserApplicationID)%>", maxlength: "<%=GetResourceString("Validate_LinkTelMaxlength", UserApplicationID)%>" },
                    moblie: { digits: "<%=GetResourceString("Validate_LinkTelDigits", UserApplicationID)%>", minlength: "<%=GetResourceString("Validate_MobileMinlength", UserApplicationID)%>", maxlength: "<%=GetResourceString("Validate_MobileMaxlength", UserApplicationID)%>" }
                }
            });
        });
        </script>

    </div>
</div>    
</div>
</asp:content>
