﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<IList<EventPhoto>>" %>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% Html.RenderPartial("Controls/Events/ChannelEventSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server"></asp:content>

<asp:content id="mainContent" contentplaceholderid="mainContent" runat="server">
  <%int EventApplicationID = ApplicationIDs.Instance().Event(); %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-edit-photos">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom"> <span class="tn-helper-right"> <a href="<%=SPBUrlHelper.Action("ListEventPhotos","ChannelEvent",new RouteValueDictionary{{"eventID",Request.QueryString.GetInt("EventID", 0)}}) %>"
              ><%=GetResourceString("Action_AllPhotos",EventApplicationID)%></a> </span>
      <h3 class="tn-helper-reset"> <%=GetResourceString("Title_EditPhotoParticularData",EventApplicationID)%> </h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <% 
                 if (TempData["StatusMessageType"] != null)
                 {
                     StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                     if (messageType == StatusMessageType.Success)
                         Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
                     else
                         Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), false));
                     TempData["StatusMessageType"] = null;
                 }
                 bool hasEditEventPermission = EventPermission.Validate(Request.QueryString.GetInt("EventID", 0), Globals.GetCurrentUser(), PermissionItemKeys.Instance().EditEvent());                      
            %>
      <form id="EditEventPhotosForm" action="<%=SPBUrlHelper.Action("UpdateEventPhotos","ChannelEvent",new RouteValueDictionary{{"eventID",Request.QueryString.GetInt("EventID",0)},{"number",Request.QueryString.GetInt("Number",0)}}) %>"
            method="post">
        <div class="tn-form tn-label-right">
          <ul class="tn-list tn-helper-reset">
            <% foreach (EventPhoto eventPhoto in ViewData.Model)
                   {%>
            <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
              <div class="tn-list-item-area-left"> <img src="<%=SiteUrls.Instance().EventPhotoUrl(eventPhoto.AttachmentID, EventPhotoTypes.Thumbnail) %>"
                            alt="<%=eventPhoto.FriendlyFileName %>" /> <br />
                <%if (hasEditEventPermission)
                      { %>
                <input name="featuredPhoto" type="radio" class="tn-radiobutton" id="featuredPhoto-<%=eventPhoto.AttachmentID %>"
                                value="<%=eventPhoto.AttachmentID %>" />
                <label for="featuredPhoto-<%=eventPhoto.AttachmentID %>"> <%=GetResourceString("Label_SetEventPhoto", EventApplicationID)%></label>
                <%} %>
              </div>
              <div class="tn-list-item-area-main">
                <div class="tn-form-row">
                  <label class="tn-form-label"><%=GetResourceString("Label_Name") %><%=GetResourceString("Common_Colon") %></label>
                  <input name="friendlyFileName<%=eventPhoto.AttachmentID %>" type="text" class="tn-textbox tn-input-long tn-border-gray"
                                value="<%=Formatter.FormatSingleLinePlainTextForEdit(eventPhoto.FriendlyFileName) %>" id="friendlyFileName<%=eventPhoto.AttachmentID %>" />
                </div>
                <div class="tn-form-row tn-textarea-wrap">
                  <label class="tn-form-label"><%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %></label>
                  <textarea name="description<%=eventPhoto.AttachmentID %>" cols="45" rows="5" class="tn-textarea tn-input-long tn-border-gray"
                                id="description<%=eventPhoto.AttachmentID %>"><%=Formatter.FormatMultiLinePlainTextForEdit(eventPhoto.Description,true) %></textarea>
                                <span style="display:none"></span>
                </div>
              </div>
            </li>
            <%} %>
          </ul>
          <div class="tn-form-row tn-form-row-button">
            <%--<label class="tn-form-label"></label>--%>
            <%=SPBHtmlHelper.Instance().SubmitButton("submitButton", GetResourceString("Button_OK"))%> <%=SPBHtmlHelper.Instance().LinkButton("cancel", GetResourceString("Action_ReturnEventPhotoList", EventApplicationID), SPBUrlHelper.Action("ListEventPhotos", "ChannelEvent", new RouteValueDictionary { { "eventID", Request.QueryString.GetInt("EventID", 0) } }), ButtonSizes.Large, HighlightStyles.Default)%> </div>
        </div>
      </form>
    </div>
  </div>
  <script type="text/javascript">
         $(document).ready(function() {
           $("#EditEventPhotosForm").validate({
                   rules: {
                   <%foreach (EventPhoto eventPhoto in ViewData.Model)
                       {  %>
                      friendlyFileName<%=eventPhoto.AttachmentID %>: { required: true, maxBlength: 64 },
                     description<%=eventPhoto.AttachmentID %>: { maxBlength: 1024 },
                     <%} %>                    
                    },
                   messages: {
                   <%foreach (EventPhoto eventPhoto in ViewData.Model)
                       {  %>
                        friendlyFileName<%=eventPhoto.AttachmentID %>: { required: "<%=GetResourceString("Validate_InputPhotoName",EventApplicationID)%>", maxBlength: "<%=GetResourceString("Validate_MaxLengthFirst",EventApplicationID)%>" },
                       description<%=eventPhoto.AttachmentID %>: { maxBlength: "<%=GetResourceString("Validate_PhotoDescriptionMaxLength",EventApplicationID)%>" },
                       <%} %>                    
                   }
            });
         $("#submitButton").click(function() {
            if (!$("#EditEventPhotosForm").valid()) {
                return false;
             }
         });
       });
    </script>
</asp:content>
<asp:content id="sidebarContent" contentplaceholderid="sidebarContent" runat="server">
  <% Html.RenderAction<ChannelEventController>(n => n.Control_EventAction(Request.QueryString.GetInt("EventID", 0)));  %>
</asp:content>
