﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage" %>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% Html.RenderPartial("Controls/Events/ChannelEventSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server"></asp:content>

<asp:content contentplaceholderid="mainContent" runat="server">
  <% 
      int EventApplicationID = ApplicationIDs.Instance().Event();

      EventThread eventThread = ViewData.Get<EventThread>("EventThread", new EventThread());
      bool isCreating = ViewData.GetBool("IsCreating", false);
      bool isManagerOrAdministrator = ViewData.GetBool("IsManagerOrAdministrator", false);
    %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <h3 class="tn-helper-reset"><%=GetResourceString("Title_InviteFriend", ApplicationIDs.Instance().Event())%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <%             if (TempData["StatusMessageType"] != null)
                     {
                         StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                         if (messageType == StatusMessageType.Success)
                             Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
                         else
                             Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), false));
                         TempData["StatusMessageType"] = null;
                     }
            %>
      <form id="InvitateFriendJoinEventForm" name="InvitateFriendJoinEventForm" action="<%=SPBUrlHelper.Action("CreateJoinEventInvitation","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID}}) %>"
                method="post">
        <div class="tn-form-box">
          <table>
            <tbody>
              <tr>
                <th> <%=GetResourceString("Label_ByInviteUser",EventApplicationID)%><%=GetResourceString("Common_Colon") %></th>
                <td><span class="tn-form-row">
                  <% Html.RenderAction<ChannelController>(n => n.Control_FriendSelector("receiverIDs", string.Empty, eventThread.SurplusCount > 0 ? eventThread.SurplusCount : 100)); %>
                  </span></td>
              </tr>
              <tr>
                <th>&nbsp;</th>
                <td><span class="tn-form-row"> <span class="tn-text-note"> 收件人最多允许填写<%=eventThread.SurplusCount > 0 ? eventThread.SurplusCount : 100 %>个人 </span></span></td>
              </tr>
              <tr>
                <th> <%=GetResourceString("Label_Body")%><%=GetResourceString("Common_Colon") %></th>
                <td><span class="tn-form-row tn-textarea-wrap">
                  <textarea name="body" id="body"  class="tn-textarea tn-input-long tn-border-gray" style=" width:345px; height:105px;"><%=TempData.GetString("body",string.Empty) %></textarea>
                  <span style="display:none"></span>
                  </span></td>
              </tr>
              <tr>
                <th>&nbsp;</th>
                <td><span class="tn-form-row"><span class="tn-text-note"> 内容限制300个字以内</span></span></td>
              </tr>
              <tr>
                <th>&nbsp;</th>
                <td><%=SPBHtmlHelper.Instance().SubmitButton("sendEventInvitButton", GetResourceString("Title_NewFriendInvitation", ApplicationIDs.Instance().User()), ButtonSizes.Default, null, null)%> <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Button_EnterEvent", EventApplicationID), SPBUrlHelper.Action("ShowEvent", "ChannelEvent", new RouteValueDictionary { { "eventID", eventThread.EventID } }), ButtonSizes.Default, HighlightStyles.Default)%></td>
              </tr>
            </tbody>
          </table>
        </div>
      </form>
    </div>
  </div>
  <script type="text/javascript">
        $(document).ready(function() {
            $("#InvitateFriendJoinEventForm").validate({
                rules: {
                    body: { required: true, rangelength: [1, 300] }
                },
                messages: {
                    body: { required: "<%=GetResourceString("Validate_InputInviteInfoContent",EventApplicationID)%>", rangelength: "内容最大长度不能超过300字" }
                }
            });

            $("#sendEventInvitButton").click(function() {
                if (!$("#InvitateFriendJoinEventForm").valid()) {
                    return false;
                }
            });
        });
    </script>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
  <% Html.RenderAction<ChannelEventController>(n => n.Control_EventAction(Request.QueryString.GetInt("EventID", 0))); %>
</asp:content>
