﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Event-Home"
</asp:content>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
 <% ViewData["ChannelEventSubMenu"] = ChannelEventSubMenu.Home;
    Html.RenderPartial("Controls/Events/ChannelEventSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="templateContentRegion" contentplaceholderid="templateContentRegion"
    runat="server"></asp:content>
<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server">
<div class="tn-wrapper">
<spb:Script runat="server" ID="qtip" Src="~/Utility/jquery/plugin/jquery.qtip-1.0.0-rc3.js"  SetExpireDays="30" />      
<%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001000000001", new RouteValueDictionary { { "class", "spb-ad-banner" } })%>
<div class="tn-grid-3-13">
                        <div class="tn-unit tn-first">
                            <%int EventApplicationID = ApplicationIDs.Instance().Event();
                              int maxShowDictionaryCount = 5; %>

                        <% List<SiteCategory> siteCategories = ViewData["SiteCategories"] as List<SiteCategory>;
                           if (siteCategories != null)
                           {
                        %>
                        <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-category-nav-col"
                            id="allCategory">
                            <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
                                <h3 class="tn-helper-reset">
                                    <%=GetResourceString("Navigation_Category",EventApplicationID)%></h3>
                            </div>
                            <div class="tn-box-content tn-widget-content tn-corner-bottom">
                                <div class="tn-directory" id="allCategoryList">
                                    <%  int t = 1;
                                        foreach (SiteCategory parentCategory in siteCategories)
                                        {
                                    %>
                                    <div name="moreCategoryItem" <% if(t>=maxShowDictionaryCount) Response.Write("style=\"display:none\""); %>>
                                        <h5 class="tn-directory-path">
                                            <a href="<%=SPBUrlHelper.Action("Search","ChannelEvent",new RouteValueDictionary{{"siteCategoryID",parentCategory.CategoryID}}) %>">
                                                <%=parentCategory.CategoryName%>
                                            </a>
                                        </h5>
                                        <%if (parentCategory.Childs != null && parentCategory.Childs.Count > 0)
                                          { %>
                                        <div class="tn-directory-level">
                                            <% int i = 1;
                                               foreach (SiteCategory category in parentCategory.Childs)
                                               {
                                                   if (i > 5) break; %>
                                            <span class="tn-directory-item"><a href="<%=SPBUrlHelper.Action("Search","ChannelEvent",new RouteValueDictionary{{"siteCategoryID",category.CategoryID}}) %>">
                                                <%=category.CategoryName%></a> <em class="tn-text-note">
                                                   <%=category.CumulateItemCount%></em></span>
                                            <%i++;
                                               } %>
                                            <span class="tn-directory-item"><a href="<%=SPBUrlHelper.Action("Search","ChannelEvent",new RouteValueDictionary{{"siteCategoryID",parentCategory.CategoryID}}) %>">
                                                <%=GetResourceString("Action_More")%></a></span>
                                        </div>
                                        <%} t++;%>
                                    </div>
                                    <%}%>
                                    <br />
                                    <%if (siteCategories.Count >= maxShowDictionaryCount)
                                      {%>
                                    <p class="tn-helper-align-right">
                                        <span class="tn-action tn-action-text-icon-right"><span id="span-morecategory"  class="tn-icon tn-icon-triangle-down">
                                        </span><a id="morecategory" href="javascript:;" class="tn-action-text">
                                            <%=GetResourceString("Action_OpenMoreClass", EventApplicationID)%></a> </span>
                                    </p>
                                    <%} %>
                                </div>
                            </div>
                        </div>
                        <%} %>
                        <%List<EventAreaStatistics> areas = ViewData["Areas"] as List<EventAreaStatistics>;
                          if (areas != null)
                          {
                        %><div class="tn-blank10">
                        </div>
                        <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-category-nav-col">
                            <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
                                <h3 class="tn-helper-reset">
                                    <%=GetResourceString("Navigation_Area",EventApplicationID) %></h3>
                            </div>
                            <div class="tn-box-content tn-widget-content tn-corner-bottom">
                                <div class="tn-directory" id="allAreasList">
                                    <% int t = 1;
                                       foreach (EventAreaStatistics parentArea in areas)
                                       {
                                    %>
                                    <div name="moreAreasItem" <% if(t>=maxShowDictionaryCount) Response.Write("style=\"display:none\""); %>>
                                        <h5 class="tn-directory-path">
                                            <a href="<%=SiteUrls.Instance().ListEventsByAreaCode(parentArea.AreaCode)%>">
                                                <%=parentArea.Name%></a></h5>
                                        <%if (parentArea.Childs != null && parentArea.Childs.Count > 0)
                                          { %>
                                        <div class="tn-directory-level">
                                            <% int i = 1;
                                               foreach (EventAreaStatistics areChild in parentArea.Childs)
                                               {
                                                   if (i > 5) break; %>
                                            <span class="tn-directory-item"><a href="<%=SiteUrls.Instance().ListEventsByAreaCode(areChild.AreaCode)%>">
                                                <%=areChild.Name%></a> <em class="tn-text-note">
                                                    <%=areChild.CumulateTotalCount%></em></span>
                                            <%i++;
                                               } %>
                                            <span class="tn-directory-item"><a id="areaText" href="<%=SiteUrls.Instance().ListEventsByAreaCode(parentArea.AreaCode)%>">
                                                <%=GetResourceString("Action_More")%></a></span>
                                        </div>
                                        <%} t++;%>
                                    </div>
                                    <%}%>
                                    <%if (areas.Count >= maxShowDictionaryCount)
                                      {%>
                                    <p class="tn-helper-align-right">
                                        <span class="tn-action tn-action-text-icon-right"><span id="span-moreAreas" class="tn-icon tn-icon-triangle-down">
                                        </span><a id="moreAreas" href="javascript:;" class="tn-action-text">
                                            <%=GetResourceString("Action_OpenMoreArea", EventApplicationID)%></a> </span>
                                    </p>
                                    <%} %>
                                </div>
                            </div>
                        </div>
                        <%} IList<EventUserData> userDatalist = ViewData["ExperiencePeople"] as IList<EventUserData>;
                          if (userDatalist != null)
                          {%>
                        <div class="tn-blank10">
                        </div>
                        <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-event-expert">
                            <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
                                <h3 class="tn-helper-reset">
                                    <%=GetResourceString("Title_EventPeople", EventApplicationID)%></h3>
                            </div>
                            <div class="tn-box-content tn-widget-content tn-corner-bottom">
                                <ul class="tn-list tn-helper-reset">
                                    <%
                                        foreach (EventUserData userData in userDatalist)
                                        {
                                    %>
                                    <li class="tn-list-item tn-helper-clearfix">
                                        <div class="tn-list-item-area-left">
                                            <div class="tn-avatar">
                                                <a href="<%=SiteUrls.Instance().UserChannelHome(userData.UserID,EventApplicationID) %>">
                                                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(userData.UserID, false, HyperLinkTarget._self, AvatarSizeTypes.Small)%></a>
                                            </div>
                                        </div>
                                        <div class="tn-list-item-area-main">
                                            <div class="tn-list-item-row tn-list-item-heading">
                                                <h5 class="tn-helper-reset">
                                                    <a href="<%=SiteUrls.Instance().UserChannelHome(userData.UserID,EventApplicationID) %>">
                                                        <%=SPBHtmlHelper.Instance().UserDisplayName(userData.UserID) %></a></h5>
                                            </div>
                                            <div class="tn-list-item-row">
                                                <%= GetResourceString("Label_ExperiencePoints")%><%=GetResourceString("Common_Colon")%><%=userData.ExperiencePoints%>
                                            </div>
                                        </div>
                                    </li>
                                    <%}
                                    %>
                                </ul>
                            </div>
                        </div>
                        <%} %>
                            <script type="text/javascript">
                                $(document).ready(function() {
                                    $("#moreAreas").click(function() {
                                        var $moreAreas = $('#allAreasList > div[name="moreAreasItem"]:gt(<%=maxShowDictionaryCount-2 %>)');
                                        $moreAreas.toggle();
                                        if ($moreAreas.is(":visible")) {
                                            $(this).text('<%=GetResourceString("Action_EasyArea", EventApplicationID)%>');
                                            $("#span-moreAreas").attr({ className: "tn-icon tn-icon-triangle-up" });
                                        }
                                        else {
                                            $(this).text('<%=GetResourceString("Action_OpenMoreArea", EventApplicationID)%>');
                                            $("#span-moreAreas").attr({ className: "tn-icon tn-icon-triangle-down" });
                                        };
                                    });

                                    $("#morecategory").click(function() {
                                        var $moreCategories = $('#allCategoryList > div[name="moreCategoryItem"]:gt(<%=maxShowDictionaryCount-2 %>)');
                                        $moreCategories.toggle();
                                        if ($moreCategories.is(":visible")) {
                                            $(this).text('<%=GetResourceString("Action_EasyClass", EventApplicationID)%>');
                                            $("#span-morecategory").attr({ className: "tn-icon tn-icon-triangle-up" });
                                        }
                                        else {
                                            $(this).text('<%=GetResourceString("Action_OpenMoreClass", EventApplicationID)%>');
                                            $("#span-morecategory").attr({ className: "tn-icon tn-icon-triangle-down" });
                                        };
                                    });
                                });
    </script>
                        </div>
                        <div class="tn-grid-9-4">
                            <div class="tn-unit tn-first">
                            <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001002210001", new RouteValueDictionary { { "class", "spb-ad-column" } })%>                                

                         <%-- 推荐活动--%>
                            <% Html.RenderAction("Control_RecommendEventBlock", "ChannelEvent", new RouteValueDictionary { { "commendTypeID", 221001 }, { "displayCount", 4 }, { "hasBorder", true } }); %>

                            <%-- 最新活动 --%>
                            <% Html.RenderAction<ChannelEventController>(n => n.Control_ListOrSummaryEventsBlock(EventThreadSortBy.LastModified, GetResourceString("Title_NewEvent", ApplicationIDs.Instance().Event()), "ListEventsBlockForMain",EventStatuses.Published,string.Empty,null,null,4)); %>
                           
                           
                            <%-- 热点活动 --%>
                              <% Html.RenderAction<ChannelEventController>(n => n.Control_ListOrSummaryEventsBlock(EventThreadSortBy.HitTimes, GetResourceString("Title_HotEvent", ApplicationIDs.Instance().Event()), "ListEventsBlockForMain",EventStatuses.Published, null, null, null, 4)); %>
                           
                            <%--精彩回顾--%>
                            <% Html.RenderAction("Control_RecommendEventBlock", "ChannelEvent", new RouteValueDictionary { { "commendTypeID", 221002 }, { "displayCount", 4 }, { "hasBorder", true } }); %>
                            <%--活动照片--%>
                            <div id="RandomPhotosDiv">
                                <% Html.RenderAction<ChannelEventController>(n => n.Control_RandomPhotos(12)); %>
                            </div>
                     
                            </div>
                            <div class="tn-unit">
                                <%--精品活动 --%>
                            <% Html.RenderAction<ChannelEventController>(n => n.Control_ListOrSummaryEventsBlock(null, GetResourceString("Title_EssentialEvent", ApplicationIDs.Instance().Event()), "ListEventsBlockForSidebar", EventStatuses.Published, null, null, true, 10)); %>
                                         
                            <%--同城活动--%>
                            <% if (CurrentUser != null)
                               {
                                   PersonUser pu = CurrentUser as PersonUser;
                                   if (pu != null && !string.IsNullOrEmpty(pu.NowAreaCode))
                                   {
                                       Html.RenderAction<ChannelEventController>(n => n.Control_ListOrSummaryEventsBlock(null, GetResourceString("Title_SameCityEvent", ApplicationIDs.Instance().Event()), "ListEventsBlockForSidebar", EventStatuses.Published, pu != null ? pu.NowAreaCode : string.Empty, null, null, 10));
                                   }
                               }%>                         
                            
                            <%-- 关注排行 --%>
                            <% Html.RenderAction<ChannelEventController>(n => n.Control_ListOrSummaryEventsBlock(EventThreadSortBy.FaviteCount, GetResourceString("Title_FaviteCount", ApplicationIDs.Instance().Event()), "ListEventsBlockForSidebar", EventStatuses.Published, null, null, null, 10)); %>
                            <%-- 过往活动 --%>
                            <% Html.RenderAction<ChannelEventController>(n => n.Control_ListOrSummaryEventsBlock(EventThreadSortBy.StartTime, GetResourceString("Title_StartTime", ApplicationIDs.Instance().Event()), "ListEventsBlockForSidebar", EventStatuses.Finished, null, null, null, 10)); %>


                            </div>
                        </div>
                    </div>
                    <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001000000002", new RouteValueDictionary { { "class", "spb-ad-banner-bottom" } })%>
              </div>
</asp:content>
