﻿<%@ Page Title="" Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<PagingDataSet<EventThread>>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["ChannelEventSubMenu"] = ChannelEventSubMenu.Review;%>
  <% Html.RenderPartial("Controls/Events/ChannelEventSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
  id="Event-ListEventreview"
</asp:content>
<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server"></asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
<% int EventApplicationID = ApplicationIDs.Instance().Event();

    if (Model != null && Model.TotalRecords > 0)
  { %>

<ul class="tn-list tn-helper-reset spb-events-list">
<%foreach (EventThread thread in Model.Records)
  { %>
   <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                <div class="tn-list-item-area-left"> <%=SPBHtmlHelper.Instance().ShowEventLogo(thread,true,"_self", EventPhotoTypes.Thumbnail) %></div>
                <div class="tn-list-item-area-main">
                  <div class="tn-list-item-row tn-list-item-heading">
                    <h5 class="tn-helper-reset"> <a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("ShowEvent","ChannelEvent",new RouteValueDictionary{{"eventID",thread.EventID}})) %>"> <%=thread.EventName%></a>
                      <%
                             if (thread.EventSiteCategory != null)
                             {
                        %>
                      <cite class="tn-category">【<a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("Search", "ChannelEvent", new RouteValueDictionary { { "siteCategoryID", thread.SiteCategoryID } }))%>"
                                        title="<%=string.Format(GetResourceString("Description_Pattern_CheckAllEvent", EventApplicationID), thread.EventSiteCategory.GetMultilingualCategoryName(CurrentUserLanguage)) %>"><%=thread.EventSiteCategory.GetMultilingualCategoryName(CurrentUserLanguage)%></a>】 </cite>
                      <%if (thread.IsEssential)
                        {
                            Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Elite, string.Empty, new RouteValueDictionary { { "class", "tn-icon-inline" } }));

                        }%>
                      <%}
                         %>
                    </h5>
                  </div>
                  <div class="tn-list-item-row">
                    <div class="tn-info-part">
                      <dl>
                        <dt class="tn-text-note"><%=GetResourceString("Label_EventTime", EventApplicationID)%><%=GetResourceString("Common_Colon") %></dt>
                        <dd><span class="tn-date"> <%=EventDateFormatter.FormatDate(thread.StartTime,thread.EndTime,true)%> </span></dd>
                      </dl>
                      <% if (!string.IsNullOrEmpty(thread.AreaCode))
                         { %>
                      <dl>
                        <dt class="tn-text-note"><%=GetResourceString("Label_LocalArea", EventApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
                        <dd><a class="tn-location" href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("Search","ChannelEvent",new RouteValueDictionary{{"areaCode",thread.AreaCode}})) %>"
                                title="<%=string.Format(GetResourceString("Description_Pattern_CheckAllEvent", EventApplicationID), Formatter.FormatArea(thread.AreaCode,true)) %>"><%=Formatter.FormatArea(thread.AreaCode, true)%></a></dd>
                      </dl>
                      <%} %>
                      <dl>
                        <dt class="tn-text-note"><%=GetResourceString("Label_ReleaseUser",EventApplicationID)%><%=GetResourceString("Common_Colon") %></dt>
                        <dd><a class="tn-user-name" target="_blank" href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().UserDomainHome(thread.UserID)) %>"
                                title="<%=string.Format(GetResourceString("Description_Pattern_ViewUserDomain"), thread.Sponsor) %>"><%=thread.Sponsor %></a></dd>
                      </dl>
                    </div>
                  </div>
                  <div class="tn-list-item-row"> <span class="tn-action"><span class="tn-action-text"><%=thread.HitTimes%><%=GetResourceString("Label_Scan",EventApplicationID)%></span> </span> <span class="tn-action"><span class="tn-action-text"><%=thread.MemberCount%><%=GetResourceString("Label_Attend", ApplicationIDs.Instance().Event())%></span> </span> <span class="tn-action"><span class="tn-action-text"><%=thread.FaviteCount%><%=GetResourceString("Label_Attention",EventApplicationID) %></span> </span> <span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("ListEventPhotos", "ChannelEvent", new RouteValueDictionary { { "eventID", thread.EventID } })%>"><%=thread.PhotoCount%><%=GetResourceString("Label_Photos", EventApplicationID)%></a> </span> <span class="tn-action"><a class="tn-action-text" href="<%=SiteUrls.Instance().ShowEvent(thread.EventID) %>#comments"><%=thread.PostCount%><%=GetResourceString("Label_Messages", EventApplicationID)%></a> </span> </div>
                </div>
              </li>
    <%} %>
</ul>
 <div class="tn-pagination tn-helper-align-center"> <%= SPBHtmlHelper.Instance().PagingButton( PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex)%> </div>
<%} %>
</div>
</div>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
  <% Html.RenderAction<ChannelEventController>(n => n.Control_ListOrSummaryEventsBlock(EventThreadSortBy.PostCount, "热评活动", "ListEventsBlockForSidebar", EventStatuses.Published, string.Empty, null, null, 10)); %>
  <% Html.RenderAction<ChannelEventController>(n => n.Control_ListOrSummaryEventsBlock(EventThreadSortBy.LastModified, GetResourceString("Title_NewEvent", ApplicationIDs.Instance().Event()), "ListEventsBlockForSidebar", EventStatuses.Published, null, null, null, 10)); %>
</asp:content>
