﻿<%@ Page Title="" Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<PagingDataSet<EventThread>>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["ChannelEventSubMenu"] = ChannelEventSubMenu.Search;%>
  <% Html.RenderPartial("Controls/Events/ChannelEventSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server"></asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
  <%
      int EventApplicationID = ApplicationIDs.Instance().Event();
      EventThreadFullQuery query = ViewData.Get<EventThreadFullQuery>("Query", new EventThreadFullQuery());

      Stack<SiteCategory> categoryStack = ViewData.Get<Stack<SiteCategory>>("categoryStack", new Stack<SiteCategory>());
      Stack<EventAreaStatistics> areaStack = ViewData.Get<Stack<EventAreaStatistics>>("areaStack", new Stack<EventAreaStatistics>());
      List<EventAreaStatistics> areas = ViewData.Get<List<EventAreaStatistics>>("areas", null);
      List<SiteCategory> siteCategoties = ViewData.Get<List<SiteCategory>>("siteCategoties", null);
      string CurrentCategoryName = ViewData.GetString("CurrentCategoryName", string.Empty);
      string CurrentAreaName = ViewData.Get("CurrentAreaName", string.Empty);
      int maxShowDictionaryCount = 12;
      RouteValueDictionary defaultRouteDictionary = new RouteValueDictionary { { "sortBy", query.SortBy }, { "siteCategoryID", query.SiteCategoryID }, { "areaCode", query.AreaCode }, { "dateScope", query.DateScope }, { "isEssential", query.IsEssential }, { "isClubEvent", query.IsClubEvent }, { "status", query.Status }, { "Keyword", Html.GetParameterFromRouteDateOrQueryString("Keyword") } };
      int siteCategoryDepth = EventConfiguration.Instance().SiteCategoryLevel - 1;
      
    %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-events-search">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <div class="tn-directory">
            <h5 class="tn-directory-path">
                <a href="<%=SPBUrlHelper.Action("Search", "ChannelEvent", new RouteValueDictionary { { "areaCode", query.AreaCode } })%>">
                    <%=GetResourceString("Title_AlllCategory",EventApplicationID)%></a>
                <%
              SiteCategory category = null;
              while (categoryStack.Count > 0)
              {
                  category = categoryStack.Pop();
                  Response.Write(string.Format("&gt;<a href=\"{1}\">{0}</a>", category.GetMultilingualCategoryName(CurrentUserLanguage), SPBUrlHelper.Action("Search", "ChannelEvent", new RouteValueDictionary { { "siteCategoryID", category.CategoryID }, { "areaCode", query.AreaCode } })));
              } %>
            </h5>
            <div class="tn-directory-level tn-border-gray tn-border-bottom" id="allSiteCategoryList">
                <%
              if (siteCategoties != null)
              {
                %>
                <span class="tn-directory-item <%if((category!=null&& query.SiteCategoryID ==category.CategoryID)||(category == null&&query.SiteCategoryID<=0)) Response.Write(" tn-text-note tn-selected"); %>">
                    <a href="<%=SPBUrlHelper.Action("Search","ChannelEvent",new RouteValueDictionary {{"siteCategoryID",category!=null?category.CategoryID:-1 },{"areaCode",query.AreaCode}}) %>">
                        <%=GetResourceString("Enum_Genders_All")%></a></span><% 
                                                                                                                                                                                                                                                                                                                                                                                                                                                   int iIndex = 1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                   foreach (SiteCategory siteCategory in siteCategoties)
                                                                                                                                                                                                                                                                                                                                                                                                                                                   {
                        %><span class="tn-directory-item <%if(query.SiteCategoryID ==siteCategory.CategoryID) Response.Write(" tn-text-note tn-selected"); %>"
                            <% if(iIndex>=maxShowDictionaryCount) Response.Write("style=\"display:none\""); %>>
                            <a href="<%=SPBUrlHelper.Action("Search", "ChannelEvent", new RouteValueDictionary { { "siteCategoryID", siteCategory.CategoryID }, { "areaCode", query.AreaCode } }) %>">
                                <%=siteCategory.GetMultilingualCategoryName(CurrentUserLanguage) %></a><em class="tn-text-note"><%=siteCategory.CumulateItemCount %></em></span><%
iIndex++;
                                                                                                                                                                                                                                                                                                                                                                                                                                                   }
                                                                                                                                                                                                                                                                                                                                                                                                                                                   if (siteCategoties.Count > maxShowDictionaryCount)
                                                                                                                                                                                                                                                                                                                                                                                                                                                   {
                                %><span class="tn-action tn-action-text-icon-right"><span id="span-morecategory"
                                    class="tn-icon tn-icon-triangle-down"></span> <a id="morecategory" href="javascript:;"
                                        class="tn-action-text">
                                        <%=GetResourceString("Action_OpenMoreClass", EventApplicationID)%></a>
                </span>
                <%}
              }%>
            </div>
            <h5 class="tn-directory-path">
                <a href="<%=SPBUrlHelper.Action("Search", "ChannelEvent", new RouteValueDictionary { {"siteCategoryID",query.SiteCategoryID}})%>">
                    <%=GetResourceString("Title_Alllarea",EventApplicationID)%></a>
                <%
              EventAreaStatistics area = null;
              while (areaStack.Count > 0)
              {
                  area = areaStack.Pop();
                  Response.Write(string.Format("&gt;<a href=\"{1}\">{0}</a>", area.GetMultilingualAreaName(CurrentUserLanguage), SPBUrlHelper.Action("Search", "ChannelEvent", new RouteValueDictionary { { "siteCategoryID", query.SiteCategoryID }, { "areaCode", area.AreaCode } })));
              }
                %>
            </h5>
            <div id="areasList" class="tn-directory-level tn-border-gray tn-border-bottom">
                <span class="tn-directory-item <%if(area==null || (area!=null&&area.AreaCode==query.AreaCode)) Response.Write(" tn-text-note tn-selected"); %>">
                    <a href="<%=SPBUrlHelper.Action("Search","ChannelEvent",new RouteValueDictionary {{"siteCategoryID",query.SiteCategoryID},{"areaCode",area!=null?area.AreaCode:string.Empty}}) %>">
                        <%=GetResourceString("Enum_Genders_All") %></a></span>
                <%  
              if (areas != null)
              {
                  int iIndex = 1;
                  foreach (EventAreaStatistics eventArea in areas)
                  { %><span class="tn-directory-item <%if(query.AreaCode == eventArea.AreaCode) Response.Write("tn-text-note tn-selected"); %>"
                      <% if(iIndex>=maxShowDictionaryCount) Response.Write("style=\"display:none\""); %>><a
                          href="<%=SPBUrlHelper.Action("Search", "ChannelEvent", new RouteValueDictionary { { "siteCategoryID", query.SiteCategoryID }, { "areaCode", eventArea.AreaCode }, { "Keyword", Html.GetParameterFromRouteDateOrQueryString("Keyword") } }) %>"><%=eventArea.GetMultilingualAreaName(CurrentUserLanguage)%></a>
                      <em class="tn-text-note">
                          <%=eventArea.CumulateTotalCount%></em></span><%  
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         iIndex++;
                  }
                  if (areas.Count > maxShowDictionaryCount)
                  { %><span class="tn-action tn-action-text-icon-right"><span id="span-moreAreas" class="tn-icon tn-icon-triangle-down"></span>
                      <a id="moreAreas" href="javascript:;" class="tn-action-text">
                          <%=GetResourceString("Action_OpenMoreArea", EventApplicationID)%></a>
                </span>
                <%}
              }%>
            </div>
            <div class="tn-directory-search tn-border-gray tn-border-bottom tn-helper-clearfix">
                <div class="tn-search-box tn-helper-clearfix">
                    <form method="post" id="searchForm" action="<%=SPBUrlHelper.Action("Search", "ChannelEvent", new RouteValueDictionary { { "siteCategoryID", query.SiteCategoryID }, { "areaCode", query.AreaCode } })%>">
                    <input name="keyword" id="eventNameFilter" type="text" class="tn-search-input tn-input-medium tn-border-gray tn-border-tbl"
                        value="<% =query.EventNameFilter %>" />
                    <span class="tn-search-button tn-search-ico-button tn-border-gray tn-bg-gray">
                        <button type="submit"  onclick="$('#searchForm').submit();">
                            <span class="tn-icon tn-icon-find"></span>
                        </button>
                    </span>
                    </form>
                </div>
                <div class="tn-directory-selected">
                    <%if (query.SiteCategoryID > 0)
              { %>
                    <span class="tn-directory-selected-item tn-border-gray tn-bg-gray"><a class="tn-icon tn-icon-cross"
                        href="<%=SPBUrlHelper.Action("Search", "ChannelEvent", new RouteValueDictionary { { "areaCode", query.AreaCode }, { "Keyword", query.EventNameFilter } })%>">
                    </a>
                        <%=CurrentCategoryName%></span>
                    <%} if (!string.IsNullOrEmpty(query.AreaCode))
              { %>
                    <span class="tn-directory-selected-item tn-border-gray tn-bg-gray"><a class="tn-icon tn-icon-cross"
                        href="<%=SPBUrlHelper.Action("Search", "ChannelEvent", new RouteValueDictionary { { "siteCategoryID", query.SiteCategoryID},{ "Keyword", query.EventNameFilter } })%>">
                    </a>
                        <%=CurrentAreaName %></span>
                    <%} if (!string.IsNullOrEmpty(query.EventNameFilter))
              { %>
                    <span class="tn-directory-selected-item tn-border-gray tn-bg-gray"><a class="tn-icon tn-icon-cross"
                        href="<%=SPBUrlHelper.Action("Search", "ChannelEvent", new RouteValueDictionary { { "siteCategoryID", query.SiteCategoryID},{ "areaCode", query.AreaCode } })%>">
                    </a>
                        <%=query.EventNameFilter %></span>
                    <%} %>
                    <%--<span class="tn-directory-selected-item tn-border-gray tn-bg-gray">
                    <a class="tn-icon tn-icon-cross" href="<%=SPBUrlHelper.Action("AdvancedSearch", "ChannelEvent", new RouteValueDictionary { { "siteCategoryID", query.SiteCategoryID},{ "areaCode", areaCode}, { "Keyword", Keyword }  })%>"></a>
                    <%switch (payType)
                      {
                          case 0:
                              Response.Write("免费");
                              break;
                          case 1:
                              Response.Write("AA制");
                              break;
                          case 2:
                              Response.Write("固定收费");
                              break;
                      }  %>
                   </span>--%>
                </div>
            </div>
        </div>
        <% 
          RouteValueDictionary EventStatusScopeDictionary = new RouteValueDictionary(defaultRouteDictionary);
          EventStatusScopeDictionary["status"] = EventStatuses.Published; %>
        <div class="tn-directory-result">
            <div class="tn-tabs tn-widget" id="ListEvents">
                <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
                    <%EventStatusScopeDictionary["dateScope"] = null;  %>
                    <li class="tn-widget-content tn-border-gray tn-border-trl <% if (!query.DateScope.HasValue && (query.Status==EventStatuses.Published || !query.Status.HasValue)) Response.Write("tn-tabs-selected"); %>">
                        <a href="<%=SPBUrlHelper.Action("SecondarySearch","ChannelEvent",EventStatusScopeDictionary) %>">
                            <span>
                                <%=GetResourceString("Enum_NewEvent", EventApplicationID)%></span></a></li>
                    <%EventStatusScopeDictionary["dateScope"] = EventDateScopes.Weekend;  %>
                    <li class="tn-widget-content tn-border-gray tn-border-trl <% if (query.DateScope.HasValue && query.DateScope.Value==EventDateScopes.Weekend) Response.Write("tn-tabs-selected"); %>">
                        <a href="<%=SPBUrlHelper.Action("SecondarySearch","ChannelEvent",EventStatusScopeDictionary) %>">
                            <span>
                                <%=GetResourceString("Enum_Weekend", EventApplicationID)%></span></a></li>
                    <%EventStatusScopeDictionary["dateScope"] = EventDateScopes.NextWeek;  %>
                    <li class="tn-widget-content tn-border-gray tn-border-trl <% if (query.DateScope.HasValue && query.DateScope.Value==EventDateScopes.NextWeek) Response.Write("tn-tabs-selected"); %>">
                        <a href="<%=SPBUrlHelper.Action("SecondarySearch","ChannelEvent",EventStatusScopeDictionary) %>">
                            <span>
                                <%=GetResourceString("Enum_LatelyWeek",EventApplicationID)%></span></a></li>
                    <%EventStatusScopeDictionary["dateScope"] = EventDateScopes.Nextmonth;  %>
                    <li class="tn-widget-content tn-border-gray tn-border-trl <% if (query.DateScope.HasValue && query.DateScope.Value==EventDateScopes.Nextmonth) Response.Write("tn-tabs-selected"); %>">
                        <a href="<%=SPBUrlHelper.Action("SecondarySearch","ChannelEvent",EventStatusScopeDictionary) %>">
                            <span>
                                <%=GetResourceString("Enum_LatelyMonth", EventApplicationID)%></span></a></li>
                    <%EventStatusScopeDictionary["dateScope"] = null;
              EventStatusScopeDictionary["status"] = EventStatuses.Finished;
                    %>
                    <li class="tn-widget-content tn-border-gray tn-border-trl <% if (query.Status==EventStatuses.Finished) Response.Write("tn-tabs-selected"); %>">
                        <a href="<%=SPBUrlHelper.Action("SecondarySearch","ChannelEvent",EventStatusScopeDictionary) %>">
                            <span>
                                <%=GetResourceString("Title_StartTime",EventApplicationID)%></span></a></li>
                </ul>
                <div class="tn-tabs-panel tn-widget-content tn-border-gray tn-border-top">
                    <div class="tn-list-header">
                        <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom tn-helper-align-right">
                            <span>
                                <input type="checkbox" class="tn-checkbox" id="isEssential" name="isEssential" value="true"
                                    <% if (query.IsEssential.HasValue && query.IsEssential.Value) Response.Write("checked='checked'"); %> />
                                <label for="isEssential">
                                    <%=GetResourceString("Action_EssentialEvent",EventApplicationID)%></label>
                            </span>
                            <select id="sortbyselect" class="tn-dropdownlist">
                                <option <% if(query.SortBy==EventThreadSortBy.StartTime) Response.Write("selected=\"selected\""); %>
                                    value="<%=EventThreadSortBy.StartTime%>">
                                    <%=GetResourceString("Label_StartTime", EventApplicationID)%></option>
                                <option <% if(query.SortBy==EventThreadSortBy.MemberCount) Response.Write("selected=\"selected\""); %>
                                    value="<%=EventThreadSortBy.MemberCount%>">
                                    <%=GetResourceString("Label_MemberCount", EventApplicationID)%></option>
                                <option <% if(query.SortBy==EventThreadSortBy.FaviteCount) Response.Write("selected=\"selected\""); %>
                                    value="<%=EventThreadSortBy.FaviteCount%>">
                                    <%=GetResourceString("Label_FaviteCount", EventApplicationID)%></option>
                                <option <% if(query.SortBy==EventThreadSortBy.PostCount) Response.Write("selected=\"selected\""); %>
                                    value="<%=EventThreadSortBy.PostCount%>">
                                    <%=GetResourceString("Label_LeaveMessageCount", EventApplicationID)%></option>
                                <option <% if(query.SortBy==EventThreadSortBy.HitTimes) Response.Write("selected=\"selected\""); %>
                                    value="<%=EventThreadSortBy.HitTimes%>">
                                    <%=GetResourceString("Label_BrowseCount")%></option>
                                <option <% if(query.SortBy==EventThreadSortBy.PhotoCount) Response.Write("selected=\"selected\""); %>
                                    value="<%=EventThreadSortBy.PhotoCount%>">
                                    <%=GetResourceString("Label_PhotoCount", EventApplicationID)%></option>
                                <option <% if(query.SortBy==EventThreadSortBy.LastModified) Response.Write("selected=\"selected\""); %>
                                    value="<%=EventThreadSortBy.LastModified%>">
                                    <%=GetResourceString("Label_EndAmendTime", EventApplicationID)%></option>
                            </select>
                        </div>
                    </div>
                    <% if (ViewData.Model != null)
               {
                   if (ViewData.Model.TotalRecords == 0)
                   {
                       Html.RenderPartial("Controls/Search/NoSearchResult.ascx");
                   }
                   else
                   { %>
                    <ul class="tn-list tn-helper-reset spb-events-list">
                        <% foreach (EventThread thread in ViewData.Model.Records)
                 {
                        %>
                        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                            <div class="tn-list-item-area-left">
                                <%=SPBHtmlHelper.Instance().ShowEventLogo(thread,true,"_self", EventPhotoTypes.Thumbnail) %></div>
                            <div class="tn-list-item-area-main">
                                <div class="tn-list-item-row tn-list-item-heading">
                                    <h5 class="tn-helper-reset">
                                        <a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("ShowEvent","ChannelEvent",new RouteValueDictionary{{"eventID",thread.EventID}})) %>">
                                            <%=thread.EventName%></a>
                                        <% if (query.SiteCategoryID <= 0)
                         {
                             if (thread.EventSiteCategory != null)
                             {
                                        %>
                                        <cite class="tn-category">【<a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("Search", "ChannelEvent", new RouteValueDictionary { { "siteCategoryID", thread.SiteCategoryID } }))%>"
                                            title="<%=string.Format(GetResourceString("Description_Pattern_CheckAllEvent", EventApplicationID), thread.EventSiteCategory.GetMultilingualCategoryName(CurrentUserLanguage)) %>"><%=thread.EventSiteCategory.GetMultilingualCategoryName(CurrentUserLanguage)%></a>】
                                        </cite>
                                        <%if (thread.IsEssential)
                        {
                            Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Elite, string.Empty, new RouteValueDictionary { { "class", "tn-icon-inline" } }));

                        }%>
                                        <%}
                         } %>
                                    </h5>
                                </div>
                                <div class="tn-list-item-row">
                                    <div class="tn-info-part">
                                        <dl>
                                            <dt class="tn-text-note">
                                                <%=GetResourceString("Label_EventTime", EventApplicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <span class="tn-date">
                                                    <%=EventDateFormatter.FormatDate(thread.StartTime,thread.EndTime,true)%>
                                                </span>
                                            </dd>
                                        </dl>
                                        <% if (!string.IsNullOrEmpty(thread.AreaCode))
                         { %>
                                        <dl>
                                            <dt class="tn-text-note">
                                                <%=GetResourceString("Label_LocalArea", EventApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
                                            <dd>
                                                <a class="tn-location" href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("Search","ChannelEvent",new RouteValueDictionary{{"areaCode",thread.AreaCode}})) %>"
                                                    title="<%=string.Format(GetResourceString("Description_Pattern_CheckAllEvent", EventApplicationID), Formatter.FormatArea(thread.AreaCode,true)) %>">
                                                    <%=Formatter.FormatArea(thread.AreaCode, true)%></a></dd>
                                        </dl>
                                        <%} %>
                                        <dl>
                                            <dt class="tn-text-note">
                                                <%=GetResourceString("Label_ReleaseUser",EventApplicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <a class="tn-user-name" target="_blank" href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().UserDomainHome(thread.UserID)) %>"
                                                    title="<%=string.Format(GetResourceString("Description_Pattern_ViewUserDomain"), thread.Sponsor) %>">
                                                    <%=thread.Sponsor %></a></dd>
                                        </dl>
                                    </div>
                                </div>
                                <div class="tn-list-item-row">
                                    <span class="tn-action"><span class="tn-action-text">
                                        <%=thread.HitTimes%><%=GetResourceString("Label_Scan",EventApplicationID)%></span>
                                    </span><span class="tn-action"><span class="tn-action-text">
                                        <%=thread.MemberCount%><%=GetResourceString("Label_Attend", ApplicationIDs.Instance().Event())%></span>
                                    </span><span class="tn-action"><span class="tn-action-text">
                                        <%=thread.FaviteCount%><%=GetResourceString("Label_Attention",EventApplicationID) %></span>
                                    </span><span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("ListEventPhotos", "ChannelEvent", new RouteValueDictionary { { "eventID", thread.EventID } })%>">
                                        <%=thread.PhotoCount%><%=GetResourceString("Label_Photos", EventApplicationID)%></a>
                                    </span><span class="tn-action"><a class="tn-action-text" href="<%=SiteUrls.Instance().ShowEvent(thread.EventID) %>#comments">
                                        <%=thread.PostCount%><%=GetResourceString("Label_Messages", EventApplicationID)%></a>
                                    </span>
                                </div>
                            </div>
                        </li>
                        <%} %>
                    </ul>
                    <%}
               }%>
                    <div class="tn-pagination tn-helper-align-center">
                        <%= SPBHtmlHelper.Instance().PagingButton( PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex)%>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<%
      RouteValueDictionary isEssentialDictionary = new RouteValueDictionary(defaultRouteDictionary);
      isEssentialDictionary.Remove("isEssential");
      RouteValueDictionary sortByDictionary = new RouteValueDictionary(defaultRouteDictionary);
      sortByDictionary.Remove("sortBy"); 
%>

<script type="text/javascript">
    $(document).ready(function() {
        $("#isEssential").click(function() {
            var isEssential = null;
            if (this.checked) isEssential = true;
            window.location.href = '<%=SPBUrlHelper.Action("SecondarySearch","ChannelEvent",isEssentialDictionary) %>&isEssential=' + isEssential;
        });
        $("#sortbyselect").change(function() {
            window.location.href = '<%=SPBUrlHelper.Action("SecondarySearch", "ChannelEvent",sortByDictionary)%>&sortBy=' + $("#sortbyselect").val();
        });

        $("#moreAreas").click(function() {
            var $moreAreas = $('#areasList span:not(.tn-action):gt(<%=maxShowDictionaryCount-1 %>)')
            $moreAreas.toggle();
            if ($moreAreas.is(":visible")) {
                $(this).text('<%=GetResourceString("Action_EasyArea", EventApplicationID)%>');
                $("#span-moreAreas").attr({ className: "tn-icon tn-icon-triangle-up", style: "display:block" });
            }
            else {
                $(this).text('<%=GetResourceString("Action_OpenMoreArea", EventApplicationID)%>');
                $("#span-moreAreas").attr({ className: "tn-icon tn-icon-triangle-down", style: "display:block" });
            };
        });

        $("#morecategory").click(function() {
            var $moreCategories = $('#allSiteCategoryList span:not(.tn-action):gt(<%=maxShowDictionaryCount-1 %>)');
            $moreCategories.toggle();
            if ($moreCategories.is(":visible")) {
                $(this).text('<%=GetResourceString("Action_EasyClass", EventApplicationID)%>');
                $("#span-morecategory").attr({ className: "tn-icon tn-icon-triangle-up", style: "display:block" });
            }
            else {
                $(this).text('<%=GetResourceString("Action_OpenMoreClass", EventApplicationID)%>');
                $("#span-morecategory").attr({ className: "tn-icon tn-icon-triangle-down", style: "display:block" });
            };
        });



    });
</script>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
  <% Html.RenderAction<ChannelEventController>(n => n.Control_ListOrSummaryEventsBlock(EventThreadSortBy.HitTimes, GetResourceString("Title_HotEvent", ApplicationIDs.Instance().Event()), "ListEventsBlockForSidebar", EventStatuses.Published, null, null, null, 10)); %>
  <% Html.RenderAction<ChannelEventController>(n => n.Control_ListOrSummaryEventsBlock(EventThreadSortBy.LastModified, GetResourceString("Title_NewEvent", ApplicationIDs.Instance().Event()), "ListEventsBlockForSidebar", EventStatuses.Published, null, null, null, 10)); %>
</asp:content>


