﻿<%@ Page Title="" Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<EventThread>" %>

<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server"></asp:content>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% Html.RenderPartial("Controls/Events/ChannelEventSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
  <spb:Script ID="form" runat="server" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
        SetExpireDays="30"> </spb:Script>
  <spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js" SetExpireDays="30" />
  <% 
      int EventApplicationID = ApplicationIDs.Instance().Event();
      int UserApplicationID = ApplicationIDs.Instance().User();
      StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", null);
      if (statusMessageData != null)
      {
          if (statusMessageData.MessageType == StatusMessageType.Success)
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData, 3000, false));
          else
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
          statusMessageData = null;
      }
      EventThread eventThread = ViewData.Model;
      string body = ViewData.GetString("body", string.Empty);
      bool IsFavorited = ViewData.GetBool("IsFavorited", false);
      EventMember eventMember = ViewData.Get<EventMember>("eventMember", null);
      bool hasManagePermission = (CurrentUser != null && CurrentUser.IsAdministrator) || (CurrentUser != null && CurrentUser.IsContentAdministrator) || (CurrentUser != null && CurrentUser.UserID == Model.UserID);
      bool errorAuditingStatus = ViewData.GetBool("errorAuditingStatus", false);

      if (errorAuditingStatus)
      {
          string errorMessage = ViewData.GetString("errorMessage", string.Empty);%>
  <div class="tn-cue-highlight tn-corner-all tn-message-box"> <span class="tn-helper-left"> <span class="tn-icon tn-icon-exclamation"></span></span>
    <% Response.Write(errorMessage); %>
    <%
          if ((CurrentUser != null && CurrentUser.IsAdministrator) || (CurrentUser != null && CurrentUser.IsContentAdministrator))
          {%>
    <%  int threadid = Model.EventID; %>
    <%=GetResourceString("Description_IsAdministrator", EventApplicationID) %> <a title="<%=GetResourceString("Description_CurrentEventPassAuditing", EventApplicationID) %>" id="SetIsPassButton" href="<%=SPBUrlHelper.Action("updateEventAuditingStatuses","ChannelEvent",new RouteValueDictionary{{"eventID",threadid}})%>"><%=GetResourceString("Common_PassAudit")%></a>
    <%}%>
  </div>
  <% }
      if (!errorAuditingStatus || hasManagePermission)
      {
     %>
  <%   if (TempData["StatusMessageType"] != null)
       {
           StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
           Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 2000, false));

           TempData["StatusMessageType"] = null;
           TempData["StatusMessageContent"] = null;
       } %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-event-show">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <div class="spb-event-details tn-helper-clearfix">
        <div class="tn-avatar-big"> <%=SPBHtmlHelper.Instance().ShowEventLogo(eventThread, EventPhotoTypes.Logo) %> <span class="tn-round-corner"></span></div>
        <div class="spb-event-info">
          <div class="tn-info-part">
            <dl>
              <dt class="tn-text-note"><%=GetResourceString("Label_Time",EventApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
              <dd><span class="tn-date"><%=EventDateFormatter.FormatDate(eventThread.StartTime,eventThread.EndTime,!eventThread.IsWholeDay) %></span></dd>
            </dl>
            <dl>
              <dt class="tn-text-note"><%=GetResourceString("Label_LocalArea", EventApplicationID)%><%=GetResourceString("Common_Colon") %></dt>
              <dd><a href="<%=SiteUrls.Instance().ListEventsByAreaCode(eventThread.AreaCode) %>"> <%=Formatter.FormatArea(eventThread.AreaCode, true)%></a> <%=eventThread.Location %></dd>
            </dl>
            <% SiteCategory parentCategory = ViewData["ParentCategory"] as SiteCategory;
               SiteCategory category = ViewData["Category"] as SiteCategory;
               if (category != null)
               {%>
            <dl>
              <dt class="tn-text-note"><%=GetResourceString("Label_EventCategory", EventApplicationID)%><%=GetResourceString("Common_Colon") %></dt>
              <dd>
                <%  if (parentCategory != null)
                    { %>
                <a href="<%=SPBUrlHelper.Action("Search","ChannelEvent",new RouteValueDictionary{{"siteCategoryID",parentCategory.CategoryID}}) %>"><%=parentCategory.GetMultilingualCategoryName(CurrentUserLanguage)%></a>,
                <%} %>
                <a href="<%=SPBUrlHelper.Action("Search","ChannelEvent",new RouteValueDictionary{{"siteCategoryID",category.CategoryID}}) %>"> <%=category.GetMultilingualCategoryName(CurrentUserLanguage)%></a></dd>
            </dl>
            <%} %>
            <dl>
              <dt class="tn-text-note"><%=GetResourceString("Label_ReleaseUser", EventApplicationID)%><%=GetResourceString("Common_Colon") %></dt>
              <dd><a href="<%=SiteUrls.Instance().UserChannelHome(eventThread.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>" title="<%=string.Format(GetResourceString("Description_Pattern_ViewUserDomain"), eventThread.Sponsor) %>"><%=eventThread.Sponsor%></a></dd>
            </dl>
            <%if (eventThread.IsClubEvent)
              {
                  Club club = ViewData.Get<Club>("Club", null);
                  if (club != null)
                  { %>
            <dl>
              <dt class="tn-text-note"><%=GetResourceString("Label_AttributeClub", EventApplicationID)%><%=GetResourceString("Common_Colon") %></dt>
              <dd><a href="<%=SiteUrls.Instance().ClubDomainHome(club.DomainName) %>" target="_blank" title="<%=string.Format(GetResourceString("Description_Pattern_CheckClubName",EventApplicationID),club.ClubName) %>"><%=club.ClubName%></a></dd>
            </dl>
            <%}
              } %>
            <% string payName = string.Empty;
               if (eventThread.PayType == PayType.Free) payName = GetResourceString("Enum_PayType_Free", EventApplicationID);
               else if (eventThread.PayType == PayType.AA) payName = GetResourceString("Enum_PayType_Plan", EventApplicationID);
               else payName = GetResourceString("Enum_PayType_Charge", EventApplicationID); %>
            <dl>
              <dt class="tn-text-note"><%=GetResourceString("Label_ChargeType", EventApplicationID)%><%=GetResourceString("Common_Colon") %></dt>
              <dd><%=payName%>&nbsp;&nbsp;<%=eventThread.PayDescription%></dd>
            </dl>
            <dl>
              <dt class="tn-text-note"><%=GetResourceString("Label_LimitPeopleNum", EventApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
              <dd>
                <% if (eventThread.IsAuditingSigner) Response.Write(GetResourceString("Description_Auditing", EventApplicationID) + "&nbsp;&nbsp;"); %>
                <% if (eventThread.AllowMemberInviteFriend) Response.Write(GetResourceString("Message_TakeFriend", EventApplicationID) + "&nbsp;&nbsp;"); %>
                <%=GetResourceString("Label_SignUpEndTime", EventApplicationID)%>&nbsp;&nbsp;<%=EventDateFormatter.FormatDate(eventThread.SignEndTime,true) %></dd>
            </dl>
            <% if (eventThread.LimitCount > 0 && eventThread.SurplusCount > 0)
               { %>
            <dl>
              <dt class="tn-text-note"><%=GetResourceString("Label_LeavePeopleNum", EventApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
              <dd><%=GetResourceString("Message_LeaveOther", EventApplicationID)%><strong><%=eventThread.SurplusCount %></strong><%=GetResourceString("Message_LeavePeopleNum", EventApplicationID)%> </dd>
            </dl>
            <%} %>
            <dl>
              <dt class="tn-text-note"><%=GetResourceString("Label_RelationMode", EventApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
              <dd>
                <%if (!string.IsNullOrEmpty(eventThread.Telephone))
                  { %>
                <%=GetResourceString("Label_PersonUserTel",UserApplicationID)%><%=GetResourceString("Common_Colon") %><%=eventThread.Telephone%>&nbsp;&nbsp;
                <%} %>
                <%if (!string.IsNullOrEmpty(eventThread.Moblie))
                  { %>
                <%=GetResourceString("Label_PersonUserMobile", UserApplicationID)%><%=GetResourceString("Common_Colon") %><%=eventThread.Moblie%>&nbsp;&nbsp;
                <%} %>
                <%if (!string.IsNullOrEmpty(eventThread.Email))
                  { %>
                <%=GetResourceString("Label_UserEamilAddress", UserApplicationID)%><%=GetResourceString("Common_Colon") %><%=eventThread.Email%>&nbsp;&nbsp;
                <%} %>
              </dd>
            </dl>
          </div>
          <div class="spb-event-count"> <span class="tn-action"><span class="tn-action-text"><%=eventThread.HitTimes%><%=GetResourceString("Label_Scan",EventApplicationID)%></span> </span> <span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("ListEventMembers", "ChannelEvent", new RouteValueDictionary { { "eventID", eventThread.EventID } })%>"><%=eventThread.MemberCount%><%=GetResourceString("Label_Attend", ApplicationIDs.Instance().Event())%></a> </span> <span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("ListEventMembers", "ChannelEvent", new RouteValueDictionary { { "eventID", eventThread.EventID } })%>"><%=eventThread.FaviteCount%><%=GetResourceString("Label_Attention",EventApplicationID) %></a> </span> <span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("ListEventPhotos", "ChannelEvent", new RouteValueDictionary { { "eventID", eventThread.EventID } })%>"><%=eventThread.PhotoCount%><%=GetResourceString("Label_Photos", EventApplicationID)%></a> </span> <span class="tn-action"><a class="tn-action-text" href="<%=SiteUrls.Instance().ShowEvent(eventThread.EventID) %>#comments"><%=eventThread.PostCount%><%=GetResourceString("Label_Messages", EventApplicationID)%></a> </span> </div>
          <div class="spb-event-actions tn-border-light tn-border-top">
            <div class="spb-event-countdown"><%=eventThread.GetMultilingualEventStatusName(CurrentUserLanguage) %></div>
            <% if (EventPermission.ValidateSignUp(eventThread, CurrentUser))
               {
                   if (CurrentUser != null)
                   {
                %>
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Action_SignUp", EventApplicationID), SPBUrlHelper.Action("Control_EventSignUp", "ChannelEvent", new RouteValueDictionary { { "eventID", eventThread.EventID } }), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Join, TextIconLayout.IconText, new RouteValueDictionary { { "class", "nyroModal" } }, null)%>
            <%}
                   else if (CurrentUser == null && eventThread.IsAllowAnonymousUserSignUp)
                   { %>
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Action_SignUp", EventApplicationID), SPBUrlHelper.Action("Control_EventSignUp", "ChannelEvent", new RouteValueDictionary { { "eventID", eventThread.EventID } }), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Join, TextIconLayout.IconText, new RouteValueDictionary { { "class", "nyroModal" } }, null)%>
               <%}
                   else
                   {%>
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Action_SignUp", EventApplicationID),SiteUrls.Instance().Login(true), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Join, TextIconLayout.IconText,null, null)%>
               <% }
               }
               if (CurrentUser != null)
               {%>
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Common_Share", EventApplicationID), SiteUrls.Instance().ShareInModal(true,WebUtils.FullPath(Request.RawUrl), eventThread.EventName, eventThread.Excerpt, SiteUrls.Instance().EventPhotoUrl(eventThread.FeaturedPhotoID, EventPhotoTypes.Logo), ApplicationIDs.Instance().Event(), eventThread.UserID, eventThread.Sponsor), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Share, TextIconLayout.IconText, new RouteValueDictionary { { "class", "nyroModal" } }, null)%>
           
            <% if (!IsFavorited)
               { %>
            <%=SPBHtmlHelper.Instance().LinkButton("favirateButton", GetResourceString("Action_Attention", EventApplicationID), SPBUrlHelper.Action("Control_NewFavorite", "Channel", new RouteValueDictionary { { "favoriteItemName",WebUtils.UrlEncode(GetResourceString("Description_Event", EventApplicationID)) }, { "createFavoriteItemUrl", SPBUrlHelper.Action("CreateFavorite", "ChannelEvent", new RouteValueDictionary { { "eventID", Model.EventID } }) } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Feed, TextIconLayout.IconText, null, null)%>
            <%}
               else
               { %>
            <%=SPBHtmlHelper.Instance().LinkButton("cancelfavorite", GetResourceString("Action_CancelAttention", EventApplicationID), SPBUrlHelper.Action("DeleteFavorite", "ChannelEvent", new RouteValueDictionary { { "eventID", eventThread.EventID } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Feed, TextIconLayout.IconText, null, null)%>
            <%} %>
            <%}
               else
               { %>
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Common_Share", EventApplicationID), SiteUrls.Instance().Login(true), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Share, TextIconLayout.IconText,null, null)%>
               
               <%}%>
            <%if (CurrentUser != null && EventPermission.Validate(eventThread, CurrentUser, PermissionItemKeys.Instance().InviteFriendJoinEvent()))
              { %>
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty,GetResourceString("Action_InvitationFriend"), SPBUrlHelper.Action("EventInvitation","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID}}), ButtonSizes.Default, HighlightStyles.Default,IconTypes.UserInvite, TextIconLayout.IconText) %>
            <%} %>
            <% if (eventMember != null && Model.EventStatus == EventStatuses.Published && Model.UserID != eventMember.UserID)
               { %>
            <a href="<%=SPBUrlHelper.Action("ExitEvent","ChannelEvent",new RouteValueDictionary{{"userID", CurrentUser != null ? CurrentUser.UserID : 0},{"eventID",eventThread.EventID}}) %>" onclick="if (!confirm('<%=GetResourceString("Message_ConfirmExitEvent", EventApplicationID) %>')) { return false; } "><%=GetResourceString("Action_CancelSignUp",EventApplicationID)%></a>
            <%} %>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="tn-blank10"></div>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-event-description">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <% if (CurrentUser != null && EventPermission.Validate(eventThread, CurrentUser, PermissionItemKeys.Instance().EditEvent()))
         { %>
      <span class="tn-helper-right"> <a href="<%=SPBUrlHelper.Action("EditEvent","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID}}) %>"><%=GetResourceString("Action_Edit")%></a> </span>
      <%} %>
      <h3 class="tn-helper-reset"> <%=GetResourceString("Label_Description")%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom"> <%=body %> </div>
  </div>
  <div class="tn-blank10"></div>
  <% IList<EventPhoto> photos = ViewData["EventPhotos"] as IList<EventPhoto>; %>
  <% if (photos.Count > 0)
     { %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-photos-main spb-event-photos">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom"><span class="tn-helper-right"> <a href="<%=SPBUrlHelper.Action("ListEventPhotos","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID}}) %>"
               ><%=GetResourceString("Action_More")%></a> </span>
      <h3 class="tn-helper-reset"> <%=GetResourceString("Title_EventPhoto",EventApplicationID)%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <ul class="tn-photo-list tn-widget tn-helper-reset tn-helper-clearfix">
        <% foreach (EventPhoto photo in photos)
           { %>
        <li class="tn-photo-item">
          <p class="tn-photo-wrap tn-widget-content tn-border-gray"> <a href="<%=SiteUrls.Instance().ShowEventPhoto(photo.AttachmentID) %>"> <img src="<%=SiteUrls.Instance().EventPhotoUrl(photo.AttachmentID, EventPhotoTypes.Thumbnail) %>"
                            title="<%=photo.FriendlyFileName %>" /><span></span></a> </p>
        </li>
        <%} %>
      </ul>
    </div>
  </div>
  <%} %>

  <div class="tn-blank10"></div>
  <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001002210003", new RouteValueDictionary { { "class", "spb-ad-main-bottom" } })%> <a name="comments" id="comments"></a>
  <div id="ListEventPosts">
    <% Html.RenderAction<ChannelEventController>(n => n.Control_ListEventPosts(eventThread.EventID, null)); %>
  </div>
  <%} %>
  <script type="text/javascript">
      $(document).ready(function() {
        $("#favirateButton").dialog({id:"favirateDialog",title:'<%=GetResourceString("Action_Attention",EventApplicationID) %>' });        
       

        $("#cancelfavorite").click(function() {
            if (!confirm("<%=GetResourceString("Message_ConfirmCancelAttention",EventApplicationID) %>"))
                return false;
        });
          $('.nyroModal').nyroModal({
              resizeable: true
          });
      });
  </script>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
  <% Html.RenderAction<ChannelEventController>(n => n.Control_EventAction(ViewData.Model.EventID)); %>
  <div class="tn-blank10"></div>
  <%Html.RenderAction<ChannelController>(c => c.Control_ListFavoriteUsersBlock(Model.EventID, FavoriteItemKeys.Instance().EventThread(), GetResourceString("Title_VsEventInterestMember", ApplicationIDs.Instance().Event()), 12));%>
    <% IList<EventMember> members = ViewData["EventMembers"] as IList<EventMember>;
       if (members.Count > 0)
       {%>
  <div class="tn-blank10"></div>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-members-new-block">
            <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom"><span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("ListEventMembers","ChannelEvent",new RouteValueDictionary{{"eventID",Model.EventID}}) %>"
              ><%=GetResourceString("Action_More")%></a></span>
              <h3 class="tn-helper-reset"> <%=GetResourceString("Title_EventMember", ApplicationIDs.Instance().Event())%></h3>
            </div>
            <div class="tn-box-content tn-widget-content tn-corner-bottom">
              <ul class="tn-avatar-list tn-helper-reset">
              
               <% foreach (EventMember member in members)
                  {%>
        <li class="tn-avatar-item">
          <div class="tn-avatar"> <%=SPBHtmlHelper.Instance().ShowUserAvatar(member.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small)%><span class="tn-round-corner"></span> </div>
          <%if (member.UserID > 0 && member != null)
            { %>
          <a class="tn-user-name" href="<%=SiteUrls.Instance().UserChannelHome(member.UserID,UserDomainSpecialAppIDs.Instance().Home()) %>" ><%=SPBHtmlHelper.Instance().UserDisplayName(member.UserID) %></a>
          <%}
            else Response.Write(member.DisplayName);%>
        </li>
        <%
                  } %>
              
              
              </ul>
            </div>
          </div>
  
  
  
  <%} %>
</asp:content>
