﻿<%@ Page Title="" Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<EventThread>" %>

<asp:content id="mainContentRegion" contentplaceholderid="mainContentRegion" runat="server">
</asp:content>
<asp:content id="sidebarContentRegion" contentplaceholderid="sidebarContentRegion"
    runat="server">
</asp:content>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
    <% Html.RenderPartial("Controls/Events/ChannelEventSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server">
  <% 
      int EventApplicationID = ApplicationIDs.Instance().Event();
      EventThread eventThread = ViewData.Model;

      bool isCreating = ViewData.GetBool("IsCreating", false);
    %>
    <div class="tn-wrapper">
<div class="tn-grid">
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-new-event">
          <div class="tn-box-content tn-widget-content tn-corner-all">
         <div class="tn-instructions">
              <div class="tn-progress-bar tn-widget-content tn-corner-all">
                <div style="width: 500px;" class="tn-progress-bar-value tn-widget-header tn-corner-left tn-border-tbl"></div>
              </div>
              <ul class="tn-helper-clearfix">
            <% if (CurrentUser != null && EventPermission.Validate(eventThread, CurrentUser, PermissionItemKeys.Instance().EditEvent()))
               { %>
            <li class="tn-step"><b class="tn-widget-content tn-corner-all"></b> <span><a href="<%=SPBUrlHelper.Action("EditEvent","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID}}) %>">
              <%=GetResourceString("Description_FirstStepEventBody", EventApplicationID)%>
             </a> </span></li>
            <li class="tn-step tn-selected"><b class="tn-widget-content tn-widget-header tn-corner-all"></b><span><a  href="<%=SPBUrlHelper.Action("ShowEventSettings","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID}}) %>">
              <%=GetResourceString("Description_SecondStepEventSet", EventApplicationID)%>
           </a></span> </li>
            <%} %>
          </ul>
         </div>
        <% if (TempData["StatusMessageType"] != null)
           {
               StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
               if (messageType == StatusMessageType.Success)
                   Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
               else
                   Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), false));
               TempData["StatusMessageType"] = null;
           }%>
        <div class="tn-form-box">
                <form id="SetEventForm" name="SetEventForm" action="<%=SPBUrlHelper.Action("SaveEventSettings","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID},{"isCreating",isCreating}}) %>"
                  class="tn-helper-reset" method="post">
                <table>
                  <tbody>
                    <tr>
                      <th><%=GetResourceString("Label_EventLogo", EventApplicationID)%><%=GetResourceString("Common_Colon") %></th>
                      <td>
                      <div class="tn-helper-clearfix spb-upload-avatar">
                <div class="spb-avatar-box">
                 <%=SPBHtmlHelper.Instance().ShowEventLogo(eventThread, EventPhotoTypes.Logo) %> 
                </div>
                <div class="spb-upload-main">
                  <div class="spb-upload-files">
                    <div class="spb-upload-tips tn-border-gray tn-border-bottom tn-text-note">
                    <%=String.Format(GetResourceString("Description_Pattern_UploadAvatar", ApplicationIDs.Instance().User()), SiteSettingsManager.GetSiteSettings().SmallAvatarWidth + "x" + SiteSettingsManager.GetSiteSettings().SmallAvatarWidth)%>
                    </div>
                    <div class="spb-upload-wrapper tn-border-gray tn-border-rbl">
                      
                        <div class="spb-upload-fieldset tn-border-gray tn-border-top" id="fsUploadProgress"> <span class="spb-upload-legend"><%=GetResourceString("Label_OnloadEventSign",EventApplicationID)%></span></div>
                        <div style="display: none;" id="divStatus"></div>
                        <div class="spb-upload-actions tn-border-gray tn-border-top"> 
                         <% 
                             string handdlerUrl = Globals.GetFullUrlInFileHandlerSite(EventAttachmentManager.Instance().StorageProviderName, WebUtils.ResolveUrl("~/Services/Event/EventUploadLogo.ashx"));
                             string flashUrl = Globals.GetFullUrlInFileHandlerSite(EventAttachmentManager.Instance().StorageProviderName, WebUtils.ResolveUrl("~/Utility/UploadFiles/swfupload.swf"));
                             string uploadPhotoTypes = EventAttachmentManager.Instance().Settings.Extensions;
                             StringBuilder newUploadPhotoTypes = new StringBuilder();
                             string[] types = uploadPhotoTypes.Split(',');
                             foreach (string type in types)
                             {
                                 if (!string.IsNullOrEmpty(type))
                                     newUploadPhotoTypes.AppendFormat("*.{0};", type);
                             }
                             int maxFileSize = (int)EventAttachmentManager.Instance().Settings.MaxAttachmentSize;
                                %>
                                 <% Html.RenderAction<ChannelController>(n => n.Control_UploadAvatarAttachment(CurrentUser != null ? CurrentUser.UserName : string.Empty, handdlerUrl, flashUrl, Model.EventID, newUploadPhotoTypes.ToString(), maxFileSize.ToString(), false, string.Empty)); %>

                        </div>
                    </div>
                  </div>
              
                </div>
              </div>
              </td>
                    </tr>
                    </tbody> 
                    <tbody>
                    <tr>
                    <% IList<Club> myJoinedClubs = ViewData.Get<IList<Club>>("myJoinedClubs", new List<Club>());
                       Club clubb = ViewData.Get<Club>("club", null); %>
                      <th><%=GetResourceString("Label_AttributeClub",EventApplicationID)%><%=GetResourceString("Common_Colon") %> </th>
                      <td><label class="tn-form-label"> </label>
                       <select id="clubList" name="clubList" onchange="clubListChange()" class="tn-dropdownlist" <%if(clubb!=null && clubb.ClubID>0) Response.Write("disabled=\"disabled\""); %>>
                  <option value="0" <%if (clubb == null || clubb.ClubID<=0) Response.Write("checked=\"checked\""); %>>
                  <%if (clubb != null)
                        Response.Write(clubb.ClubName);
                    else Response.Write(GetResourceString("Common_PleaseChoose"));
                   %></option>
                  <% foreach (Club club in myJoinedClubs)
                     {%>
                  <option value="<%=club.ClubID %>" <%if (clubb!=null && clubb.ClubID==club.ClubID) Response.Write("checked=\"checked\""); %>> <%=club.ClubName %></option>
                  
                  <%} %>
                </select><span id="onlyAllowClubMemberSignUp" <%if(clubb!=null && clubb.ClubID>0) Response.Write("style=\"display:\""); else Response.Write("style=\"display:none\""); %>>
                      <input type="checkbox" name="isOnlyAllowClubMemberSignUp" id="isOnlyAllowClubMemberSignUp"  value="true" <%if (eventThread.IsOnlyAllowClubMemberSignUp) Response.Write("checked=\"checked\""); %> /><label for="isOnlyAllowClubMemberSignUp"><%=GetResourceString("Label_OnlyAllowClubMemberSignUp", EventApplicationID)%></label>
                      </span>
                        <span class="tn-text-note"><%=GetResourceString("Description_SetAfterNoAllowUpdate",EventApplicationID)%></span></td>
                    </tr>
                      <tr>
                      <th><%=GetResourceString("Label_ChargeType",EventApplicationID)%><%=GetResourceString("Common_Colon") %></th>
                      <td>
                       <select name="payType" id="payType" class="tn-dropdownlist">
                  <option <% if(eventThread.PayType== PayType.Free) Response.Write("selected=\"selected\""); %>
                                        value="0"><%=GetResourceString("Enum_PayType_Free", EventApplicationID)%></option>
                  <option <% if(eventThread.PayType== PayType.AA) 
                  Response.Write("selected=\"selected\""); %>
                                        value="1"><%=GetResourceString("Enum_PayType_Plan", EventApplicationID)%></option>
                  <option <% if(eventThread.PayType== PayType.Charge) Response.Write("selected=\"selected\""); %>
                                        value="2"><%=GetResourceString("Enum_PayType_Charge", EventApplicationID)%></option>
                </select>
                
                <input type="text" value="<%=eventThread.PayDescription %>" id="payDescription" name="payDescription" class="tn-textbox tn-input-long  tn-border-gray" />
                      </td>
                      </tr>
                      <%if (eventThread.IsPublic)
                        { %>
                      <tr>
                      <th><%=GetResourceString("Label_EventOptions",EventApplicationID)%><%=GetResourceString("Common_Colon") %></th>
                      <td>
                      <input name="limitCount" type="text" class="tn-textbox tn-input-short tn-border-gray" id="limitCount"
                                    value="<%=eventThread.LimitCount>=0?eventThread.LimitCount:100 %>" size="5" /> 
                                      <span class="tn-text-note"><%=GetResourceString("Label_LimitUserCount", EventApplicationID)%></span>
                      </td>   </tr>
                         <% if (ViewData.GetBool("EnableAnonymousUserSignUp", false)) //如果全局设置中不允许匿名用户报名，则不允许用户配置此项
                            { %>
                      <tr>
                      <th>&nbsp;</th>
                      <td>
                      <input type="checkbox" name="isAllowAnonymousUserSignUp" id="isAllowAnonymousUserSignUp" <%if(eventThread.IsOnlyAllowClubMemberSignUp) Response.Write("disabled=\"disabled\""); %> value="true" <%if (eventThread.IsAllowAnonymousUserSignUp) Response.Write("checked=\"checked\""); %> /><label for="isAllowAnonymousUserSignUp"><%=GetResourceString("Label_AnonymousUserSignUp",EventApplicationID) %></label> 
                      </td>
                      </tr>
                      <%} %>
                      <tr>
                      <th>&nbsp;</th>
                      <td>
                      <input type="checkbox" name="isAuditingSigner" id="isAuditingSigner"  value="true" <%if (eventThread.IsAuditingSigner) Response.Write("checked=\"checked\""); %> /><label for="isAuditingSigner"><%=GetResourceString("Label_IfNeedAuditingSignUpMember",EventApplicationID)%></label>  
                      </td>
                      </tr>
                      <%} %>
                      <% if (EventPermission.ValidateSetPermission(eventThread, CurrentUser, PermissionItemKeys.Instance().InviteFriendJoinEvent()))
                         { %>
                      <tr>
                      <th>&nbsp;</th>
                      <td>
                      <input type="checkbox" name="allowMemberInviteFriend" id="allowMemberInviteFriend"  value="true" <%if (eventThread.AllowMemberInviteFriend) Response.Write("checked=\"checked\""); %> /><label for="allowMemberInviteFriend"><%=GetResourceString("Label_AllowMemberInviteFriend", EventApplicationID)%></label>  
                      </td>
                      </tr>
                      <%}
                         if (EventPermission.ValidateSetPermission(eventThread, CurrentUser, PermissionItemKeys.Instance().UploadEventPhoto()))
                         { %>
                      <tr>
                      <th>&nbsp;</th>
                      <td>
                      <input type="checkbox" name="allowMemberUploadPhoto" id="allowMemberUploadPhoto"  value="true" <%if (eventThread.AllowMemberUploadPhoto) Response.Write("checked=\"checked\""); %> /><label for="allowMemberUploadPhoto"><%=GetResourceString("Label_AllowMemberUploadPhoto", EventApplicationID)%></label>
                      </td>
                      </tr>
                      <%} %>
                    <tr>
                      <th>&nbsp;</th>
                      <td>
                          <%=SPBHtmlHelper.Instance().SubmitButton("postButton", GetResourceString("Button_Submit", EventApplicationID))%>
                <% if (Request.UrlReferrer != null)
                   {%>
                <%=SPBHtmlHelper.Instance().CancelButton(Request.UrlReferrer.AbsoluteUri)%>
                <%} %>
                      </td>
                    </tr>                  
                    </tbody>
                </table>
                </form>

              </div>
        </div>
      </div>
<script type="text/javascript">
  function clubListChange(){
  if($("#clubList").val()==0)
  {
  $("#onlyAllowClubMemberSignUp").css('display','none')
  }
  else {
  $("#onlyAllowClubMemberSignUp").css('display','')
 }
  };
        $(document).ready(function() {  
         $("#payDescription").watermark("<%=GetResourceString("Label_ChargeExplain", EventApplicationID)%>");          

            $("#payType").click(payTypeClick);
            payTypeClick();
            var isPublic = "<%=eventThread.IsPublic %>";
            $("#isOnlyAllowClubMemberSignUp").click(function() {
                if ($("#isOnlyAllowClubMemberSignUp").attr('checked')) {
                    $("#isAllowAnonymousUserSignUp").removeAttr("checked");
                    $("#isAllowAnonymousUserSignUp").attr("disabled", "disabled");
                }
                else if (Boolean(isPublic.toLowerCase()))
                    $("#isAllowAnonymousUserSignUp").removeAttr("disabled");
            });
   
        function payTypeClick() {
            var selectvalue = $('#payType').val();
            if (selectvalue > 0)
                $('#payDescription').fadeIn('normal');
            else
                $('#payDescription').fadeOut('fast');
        };
        $("#SetEventForm").validate({
            rules: {
                limitCount: { required: true, digits: true },
                payDescription:{maxBlength:20}
            },
            messages: {
                limitCount: { required: "<%=GetResourceString("Validate_SetEventForm_InputLimitUserCount",EventApplicationID) %>",digits: "<%=GetResourceString("Validate_SetEventForm_InputPositiveInteger",EventApplicationID) %>" },
                payDescription:{maxBlength:"描述内容最多20个字"}
            }
        });
        $("#postButton").click(function() {
            if (!$("#SetEventForm").valid()) {
                return false;
            }
        });
        });
    </script>
</div>
</div>
</asp:content>
