﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage" %>

<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server"></asp:content>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
    <% Html.RenderPartial("Controls/Events/ChannelEventSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
  <% Response.Write(string.Format("<link rel=\"stylesheet\" href=\"{0}\" type=\"text/css\" media=\"screen\" />", WebUtils.ResolveUrl("~/Utility/UploadFiles/css/default.css"))); %>
  <spb:Script runat="server" ID="swfupload" Src="~/Utility/UploadFiles/js/swfupload.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="swfupload_queue" Src="~/Utility/UploadFiles/js/swfupload.queue.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="fileprogress" Src="~/Utility/UploadFiles/js/fileprogress.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="handlers" Src="~/Utility/UploadFiles/js/handlers.js"
        SetExpireDays="30" />
  <% EventAttachmentSettings settings = ViewData["EventAttachmentSettings"] as EventAttachmentSettings;
     string fileTypes = ViewData.GetString("Extensions", string.Empty);

     int eventID = ViewData.GetInt("EventID", 0);
     string uploadUrl = Globals.GetFullUrlInFileHandlerSite(EventAttachmentManager.Instance().StorageProviderName, WebUtils.ResolveUrl("~/Services/Photo/UploadPhotoAttachments.ashx"));
     string flashUrl = Globals.GetFullUrlInFileHandlerSite(EventAttachmentManager.Instance().StorageProviderName, WebUtils.ResolveUrl("~/Utility/UploadFiles/swfupload.swf"));
     string EditEventPhotosUrl = SPBUrlHelper.Action("EditEventPhotos", "ChannelEvent", new RouteValueDictionary { { "eventID", eventID } });
     EventAttachmentSettings eventAttachmentSettings = EventConfiguration.Instance().AttachmentSettings;
     int EventApplicationID = ApplicationIDs.Instance().Event();
    %>

    
 <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-upload-photos">
          <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom"><span class="tn-helper-right">
          <a href="<%=SPBUrlHelper.Action("ShowEvent","ChannelEvent",new RouteValueDictionary{{"eventID",eventID}}) %>" > <%=GetResourceString("Action_ReturnEvent", EventApplicationID)%></a></span>
       <h3 class="tn-helper-reset"> <%=GetResourceString("Title_OnloadEventPhoto",EventApplicationID)%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <div class="tn-form">
         <div class="tn-widget">
                <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray"><span class="tn-helper-left"><span class="tn-icon tn-icon-exclamation"></span></span>
                  <div class="tn-helper-flowfix"> <strong><%=GetResourceString("Message_Remind",ApplicationIDs.Instance().Event())%><%=GetResourceString("Common_Colon") %> </strong><%=string.Format(GetResourceString("Description_Pattern_BatchOnloadMostSelectPhotoAndSizeAndType", EventApplicationID), eventAttachmentSettings.MaxPictureCountATime, eventAttachmentSettings.MaxAttachmentSize, eventAttachmentSettings.Extensions)%>
                  
                  </div>
                </div>
              </div>
          <div class="spb-upload-control-area tn-helper-clearfix">
                <div class="spb-upload-control">
                 <span id="spanButtonPlaceHolder"></span>
          <a name="btnCancel" type="button" class="spb-upload-button" onclick="swfu.cancelQueue();" id="btnCancel" value=""><%=GetResourceString("Button_CleanOutList",EventApplicationID)%></a>
                </div>
                </div>
        <div class="fieldset flash" id="fsUploadProgress"> <span class="legend"><%=GetResourceString("Description_OnloadPhotoList", EventApplicationID)%></span> </div>
        <div class="legend" style="display:none" id="divStatus">
        <%=GetResourceString("Description_OnloadEndAfterEditOrContinueOnload",EventApplicationID)%>
        <%=SPBHtmlHelper.Instance().LinkButton("nextStepButton", GetResourceString("Button_NextStep", EventApplicationID), ButtonSizes.Default, HighlightStyles.Default, null, null)%>
         </div>
         
        <div id="advanceSettingOutDiv" class="tn-form-row tn-form-row-button">
        
                 
                <%=SPBHtmlHelper.Instance().Button("btnUpload", GetResourceString("Button_Upload"), ButtonSizes.Large, HighlightStyles.Primary, new RouteValueDictionary { { "onclick", "uploadPhotosClick();" } }, null)%>
              <% if (Request.UrlReferrer != null) { Response.Write(SPBHtmlHelper.Instance().LinkButton("candlerUploadPhotos", GetResourceString("Button_Cancel"), Request.UrlReferrer.AbsoluteUri, ButtonSizes.Large, HighlightStyles.Secondary)); } %>
   
          </div>
        </div>
      </div>
      </div>

  <script type="text/javascript">
  
   var uploadPhotosClick = function() {
          if($('.progressWrapper:visible').length <1 )
           { alert('<%=GetResourceString("Message_SelectOnloadPhoto", EventApplicationID)%>') }
            else startUpload();
          }
  
      var swfu;
      window.onload = function() {
          var settings = {
              flash_url: '<%= WebUtils.ResolveUrl("~/Utility/UploadFiles/swfupload.swf") %>',
              upload_url: '<%=WebUtils.ResolveUrl("~/Services/Event/UploadEventPhotos.ashx") %>',
              post_params: {
                  "currentUserID": "<%=EncryptManager.EncryptTokenForInviteFriend(Globals.GetCurrentUser().UserID.ToString()) %>"
              },
              file_size_limit: '<%=settings.MaxAttachmentSize %>',
              file_post_name: 'fileData',
              file_types: '<%=fileTypes %>',
              file_types_description: "<%=GetResourceString("Description_PhotoFile", EventApplicationID)%>",
              file_queue_limit: '<%=settings.MaxPictureCountATime %>',
              custom_settings: {
                  progressTarget: "fsUploadProgress",
                  cancelButtonId: "btnCancel"
              },
              debug: false,


                button_image_url: '<%=WebUtils.ResolveUrl("~/Themes/Shared/Styles/Images/upload-button.png") %>', // Relative to the Flash file
                button_width: "140",
                button_height: "40",
                button_placeholder_id: "spanButtonPlaceHolder",
                button_text: '<span class="theFont"><%=GetResourceString("Common_Browse")%></span>',
                button_text_style: ".theFont { font-size: 14px; font-weight: bold; text-align: center; color:#333333; }",
                button_text_left_padding: 0,
                button_text_top_padding: 10,


              file_queued_handler: fileQueued,
              file_queue_error_handler: fileQueueError,
              file_dialog_complete_handler: fileDialogComplete,
              upload_start_handler: uploadStart,
              upload_progress_handler: uploadProgress,
              upload_error_handler: uploadError,
              upload_success_handler:  function (file, serverData) {
                    var serverData = eval('(' + serverData + ')');
                    if (!serverData.ok && serverData.message) {
                        var progress = new FileProgress(file, this.customSettings.progressTarget);
                        progress.setStatus(serverData.message);
                        progress.setError();
                        progress.toggleCancel(false);
                        this.customSettings.queue_upload_count--;
                    }
                },
              upload_complete_handler: uploadComplete,
              queue_complete_handler: custom_queueComplete	// Queue plugin event
          };
          swfu = new SWFUpload(settings);
      };
      function startUpload() {
          swfu.addPostParam('associateID', '<%=eventID %>');
          swfu.addPostParam('userID', '<%= CurrentUser != null ? CurrentUser.UserID : 0 %>');
          swfu.addPostParam('author', '<%=CurrentUser !=null ? CurrentUser.DisplayName : string.Empty %>');
          swfu.startUpload();
      }

      function custom_queueComplete(numFilesUploaded) {
          if (numFilesUploaded) {
              $("#divStatus").show();
              $("#nextStepButton").attr("href", '<%=EditEventPhotosUrl %>&number=' + numFilesUploaded);
          }
      }

    </script>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
  <% Html.RenderAction<ChannelEventController>(n => n.Control_EventAction(ViewData.GetInt("EventID", 0)));  %>
</asp:content>
