﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<PagingDataSet<FileThread>>" %>

<asp:content contentplaceholderid="subMenusContent" runat="server">
             <%  ViewData["ChannelFileSubMenu"] = ChannelFileSubMenu.FileRanks;

                 Html.RenderPartial("Controls/Files/SubMenus.ascx", ViewData);%>
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server" id="mainContent">
    <div class="ui-tabs ui-widget ui-widget-content ui-corner-all spb-files-rank">
        <% FileThreadSortBy rankBy = ViewData.Get<FileThreadSortBy>("rankBy", FileThreadSortBy.PostDate);
           int categoryID = Html.GetParameterFromRouteDateOrQueryString("categoryID", 0);
           string tagName = Html.GetParameterFromRouteDateOrQueryString("tagName");%>
        <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
            <li <% if (rankBy == FileThreadSortBy.StageDownloadCount) Response.Write("class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\""); %>>
                <a href="<%=SPBUrlHelper.Action("FileRanks","ChannelFile",new RouteValueDictionary{{"rankBy",FileThreadSortBy.StageDownloadCount},{"categoryID",categoryID},{"tagName",tagName}}) %>">
                    <span><%=GetResourceString("Title_MoreDownloadWeek",ApplicationIDs.Instance().File())%> </span></a></li>
            
             <li <% if (rankBy == FileThreadSortBy.DownloadCount) Response.Write("class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\""); %>>
                <a href="<%=SPBUrlHelper.Action("FileRanks","ChannelFile",new RouteValueDictionary{{"rankBy",FileThreadSortBy.DownloadCount},{"categoryID",categoryID},{"tagName",tagName}}) %>">
                    <span><%=GetResourceString("Title_DownloadGrossMore",ApplicationIDs.Instance().File())%></span></a></li>
            
            <li <% if (rankBy == FileThreadSortBy.StickyAndPostDate) Response.Write("class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\""); %>>
                <a href="<%=SPBUrlHelper.Action("FileRanks", "ChannelFile", new RouteValueDictionary { { "rankBy", FileThreadSortBy.StickyAndPostDate }, { "categoryID", categoryID }, { "tagName", tagName } })%>">
                    <span><%=GetResourceString("Title_NewUpload",ApplicationIDs.Instance().File())%></span></a></li>
             <li <% if (rankBy == FileThreadSortBy.CommentCount) Response.Write("class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\""); %>>
                <a href="<%=SPBUrlHelper.Action("FileRanks", "ChannelFile", new RouteValueDictionary { { "rankBy", FileThreadSortBy.CommentCount }, { "categoryID", categoryID }, { "tagName", tagName } })%>">
                    <span><%=GetResourceString("Title_CommentMost") %></span></a></li>
                  
            <li <% if (rankBy == FileThreadSortBy.HitTimes) Response.Write("class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\""); %>>
                <a href="<%=SPBUrlHelper.Action("FileRanks", "ChannelFile", new RouteValueDictionary { { "rankBy", FileThreadSortBy.HitTimes }, { "categoryID", categoryID }, { "tagName", tagName } })%>">
                    <span><%=GetResourceString("Title_BrowseMost")%></span></a></li>
            <li <% if (rankBy == FileThreadSortBy.StageHitTimes) Response.Write("class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\""); %>>
                <a href="<%=SPBUrlHelper.Action("FileRanks", "ChannelFile", new RouteValueDictionary { { "rankBy", FileThreadSortBy.StageHitTimes }, { "categoryID", categoryID }, { "tagName", tagName } })%>">
                    <span><%=GetResourceString("Title_HotFileWeek",ApplicationIDs.Instance().File())%></span></a></li>
        </ul>
        <div class="ui-tabs-panel ui-widget-content ui-corner-bottom">
            <% Html.RenderAction<ChannelFileController>(n => n.Control_ListFileThreads(10, rankBy, categoryID, tagName, 1)); %>
        </div>
    </div>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server" id="sidebarContent">
    <% Html.RenderAction<ChannelFileController>(n => n.Control_ListFileSiteTags(20, SiteTagsSortBy.ItemCount)); %>
</asp:content>
<asp:content contentplaceholderid="wideContentRegion" runat="server" id="wideContentRegion">
</asp:content>
