﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<IList<FileThread>>" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="File-Home" </asp:content>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <%  ViewData["ChannelFileSubMenu"] = ChannelFileSubMenu.Home;
    Html.RenderPartial("Controls/Files/SubMenus.ascx", ViewData);%>
</asp:content>
<asp:content id="templateContentRegion" contentplaceholderid="templateContentRegion"
    runat="server"></asp:content>
<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server">
  <div class="tn-wrapper"> <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001000000001", new RouteValueDictionary { { "class", "spb-ad-banner" } })%>
    <div class="tn-grid-3-13">
      <div class="tn-unit tn-first">
        <%  int applicationID = ApplicationIDs.Instance().File();
                                 int maxShowDictionaryCount = 5;%>
        <% List<SiteCategory> siteCategories = ViewData["SiteCategories"] as List<SiteCategory>;
                           if (siteCategories != null)
                           {
                        %>
        <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-category-nav-col">
          <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <h3 class="tn-helper-reset"> <%=GetResourceString("Title_Category", applicationID)%></h3>
          </div>
          <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <div class="tn-directory" id="allCategoryList">
              <%  int t = 1;
                                        foreach (SiteCategory parentCategory in siteCategories)
                                        {
                                            %>
              <div name="moreCategoryItem" <% if(t>=maxShowDictionaryCount) Response.Write("style=\"display:none\""); %>>
                <h5 class="tn-directory-path"> <a href="<%=SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary { { "SiteCategoryID", parentCategory.CategoryID }})%>"> <%=parentCategory.CategoryName%> </a> </h5>
                <%if (parentCategory.Childs != null && parentCategory.Childs.Count > 0)
                                      { %>
                <div class="tn-directory-level">
                  <% int i = 1;
                                           foreach (SiteCategory category in parentCategory.Childs)
                                           {
                                               if (i > 5) break; %>
                  <span class="tn-directory-item"><a href="<%=SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary { { "SiteCategoryID", category.CategoryID }})%>"> <%=category.CategoryName%></a> <em class="tn-text-note"><%=category.CumulateItemCount %></em></span>
                  <%i++;
                                           } %>
                  <span class="tn-directory-item"><a href="<%=SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary { { "SiteCategoryID", parentCategory.CategoryID }})%>"> <%=GetResourceString("Action_More")%></a></span> </div>
                <%} t++;%>
              </div>
              <% }%>
              <%if (siteCategories.Count >= maxShowDictionaryCount)
                                      {%>
              <p class="tn-helper-align-right"> <span class="tn-action tn-action-text-icon-right"><span id="span-morecategory"  class="tn-icon tn-icon-triangle-down"> </span><a id="moreCategory" href="javascript:;"  class="tn-action-text"><%=GetResourceString("Action_OpenMoreClass",applicationID)%></a> </span> </p>
              <%} %>
            </div>
          </div>
        </div>
        <%} %>
        <% IList<FileSection> sectionDatalist = ViewData["ExperiencePeople"] as IList<FileSection>;
                           if (sectionDatalist != null)
                           {%>
        <div class="tn-blank10"> </div>
        <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-upload-star">
          <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <h3 class="tn-helper-reset"> <%=GetResourceString("Title_FilePeople", applicationID)%></h3>
          </div>
          <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <ul class="tn-list">
              <%
                                        foreach (FileSection section in sectionDatalist)
                                        {
                                    %>
              <li class="tn-list-item tn-helper-clearfix">
                <div class="tn-list-item-area-left">
                  <div class="tn-avatar"> <a href="<%=SiteUrls.Instance().UserChannelHome(section.OwnerUserID,ApplicationIDs.Instance().File()) %>"> <%=SPBHtmlHelper.Instance().ShowUserAvatar(section.OwnerUserID, false, HyperLinkTarget._self, AvatarSizeTypes.Small)%></a> </div>
                </div>
                <div class="tn-list-item-area-main">
                  <div class="tn-list-item-row tn-list-item-heading">
                    <h5 class="tn-helper-reset"> <a href="<%=SiteUrls.Instance().UserChannelHome(section.OwnerUserID,ApplicationIDs.Instance().File()) %>"> <%=section.SectionName %></a></h5>
                  </div>
                  <div class="tn-list-item-row"> 综合积分<%=GetResourceString("Common_Colon")%><%=section.Points%> </div>
                </div>
              </li>
              <%}
                                    %>
            </ul>
          </div>
        </div>
        <%} %>
        <script type="text/javascript">
       $(document).ready(
        function() {
            $("#moreCategory").click(function() {
                var $moreCategories = $('#allCategoryList > div[name="moreCategoryItem"]:gt(<%=maxShowDictionaryCount-2 %>)');
                $moreCategories.toggle();
                if ($moreCategories.is(":visible")) {
                    $(this).text('<%=GetResourceString("Action_EasyClass", applicationID)%>');
                    $("#span-morecategory").attr({ className: "tn-icon tn-icon-triangle-up" });
                }
                else {
                    $(this).text('<%=GetResourceString("Action_OpenMoreClass", applicationID)%>');
                    $("#span-morecategory").attr({ className: "tn-icon tn-icon-triangle-down" });
                };
            });
        }
     );
   </script>
      </div>
      <div class="tn-grid-9-4">
        <div class="tn-unit tn-first"> <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001001130001", new RouteValueDictionary { { "class", "spb-ad-main" } })%>
          <% //推荐文件
         Html.RenderAction("Control_RecommendFileBlock", "ChannelFile", new RouteValueDictionary { { "commendTypeID", 113001 }, { "displayCount", 6 }, { "hasBorder", true } });
                            %>
          <% Html.RenderAction<ChannelFileController>(n => n.Control_ListFilesBlock("ListFilesBlock", GetResourceString("Title_NewUpload", applicationID), FileThreadSortBy.StickyAndPostDate, null, null, 10)); %>
          <% Html.RenderAction<ChannelFileController>(n => n.Control_ListFilesBlock("ListFilesBlock", GetResourceString("Title_HotFiles", applicationID), FileThreadSortBy.StageHitTimes, null, null, 10)); %>
        </div>
        <div class="tn-unit">
          <% //标签
         Html.RenderAction<ChannelFileController>(n => n.Control_ListFileSiteTags(20, SiteTagsSortBy.ItemCount)); %>
          <%  //精华文件
                                Html.RenderAction<ChannelFileController>(n => n.Control_ListFilesBlock("ListFilesSampleBlock", GetResourceString("Title_Essential", applicationID), FileThreadSortBy.StickyAndPostDate, null, true, 10)); %>
          <% //下载排行
                                Html.RenderAction<ChannelFileController>(n => n.Control_ListFilesBlock("ListFilesRankBlock", GetResourceString("Title_DownloadRanks", applicationID), FileThreadSortBy.StageDownloadCount, null, null, 10)); %>
        </div>
      </div>
    </div>
    <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001000000002", new RouteValueDictionary { { "class", "spb-ad-banner-bottom" } })%> </div>
</asp:content>
