﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<PagingDataSet<FileThread>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="File-Search"
</asp:content>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
<%  ViewData["ChannelFileSubMenu"] = ChannelFileSubMenu.Search;
    Html.RenderPartial("Controls/Files/SubMenus.ascx", ViewData);%>
</asp:content>
<asp:content id="mainContent" contentplaceholderid="mainContent" runat="server">
  <%
      FileThreadFullTextQuery query = ViewData.Get<FileThreadFullTextQuery>("Query", null);
      int applicationID = ApplicationIDs.Instance().File();
      Stack<SiteCategory> categoryStack = ViewData.Get<Stack<SiteCategory>>("categoryStack", new Stack<SiteCategory>());
      List<SiteCategory> siteCategoties = ViewData.Get<List<SiteCategory>>("siteCategoties", null);
      SiteCategory currentCategory = ViewData["CurrentCategory"] as SiteCategory;
      int maxShowDictionaryCount = 12;
      User searchUser = new User();
      if (query.SearchScopeUserID > 0)
          searchUser = Users.GetUser(query.SearchScopeUserID, false);
      int siteCategoryDepth = FileSectionConfiguration.Instance().SiteCategoryLevel - 1;
      bool isFullTextSearch = ViewData.GetBool("IsFullTextSearch", false);
      %>
      
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-files-search" id="FileSreach">
  <div class="tn-box-content tn-widget-content tn-corner-all">
    <div class="tn-directory">
                  <h5 class="tn-directory-path">
                  <% if (categoryStack != null && categoryStack.Count > 0)
                     {%>
                    <a href="<%=SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary{{ "TagName",WebUtils.UrlEncode(query.TagName) }, { "Keyword", WebUtils.UrlEncode(query.Keyword) }, { "SearchScopeUserID", query.SearchScopeUserID }})%>"><%=GetResourceString("Action_AllCategories", applicationID)%></a> 
                    <%}
                     else
                     {
                         Response.Write(GetResourceString("Action_AllCategories", applicationID) + GetResourceString("Common_Colon"));
                     }%> 
                         
                    <%SiteCategory category = null;
                      while (categoryStack.Count > 0)
                      {
                          category = categoryStack.Pop();
                          Response.Write(string.Format("&gt;<a href=\"{1}\">{0}</a>", category.CategoryName, SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary { { "TagName", WebUtils.UrlEncode(query.TagName) }, { "SiteCategoryID", query.SiteCategoryID }, { "Keyword", WebUtils.UrlEncode(query.Keyword) }, { "SearchScopeUserID", query.SearchScopeUserID } })));
                      } %>
                    </h5>
                     <div class="tn-directory-level tn-border-gray tn-border-bottom" id="allSiteCategoryList">
                  <%if (siteCategoties != null)
                    {
                        int iIndex = 1;%>
                    <span class="tn-directory-item  <%if (query.SiteCategoryID <= 0) Response.Write("tn-text-note tn-selected");%>"><a href="<%=SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary { { "TagName", WebUtils.UrlEncode(query.TagName) }, { "SiteCategoryID", currentCategory!=null?currentCategory.ParentID:query.SiteCategoryID }, { "Keyword", WebUtils.UrlEncode(query.Keyword) }, { "SearchScopeUserID", query.SearchScopeUserID } })%>"><%=GetResourceString("Action_Nolimit",applicationID)%></a></span>
                     <%   foreach (SiteCategory siteCategory in siteCategoties)
                          {
                              string searchUrl = SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary { { "TagName", WebUtils.UrlEncode(query.TagName) }, { "SiteCategoryID", siteCategory.CategoryID }, { "Keyword", WebUtils.UrlEncode(query.Keyword) }, { "UserID", query.SearchScopeUserID } });%>
                  <span class="tn-directory-item <%if (query.SiteCategoryID == siteCategory.CategoryID) Response.Write("tn-text-note tn-selected");%>" <% if(iIndex>=maxShowDictionaryCount) Response.Write("style=\"display:none\""); %>><a href="<%if (query.SiteCategoryID == siteCategory.CategoryID) Response.Write("javascript:;"); else { Response.Write(searchUrl); } %>"><%=siteCategory.CategoryName%></a> <em class="tn-text-note"><%=siteCategory.CumulateItemCount%></em></span>
                  <%iIndex++;
                          }
                    }
                    if (siteCategoties != null && siteCategoties.Count > maxShowDictionaryCount)
                    {%>
                <span class="tn-action tn-action-text-icon-right"><span id="span-morecategory" class="tn-icon tn-icon-triangle-down"></span>
                        <a id="morecategory" href="javascript:;" class="tn-action-text"><%=GetResourceString("Action_OpenMoreClass", applicationID)%></a> </span>

                  <%} %>
                  </div>
                  <div class="tn-directory-search tn-border-gray tn-border-bottom tn-helper-clearfix">
                    <div class="tn-search-box tn-helper-clearfix">
                     <form method="get" id="searchForm" action="<%=SPBUrlHelper.Action("Search", "ChannelFile")%>">
                      <input id="Keyword" type="text" name="Keyword" value="<%=query.Keyword %>" class="tn-search-input tn-input-medium tn-border-gray tn-border-tbl"/>
                      <input id="SiteCategoryID" type="hidden" name="SiteCategoryID" value="<%=query.SiteCategoryID %>"/>
                      <input id="TagName" type="hidden" name="TagName" value="<%=WebUtils.UrlEncode(query.TagName)  %>"/>
                      <input id="SearchScopeUserID" type="hidden" name="SearchScopeUserID" value="<%=query.SearchScopeUserID  %>"/>
                      <span class="tn-search-button tn-search-ico-button tn-border-gray tn-bg-gray">
                      <button onclick="$('#searchForm').submit();"><span class="tn-icon tn-icon-find"></span></button>
                      </span>
                      </form>
                     </div>
                    <div class="tn-directory-selected">
                    <%if (query.SiteCategoryID > 0)
                      {%>
                    <span class="tn-directory-selected-item tn-border-gray tn-bg-gray"><a class="tn-icon tn-icon-cross" href="<%=SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary { { "TagName", WebUtils.UrlEncode(query.TagName) }, { "Keyword",WebUtils.UrlEncode(query.Keyword) }, { "SearchScopeUserID", query.SearchScopeUserID } })%>">
                    </a><%=currentCategory != null ? currentCategory.CategoryName : string.Empty %></span>
                    <%}
                      if (!string.IsNullOrEmpty(query.TagName))
                      {%>
                    <span class="tn-directory-selected-item tn-border-gray tn-bg-gray"><a class="tn-icon tn-icon-cross" href="<%=SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary {{ "Keyword", WebUtils.UrlEncode(query.Keyword) }, { "SearchScopeUserID", query.SearchScopeUserID }, { "SiteCategoryID", query.SiteCategoryID } }) %>" title="<%=WebUtils.UrlDecode(query.TagName) %>"></a><%=StringUtils.Trim(WebUtils.UrlDecode(query.TagName),8,"")%></span>
                    <%}
                      if (query.SearchScopeUserID > 0)
                      {%>
                    <span class="tn-directory-selected-item tn-border-gray tn-bg-gray"><a class="tn-icon tn-icon-cross" href="<%=SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary {{ "Keyword", WebUtils.UrlEncode(query.Keyword) },{ "TagName", WebUtils.UrlEncode(query.TagName) }, { "SiteCategoryID", query.SiteCategoryID } }) %>" title="<%=searchUser.UserName%>"></a><%=searchUser.UserName %></span>
                    <%} %>
                    </div>
                  </div>
                </div>
    <div class="tn-directory-result">
     <div class="tn-list-header">
       <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
         <strong><%=GetResourceString("Title_SearchResults",applicationID) %></strong>
       </div>
     </div>
       <ul class="tn-list tn-helper-reset">
       <% if (Model != null && Model.TotalRecords > 0)
          {
              foreach (FileThread fileThread in Model.Records)
              {
                  string showFileUrl = SiteUrls.Instance().ShowFile(fileThread.ThreadID);
                   %>
                    <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                      <%if (fileThread.UserFeaturedImageAttachmentID > 0)
                        {  %>
                      <div class="tn-list-item-area-left"><a href="<%=SiteUrls.Instance().ShowFile(fileThread.ThreadID)%>">
                      <img src="<%=SiteUrls.Instance().FileFeaturedImageUrl(fileThread.UserFeaturedImageAttachmentID, FileFeaturedImageTypes.Title)%>" alt="<%=fileThread.FileName %>"/></a>
                      </div>
                      <%} %>
                      <div class="tn-list-item-area-main">
                        <div class="tn-list-item-row tn-list-item-heading"> 
                          <h5 class="tn-helper-reset"><%=SPBHtmlHelper.Instance().ContentTypeThumbnail(fileThread.FileName, ContentTypeThumbnailSize.Small)%><a href="<%=showFileUrl%>"><%=fileThread.Subject%></a>
                           <% if (fileThread.IsEssential)
                              {%>
                          <span title="<%=GetResourceString("Common_Essential") %>" class="tn-icon tn-icon-elite tn-icon-inline"></span>
                          <%} %>
                          <%if (fileThread.SpecialOrder > 0)
                            { %>
                          <span title="<%=GetResourceString("Common_SetTop")%>" class="tn-icon tn-icon-top tn-icon-inline"></span>
                          <%} %>
                          </h5>
                        </div>
                        <div class="tn-list-item-row">
                          <%if (fileThread.Price > 0)
                            { %>
                        <em class="tn-text-note"><span class="tn-icon tn-icon-coins tn-icon-inline"></span><%=fileThread.Price%></em>
                        <%} %>
                        <em class="tn-text-note tn-count"><%=GetResourceString("Label_Size")%><%=GetResourceString("Common_Colon")%>
                        <%=Formatter.FormatFriendlyFileSize(fileThread.ContentSize)%></em>
                        
                        <%if (fileThread.UserTags != null && fileThread.UserTags.Count > 0)
                          { %>
                        <em>
                       <%Response.Write(GetResourceString("Common_UserTag") + "：");
                         foreach (string tagName in fileThread.UserTags)
                         {
                             Response.Write(string.Format("<a href='{0}' target='_blank'>{1}</a> ", Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary { { "TagName", WebUtils.UrlEncode(tagName) }, { "SiteCategoryID", query.SiteCategoryID }, { "Keyword", WebUtils.UrlEncode(query.Keyword) }, { "SearchScopeUserID", query.SearchScopeUserID } })), tagName));
                         } %>
                        </em>
                        <%} %>
                        </div>
                        <div class="tn-list-item-row tn-list-item-summary">
                          <p class="tn-helper-reset"> <%=fileThread.Summary%></p>
                        </div>
                      </div>
                      <div class="tn-list-item-row"> <cite class="tn-text-note"><%=GetResourceString("Label_Author")%><%=GetResourceString("Common_Colon")%>
                             <%=SPBHtmlHelper.Instance().UserDisplayNameLink(fileThread.OwnerUserID,fileThread.Author,ApplicationIDs.Instance().File()) %>
                      </cite> <em class="tn-date tn-text-note"> <%GetResourceString("Label_PostOf", ApplicationIDs.Instance().File());%> <%=Formatter.FormatFriendlyDate(fileThread.PostDate, !isFullTextSearch)%></em>
                      <%if (!isFullTextSearch)
                        {%>
                      <cite class="tn-text-note"><%=SPBHtmlHelper.Instance().ShowRating(fileThread.RatingSum, fileThread.TotalRatings)%></cite>
                      <%=SPBHtmlHelper.Instance().LinkButton("Common_Comment", GetResourceString("Common_Comment") + fileThread.CommentCount, showFileUrl + "#addCommentArea", ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Bubble, TextIconLayout.IconText)%>
                      <%=SPBHtmlHelper.Instance().LinkButton("Common_Browse", GetResourceString("Common_Browse") + fileThread.HitTimes, showFileUrl, ButtonSizes.Default, HighlightStyles.Lite, IconTypes.View, TextIconLayout.IconText)%>
                      <%=SPBHtmlHelper.Instance().LinkButton("Label_Download", GetResourceString("Label_Download", applicationID) + fileThread.DownloadCount, showFileUrl, ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Download, TextIconLayout.IconText)%>
                      <%} %>
                      </div>
                    </li>
               <%}
          }
          else
          {
              Html.RenderPartial("Controls/Search/NoSearchResult.ascx");
          } %>
        </ul>
       <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex)%>
      </div>
     </div>
  </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("#morecategory").click(function() {
            var $moreCategories = $('#allSiteCategoryList span:not(.tn-action):gt(<%=maxShowDictionaryCount-1 %>)');
            $moreCategories.toggle();
            if ($moreCategories.is(":visible")) {
                $(this).text('<%=GetResourceString("Action_EasyClass", applicationID)%>');
                $("#span-morecategory").attr({ className: "tn-icon tn-icon-triangle-up", style: "display:block" });
            }
            else {
                $(this).text('<%=GetResourceString("Action_OpenMoreClass", applicationID)%>');
                $("#span-morecategory").attr({ className: "tn-icon tn-icon-triangle-down", style: "display:block" });
            };
        });
    });
</script>


</asp:content>
<asp:content id="sidebarContent" contentplaceholderid="sidebarContent" runat="server">
    <%Html.RenderAction<ChannelFileController>(n => n.Control_ListFileSiteTags(20, SiteTagsSortBy.ItemCount)); %>
</asp:content>
<asp:content contentplaceholderid="wideContentRegion" runat="server" id="wideContentRegion">
</asp:content>
