﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<FileThread>" %>

<asp:content contentplaceholderid="subMenusContent" runat="server">
                <%  ViewData["ChannelFileSubMenu"] = null;
                    Html.RenderPartial("Controls/Files/SubMenus.ascx", ViewData);%>
</asp:content>
<asp:content contentplaceholderid="wideContentRegion" runat="server" />
<asp:content id="mainContent" contentplaceholderid="mainContent" runat="server">

  <spb:Script runat="server" ID="JqueryFormJs" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="jquery_ui_stars" Src="~/Utility/jquery/plugin/jquery.ui.stars-3.0.1.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js"
    SetExpireDays="30" />
  <%   bool visible = true;
       if (TempData["StatusMessageType"] != null)
       {
           StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
           if (messageType == StatusMessageType.Error)
           {
               Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
               Response.Write("<br/>");
               visible = false;
           }
           TempData["StatusMessageType"] = null;
       }   
    %>
  <% 
      int applicationID = ApplicationIDs.Instance().File();
      bool hasManagePermission = ViewData.GetBool("hasManagePermission", false);
      bool errorAuditingStatus = ViewData.GetBool("errorAuditingStatus", false);
      bool passwordRight = ViewData.GetBool("passwordRight", false);
      bool showFile = true;
      PrivacyStatuses? errorPrivacyStatus = null;
      if (ViewData["errorPrivacyStatus"] != null)
          errorPrivacyStatus = (PrivacyStatuses)ViewData["errorPrivacyStatus"];

      if (Model != null && visible)
      {
          if (errorAuditingStatus)
          {
              string errorMessage = ViewData.GetString("errorMessage", string.Empty);
              if (errorAuditingStatus)
              {%>
              <div class="tn-widget">
    <div class="tn-cue-highlight tn-corner-all tn-message-box">
    <% Response.Write(errorMessage); %>
    <%
                  if (CurrentUser != null && (CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator))
                  {%>
    <%  
                      int threadid = Model.ThreadID; 
        %>
        <span class="tn-helper-right">
        <a href="<%=SPBUrlHelper.Action("Home", "File", new RouteValueDictionary { { "userDomainName",CurrentUser.UserName } })%>">我的文件</a>
        </span>
        <span class="tn-helper-left">
        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Exclamation) %>
        </span>
        <div class="tn-helper-flowfix">
        <%=GetResourceString("Label_YourAdminYouCan", applicationID)%>
<a title="<%=GetResourceString("Description_NowFileCheck", applicationID)%>" id="SetIsPassButton" href="<%=SPBUrlHelper.Action("updateFileAuditingStatuses","ChannelFile",new RouteValueDictionary{{"threadID",threadid}})%>"><%=GetResourceString("Action_PassCheck", applicationID)%></a>

        </div>
    <%}%>

    </div>
</div>
              
  <%
              }
          } %>
     <%  
          if (!hasManagePermission)
          {
              switch (Model.PrivacyStatus)
              {
                  case PrivacyStatuses.NeedPassword:
                      if (!passwordRight)
                      {
                          showFile = false;
    %>
    <div class="tn-widget">
    <div class="tn-cue-highlight tn-corner-all tn-message-box">
     <%if (CurrentUser != null)
       { %>
        <span class="tn-helper-right">
        <a href="<%=SPBUrlHelper.Action("Home", "File", new RouteValueDictionary { { "userDomainName",CurrentUser.UserName } })%>"><%=GetResourceString("Title_MyFile",applicationID)%></a>
        </span>
        <%} %>
        <span class="tn-helper-left">
        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Exclamation) %>
        </span>
        <div class="tn-helper-flowfix">
         <%=GetResourceString("Label_NowFileEncrypt", applicationID)%>
         <a href="<%=SPBUrlHelper.Action("Control_PrivacyPassword", "ChannelFile", new RouteValueDictionary { { "threadID", Model.ThreadID }}) %>" id="havepwd"><%=GetResourceString("Common_HavePassword") %></a>
          </div>
     </div>  
</div>
                <script type="text/javascript">
                    $(document).ready(function () {
                        $('#havepwd').dialog({ title: "需要密码" });
                    });
                </script>
  <%}
                      break;
                  case PrivacyStatuses.OnlyFriend:
                      if (CurrentUser == null || !Friends.IsFriend(CurrentUser.UserID, Model.OwnerUserID))
                      {
                          showFile = false;
    %>
    
    <div class="tn-widget">
    <div class="tn-cue-highlight tn-corner-all tn-message-box">
    <%if (CurrentUser != null)
      { %>
        <span class="tn-helper-right">
 <a href="<%=SPBUrlHelper.Action("Home", "File", new RouteValueDictionary { { "userDomainName",CurrentUser.UserName } })%>"><%=GetResourceString("Title_MyFile",ApplicationIDs.Instance().File())%></a>
        </span><%} %>
        <span class="tn-helper-left">
        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Limit) %>
        </span>
        <div class="tn-helper-flowfix">
        <%=GetResourceString("Description_Pattern_OnlyAllowFriendView")%>
        
        <% if (CurrentUser == null)
           {%>
        <%=GetResourceString("Action_LoginFirst",ApplicationIDs.Instance().User())%>
        <%}
           else
           { %>
            <a id="addFriendModal"  href="<%=SiteUrls.Instance().NewFriendInvitation(CurrentUser.UserName, Model.OwnerUserID) %>"><%=GetResourceString("Action_IntercourseFriend")%></a>
            <%} %>
     
        </div>
  </div>
</div>
    
  <% }
                      break;
                  case PrivacyStatuses.Privacy:
                      showFile = false;
    %>
    <div class="tn-widget">
    <div class="tn-cue-highlight tn-corner-all tn-message-box">
     <%if (CurrentUser != null && CurrentUser != null)
       { %>
        <span class="tn-helper-right">
 <a href="<%=SPBUrlHelper.Action("Home", "File", new RouteValueDictionary { { "userDomainName",CurrentUser.UserName } })%>"><%=GetResourceString("Title_MyFile",ApplicationIDs.Instance().File())%></a>
        </span><%} %>
        <span class="tn-helper-left">
        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock) %>
        </span>
        <div class="tn-helper-flowfix">
         <%=GetResourceString("Description_FileSetSecret", applicationID)%>
         <% if (Request.UrlReferrer != null)
            {%>
      &nbsp;&nbsp;<a href="<%=Request.UrlReferrer.AbsoluteUri %>"><%=GetResourceString("Action_Return")%></a>
      <%} %>
        </div>
    </div>
</div>
  <%
            break;
                  case PrivacyStatuses.Public:
            break;
                  default:
            break;
              }
          }
  %>

      <%if (!errorAuditingStatus || hasManagePermission)
        {

            if (showFile)
            {%>
            <div id="ShowFileDiv" class="tn-box tn-widget tn-widget-content tn-corner-all spb-file-show">
              <div class="tn-box-content tn-widget-content tn-corner-all">
                <div class="tn-text-heading tn-helper-clearfix">
                  <div class="spb-file-big-icon"><%=SPBHtmlHelper.Instance().ContentTypeThumbnail(Model.FileName, ContentTypeThumbnailSize.Large)%></div>
                  <h1>
                   <% if (string.IsNullOrEmpty(Model.Subject)) Response.Write(Model.FileName); else Response.Write(Model.Subject);  %>
                    <% if (Model.IsEssential)
                           Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Elite, GetResourceString("Common_Essential"), new RouteValueDictionary { { "class", " tn-icon-inline" } }));
                       if (Model.SpecialOrder > 0)
                           Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Top, GetResourceString("Common_SetTop"), new RouteValueDictionary { { "class", " tn-icon-inline" } }));
                       if (ViewData.GetBool("isRecommended", false))
                           Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Flag, GetResourceString("Common_ManagerRecommend"), new RouteValueDictionary { { "class", " tn-icon-inline" } })); 
             %>
               <%
                switch (Model.PrivacyStatus)
                {
                    case PrivacyStatuses.NeedPassword:
                        Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Key, GetResourceString("Enum_PrivacyStatuses_NeedPassword"), new RouteValueDictionary { { "class", " tn-icon-inline" } }));
                        break;
                    case PrivacyStatuses.OnlyFriend:
                        Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Limit, GetResourceString("Enum_PrivacyStatuses_OnlyFriend"), new RouteValueDictionary { { "class", " tn-icon-inline" } }));
                        break;
                    case PrivacyStatuses.Privacy:
                        Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Lock, GetResourceString("Enum_PrivacyStatuses_Privacy"), new RouteValueDictionary { { "class", " tn-icon-inline" } }));
                        break;
                    case PrivacyStatuses.Public:
                        //Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Flag, GetResourceString("Enum_PrivacyStatuses_Public"), new RouteValueDictionary { { "class", " tn-icon-inline" } }));
                        break;
                    default:
                        break;
                } %>
             </h1>
                </div>
                <div class="spb-file-details tn-helper-clearfix">
                <%if (Model.UserFeaturedImageAttachmentID > 0)
                  { %>
                  <div class="spb-file-title-img tn-border-gray">
                  <img src="<%=SiteUrls.Instance().FileFeaturedImageUrl(Model.UserFeaturedImageAttachmentID,FileFeaturedImageTypes.Slide) %>" alt="<%=StringUtils.Trim(Model.Subject,10) %>" /></div>
                  <%} %>
                  <div class="spb-file-info">
                    <div class="tn-info-part tn-helper-clearfix tn-border-gray tn-border-bottom spb-file-info-row">
                      <dl class="tn-author">
                        <dt><%=GetResourceString("Label_UploadPeople",applicationID) %><%=GetResourceString("Common_Colon") %></dt>
                        <dd><a href="<%=SiteUrls.Instance().UserDomainHome(Model.OwnerUserID) %>"><%=SPBHtmlHelper.Instance().UserDisplayName(Model.OwnerUser) %></a></dd>
                      </dl>
                      <dl class="tn-date">
                        <dt><%=GetResourceString("Label_UploadFor",applicationID) %><%=GetResourceString("Common_Colon") %></dt>
                        <dd><%=Formatter.FormatFriendlyDate(Model.PostDate)%></dd>
                      </dl>
                    </div>
                    <div class="tn-info-part tn-helper-clearfix tn-border-gray tn-border-bottom spb-file-info-row">
                      <dl class="tn-count">
                        <dt><%=GetResourceString("Label_Size", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                        <dd><%=Model.Attachment.Friendlylength%></dd>
                      </dl>
                      <dl class="tn-count">
                        <dt><%=GetResourceString("Label_DownloadIntegral", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                        <dd><%=Model.Price %></dd>
                      </dl>
                    </div>
                    <div class="tn-info-part tn-helper-clearfix tn-border-gray tn-border-bottom spb-file-info-row">
                      <dl class="tn-count">
                        <dt><%=GetResourceString("Common_Browse")%><%=GetResourceString("Common_Colon") %></dt>
                        <dd><%=Model.HitTimes %></dd>
                      </dl>
                      <dl class="tn-count">
                        <dt><%=GetResourceString("Label_Download", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                        <dd><%=Model.DownloadCount %></dd>
                      </dl>
                    </div>
                    <div class="tn-info-part tn-helper-clearfix tn-border-gray tn-border-bottom spb-file-info-row">
                      <dl class="tn-count">
                        <dt><%=GetResourceString("Label_StageDownloadCount", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                        <dd><%=Model.StageDownloadCount  %></dd>
                      </dl>
                      <dl class="tn-count">
                        <dt><%=GetResourceString("Label_UpdateDate", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                        <dd><%=Formatter.FormatFriendlyDate(Model.LastRepliedDate)%></dd>
                      </dl>
                    </div>
                     <% if (Model.UserTags != null && Model.UserTags.Count > 0)
                        { %>
                    <div class="tn-helper-clearfix tn-border-gray tn-border-bottom spb-file-info-row"> 
                    <%=GetResourceString("Common_UserTag")%><%=GetResourceString("Common_Colon") %>
           
           
            <%      string fileTags = string.Empty;
                    foreach (string tagName in Model.UserTags)
                    {
                        fileTags += string.Format("<a href='{0}'>{1}</a>&nbsp;&nbsp;", SiteUrls.Instance().ListFilesBySiteTag(tagName), tagName);
                    }
                    Response.Write(fileTags);
            %>
            </div>
            <% } %>
                    <form name="downloadForm" id="downloadForm" method="post" action="<%=SiteUrls.Instance().DownloadFileAttachment(Model.ThreadID) %>">
                    </form>

                    <div class="tn-helper-clearfix tn-border-gray tn-border-bottom tn-actions spb-file-info-row"> 
                    <span class="tn-action tn-action-text-icon"><span class="tn-icon tn-icon-download"> </span>
            <a id="downloadFile" href="javascript:;" class="tn-action-text"><%=GetResourceString("Label_Download",ApplicationIDs.Instance().File())%></a> 
                    </span>
                      <% if (Model.EnableComments && !(CurrentUser == null && (!SiteSettingsManager.GetSiteSettings().EnableAnonymousPosting || !Model.Section.EnableAnonymousPosting)))
                         {%>
                    <span class="tn-action tn-action-text-icon"><span class="tn-icon tn-icon-bubble"> </span>  <a class="tn-action-text" href="#addCommentArea"><%=GetResourceString("Action_IAmComment", applicationID)%></a> </span>
                     <%} %>
                    <span class="tn-action tn-action-text-icon"><span class="tn-icon tn-icon-alert"> </span><a class="tn-action-text" href="<%=SiteUrls.Instance().NewImpeachReport() %>" id="reportThisFileThread"><%=GetResourceString("Button_Report")%></a></span> 
     
            <% if (Model.PrivacyStatus != PrivacyStatuses.Privacy)
               {
                   if (CurrentUser != null)
                   {
                       string imgUrl = string.Empty;
                       if (Model.UserFeaturedImageAttachmentID > 0)
                           imgUrl = SiteUrls.Instance().FileFeaturedImageUrl(Model.UserFeaturedImageAttachmentID, FileFeaturedImageTypes.Title);
                       %>               
            <span class="tn-action tn-action-text-icon"><%=SPBHtmlHelper.Instance().Icon(IconTypes.Share)%><a class="tn-action-text" id="shareLink" href="<%=SiteUrls.Instance().ShareInModal(true,Request.RawUrl, Model.Subject, HtmlUtils.TrimHtml(Model.GetBody(true), 140),imgUrl, applicationID, Model.OwnerUserID, Model.Author)%>  "><%=GetResourceString("Common_Share")%></a></span>
            <%                           }
                   else
                   { %>
            <span class="tn-action tn-action-text-icon"><%=SPBHtmlHelper.Instance().Icon(IconTypes.Share)%><a class="tn-action-text" href="<%=SiteUrls.Instance().Login(true) %>"><%=GetResourceString("Common_Share")%></a></span>
                   <%}
               } %>   
                    </div>
                     <input type="text" id="essentialHideInputStore" value="<%=Convert.ToInt32((Model.IsEssential)) %>"
                        style="display: none" />
          <input type="text" id="topHideInputStore" value="<%=Model.SpecialOrder %>" style="display: none" />
                    <% if (hasManagePermission)
                       { %>
                    <div class="tn-helper-clearfix tn-border-gray tn-border-bottom tn-actions spb-file-info-row">
                     <span class="tn-action"> <a id="editFile" href="<%=SPBUrlHelper.Action("EditFile","File",new RouteValueDictionary{{"userDomainName",WebUtils.UrlEncode(Model.OwnerUser.UserName)},{"threadID",Model.ThreadID}}) %>"> <%=GetResourceString("Action_Edit")%></a></span>
          <span class="tn-action"> <a onclick=" if (confirm('<%=GetResourceString("Message_DeleteFile", applicationID)%>')) {window.location = '<%=SPBUrlHelper.Action("DeleteFile","File",new RouteValueDictionary{{"userDomainName",Model.OwnerUser.UserName},{"ThreadID",Model.ThreadID},{"pageIndex",1},{"isSummaryFiles",false},{"inShowFile",true}}) %>'}"
                        href="javascript:;"><%=GetResourceString("Action_Delete")%></a></span>

                    <%if (CurrentUser != null && CurrentUser.IsContentAdministrator)
                      { %>
                              <span class="tn-action"><a id="setTop" href="javascript:;" onclick="topManage();">
            <% if (Model.SpecialOrder > 0) Response.Write(GetResourceString("Common_CancelPutter")); else Response.Write(GetResourceString("Common_SetTop")); %>
            </a> </span>
          <span class="tn-action"><a id="setEssential" href="javascript:;" onclick="essentialManage()">
            <% if (Model.IsEssential) Response.Write(GetResourceString("Common_CancelEssential")); else Response.Write(GetResourceString("Common_SetEssential")); %>
            </a> </span>
          <span class="tn-action"><a id="recommendFileModel" href="<%=SiteUrls.Instance().RecommendItem(applicationID,Model.OwnerUserID, Model.ThreadID,Model.Subject )%>"> <%=GetResourceString("Common_ManagerRecommend")%></a> </span>
                    <%} %>
                    </div>
                    <%} %>
                  </div>
                </div>
                <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001001130004", new RouteValueDictionary { { "class", "spb-ad-detail" } })%>
                <div class="spb-file-description">
                  <div class="tn-collapsible tn-collapsible-opened">
                    <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
                      <h4 class="tn-helper-reset"><%=GetResourceString("Title_FileDetails",ApplicationIDs.Instance().File())%></h4>
                    </div>
                    <div class="tn-collapsible-content" style="display:block;">
                      <div class="tn-detail-text">
                        <%if (hasManagePermission)
                          {%>
            <%=Model.GetBody(true)%>
         <%}
                          else
                          {%>
                      <%=Model.GetBody(false)%>
          <% }%>
                      </div>
                      <div class="tn-helper-clearfix">
                        <div class="tn-rating tn-helper-left">
                           <% if (CurrentUser == null)
                              { %>
              <%=SPBHtmlHelper.Instance().ShowRating(Model.RatingSum, Model.TotalRatings)%>
              <%}
                              else
                              {%>
              <%=SPBHtmlHelper.Instance().RatingButton(Model.ThreadID, "fileRating", Model.RatingSum, Model.TotalRatings, SPBUrlHelper.Action("Rate", "ChannelFile"), "ratingCallback()")%>
              <%} %>
                        </div>
                        <div class="tn-helper-right">
           <%=SPBHtmlHelper.Instance().LinkButton("downloadFile1", GetResourceString("Button_AtOnceDownload", applicationID),"javascript:;", ButtonSizes.Large, HighlightStyles.Primary)%>              
                      </div>
                    </div>
                  </div>
                </div>
                </div>
                <div id="ListRatingUsers">
                    <% Html.RenderAction<ChannelFileController>(n => n.Control_ListRatingUsers(Model.ThreadID, 18)); %>
                </div>
                <%IList<FileDownLoadRecord> downLoadRecords = ViewData.Get<IList<FileDownLoadRecord>>("downLoadRecords", null);
                  if (downLoadRecords != null && downLoadRecords.Count > 0)
                  { %>
                <div class="tn-visitors tn-collapsible tn-collapsible-opened">
                  <div class="tn-border-bottom tn-border-gray tn-collapsible-header tn-switch-left">
                    <h4 class="tn-helper-reset"><%=GetResourceString("Message_FileDownloadNewly",applicationID)%></h4>
                  </div>
                  <div class="tn-collapsible-content">
                    <ul class="tn-avatar-list tn-helper-reset">
                    <%foreach (FileDownLoadRecord record in downLoadRecords)
                      { %>
                     <li class="tn-avatar-item">
                    <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(record.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small,null)%>
                    </div> 
                    <%if (record.UserID > 0 && record != null)
                      { %>
                         <a class="tn-user-name" href="<%=SiteUrls.Instance().UserChannelHome(record.UserID,UserDomainSpecialAppIDs.Instance().Home()) %>" ><%=SPBHtmlHelper.Instance().UserDisplayName(record.UserID)%></a>
                      <%}
                      else Response.Write(record.UserDisplayName);%>
                   </li>
                      <%} %>
                    </ul>
                  </div>
                </div>
                <%} %>
                <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001001130003", new RouteValueDictionary { { "class", "spb-ad-detail-bottom" } })%>
                <div id="fileConnents">
            <%Html.RenderAction<ChannelFileController>(n => n.Control_FileComments(Model.ThreadID, Request.QueryString.GetInt("pageIndex", 1))); %>
                </div>
                </div>
            </div>
  <%}
        }
      } %>
    <script type="text/javascript">
        $(document).ready(function () {  
            $("#downloadFile,#downloadFile1").click(function () {             
            <% if (CurrentUser == null && (Model.OnlyAllowRegisteredUserDownload || Model.Price > 0))
            {%>
            window.location.href="<%=SiteUrls.Instance().Login(true) %>"; 
            return false; 
         <%} else if (CurrentUser != null && Model.Price > 0 && !hasManagePermission && (!FileThreads.ValidateDownloadFile(CurrentUser, Model.ThreadID) || !FileThreads.IsDownloaded(CurrentUser.UserID, Model.ThreadID)))
             {
              if(CurrentUser.TradePoints  <Model.Price  )
                {%>
                 alert("对不起，你现在的金币不足，不能下载此资料");
                 return false;
                 <%} %>
                 if(!confirm('下载该资料将扣除<%=Model.Price %>个金币，你现有<%=CurrentUser.TradePoints %>个金币。\n\n重复下载不会重复扣金币。是否继续？'))
                <%{ %>return false;<%} %>
             <%} %>
               $("#downloadForm").submit();
               return false;
            });
        });
       
        </script>
    <% if (CurrentUser != null && CurrentUser.IsContentAdministrator)
       {%>
       <script type="text/javascript">
          function essentialManage() {
                if (($('#essentialHideInputStore').val()) > 0) {

                    $.get('<%=SPBUrlHelper.Action("CancelEssential","ChannelFile",new RouteValueDictionary{{"threadID",Model.ThreadID}}) %>', { threadID: '<%= Model.ThreadID %>' }, function(data) {
                        $("#setEssential").text("<%=GetResourceString("Common_SetEssential")%>");
                        $("#essentialHideInputStore").val("0");
                    });
                }
                else {
                    $.get('<%=SPBUrlHelper.Action("SetEssential","ChannelFile",new RouteValueDictionary{{"threadID",Model.ThreadID}}) %>', { threadID: '<%= Model.ThreadID %>' }, function(data) {
                        $("#setEssential").text("<%=GetResourceString("Common_CancelEssential")%>");
                        $("#essentialHideInputStore").val("1");
                    });
                }
            }

            function topManage() {
                if (($('#topHideInputStore').val()) > 0) {
                    $.get('<%=SPBUrlHelper.Action("CancelTop","ChannelFile",new RouteValueDictionary{{"threadID",Model.ThreadID}}) %>', { threadID: '<%= Model.ThreadID %>' }, function(data) {
                        $("#setTop").text('<%=GetResourceString("Common_SetTop")  %>');
                        $('#topHideInputStore').val("0");
                    });
                }
                else {
                    $.get('<%=SPBUrlHelper.Action("SetTop","ChannelFile",new RouteValueDictionary{{"threadID",Model.ThreadID}}) %>', { threadID: '<%= Model.ThreadID %>' }, function(data) {
                        $("#setTop").text("<%=GetResourceString("Common_CancelPutter") %>");
                        $('#topHideInputStore').val('<%=ViewData.GetInt("topSpecialOrder", 100) %>');
                    });
                }
            }
       </script>
    <%} %>
         <script type="text/javascript">
             function ratingCallback() {
                 $("#ListRatingUsers").load('<%=SPBUrlHelper.Action("Control_ListRatingUsers","ChannelFile",new RouteValueDictionary{{"itemID",Model.ThreadID},{"topNumber",18}}) %>');
             }

             $(document).ready(function () {
                 $(".tn-collapsible").collapsibleBox();
                 $('#commendToClubs,#addFriendModal').nyroModal({
                     resizeable: true
                 });
                 $('#OwnercommendToClubs').nyroModal({
                     resizeable: true
                 });
                 $('#managerCommend').nyroModal({
                     resizeable: true
                 });

                 $('#recommendFileModel').nyroModal({
                     resizeable: true,
                     width: 500
                 });

                 $('#reportThisFileThread').nyroModal({
                     resizeable: true
                 });

                 $('#shareLink').nyroModal({
                     resizeable: true,
                     width: 500
                 });
             });
        </script>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server" id="sidebarContent">
<%         //上传人的其它文件
    Html.RenderAction<ChannelFileController>(n => n.Control_OtherFiles(Model.OwnerUser, 10)); %>
   
       <%  //本类热点文件
           Html.RenderAction<ChannelFileController>(n => n.Control_ListFilesBlock("ListFilesRankBlock", "本类周热点文件", FileThreadSortBy.StageHitTimes, Model.SiteCategoryID, null, 10)); %>
         <% //下载排行
             Html.RenderAction<ChannelFileController>(n => n.Control_ListFilesBlock("ListFilesRankBlock", "本类周下载排行", FileThreadSortBy.StageDownloadCount, Model.SiteCategoryID, null, 10)); %>
             
</asp:content>
