﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<ForumPost>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Forum-EditForumPost"
</asp:content>
<asp:content runat="server" contentplaceholderid="subMenusContent">
<%Html.RenderPartial("Controls/Forums/Submenu.ascx");%>
</asp:content>
<asp:content id="wideContent" contentplaceholderid="wideContent" runat="server">
  <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js" SetExpireDays="30" />
    <spb:Script runat="server" ID="swfupload" Src="~/Utility/UploadFiles/js/swfupload.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="swfupload_queue" Src="~/Utility/UploadFiles/js/swfupload.queue.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="fileprogress" Src="~/Utility/UploadFiles/js/fileprogress.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="handlers" Src="~/Utility/UploadFiles/js/handlers.js"
    SetExpireDays="30" />

  <% StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", null);
     if (statusMessageData != null)
     {
         Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData, 3000, false));
         TempData["StatusMessageData"] = null;
     }
     int forumsApplication = ApplicationIDs.Instance().Forum();
     int number = Request.QueryString.GetInt("number", 0);
      %>
  <div id="EditForumPost" class="tn-box tn-widget tn-widget-content tn-corner-all tn-publish">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
       <h3 class="tn-helper-reset"><%=GetResourceString("Title_AppearReply",forumsApplication)%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <%  string formActionUrl = string.Empty;
          if (ViewData.Model.PostID > 0)
              formActionUrl = SPBUrlHelper.Action("UpdateForumPost", "ChannelForum", new RouteValueDictionary { { "postID", ViewData.Model.PostID } });
          else
              formActionUrl = SPBUrlHelper.Action("CreateForumPost", "ChannelForum", new RouteValueDictionary { { "parentID", ViewData.Model.ParentID } }); %>
      <form id="EditForumPostForm" name="EditForumPostForm" class="tn-form" action="<%=formActionUrl %>" method="post">
        <div class="tn-form tn-label-right">
            <div class="tn-form-row tn-title">
                <input name="subject" id="subject" type="text" class="tn-textbox tn-input-longest tn-border-gray" value="<%=Formatter.FormatSingleLinePlainTextForEdit(Model.Subject)  %>"  />
                <span id="subjectHint" class="tn-text-note"></span>
            </div>
            <div class="tn-form-row tn-editor">
              <%  if (CurrentUser != null && ForumPermission.Validate(ViewData.Get<ForumSection>("section"), CurrentUser, PermissionItemKeys.Instance().UploadForumAttachment()))
                  {
                      string uploadPhotoUrl = SPBUrlHelper.Action("UserContentSelector_UpdateForumAttachments", "ChannelForum", new RouteValueDictionary { { "postID", Model.PostID }, { "sectionID", Model.SectionID }, { "isImage", true } });
                      string uploadAttachmentUrl = SPBUrlHelper.Action("UserContentSelector_UpdateForumAttachments", "ChannelForum", new RouteValueDictionary { { "postID", Model.PostID }, { "sectionID", Model.SectionID }, { "isImage", false } });%>
              <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Enhanced, "body", ViewData.Model.Body, new RouteValueDictionary { { "id", "body" }, { "style", "width:100%;height:270px" } },uploadPhotoUrl,uploadAttachmentUrl)%> 
              <%}
                  else
                  {%>
              <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Enhanced, "body", ViewData.Model.Body, new RouteValueDictionary { { "id", "body" }, { "style", "width:100%;height:270px" } })%> 
              <%} %>
            </div>
            <div class="tn-form-row">
                <label class="tn-form-label"><%=GetResourceString("Title_PostSettings", forumsApplication)%><%=GetResourceString("Common_Colon") %></label>
                <input name="isUseSignature" id="isUseSignature" type="checkbox" class="tn-checkbox" <%if(ViewData.Model.IsUseSignature) Response.Write("checked=\"checked\""); %> value="true" />
                <label for="isUseSignature"> <%=GetResourceString("Label_UseUnderwrite", forumsApplication)%></label>
            </div>
            <%SiteSettings settings = SiteSettingsManager.GetSiteSettings();
              if (settings.VerifyCodeOption == VerifyCodeOption.Enabled || CurrentUser == null && settings.VerifyCodeOption == VerifyCodeOption.Anonymous)
              {%>
              <div class="tn-form-row tn-form-row-verifycode">
              <label class="tn-form-label"> <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon") %> </label>
             <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode",VerificationCodeDifficultyLevel.Low) %>
            </div>
            <%} %>
            <div class="tn-form-row tn-form-row-button">
              <label class="tn-form-label"></label>
                <%=SPBHtmlHelper.Instance().SubmitButton("postButton", GetResourceString("Button_Submit"), ButtonSizes.Large, null,null)%>
                <% if (Request.UrlReferrer != null)
                   {%>
                <%=SPBHtmlHelper.Instance().Button(string.Empty, GetResourceString("Button_Cancel"), ButtonSizes.Large, HighlightStyles.Secondary,new RouteValueDictionary() { { "onclick","window.location.href='" + Request.UrlReferrer.AbsoluteUri + "'"} },null)%>
                <%} %>
            </div>
         </div>
      </form>
    </div>
  </div>
  <script type="text/javascript">
        $(document).ready(function() {
            $("#subjectHint").html('<%=GetResourceString("Message_Alsoenter", forumsApplication)%>' + (90 - $("#subject").val().length) + '<%=GetResourceString("Message_Words", forumsApplication)%>');
            $("#subject").keyup(function() {
                $("#subjectHint").html('<%=GetResourceString("Message_Alsoenter", forumsApplication)%>' + (90 - this.value.length) + '<%=GetResourceString("Message_Words", forumsApplication)%>');
            });
            
            $("#EditForumPostForm").validate({
                rules: {
                    verifyCode: { required: true },
                    subject: { required: true, rangelength: [1, 90] },
                    body: { htmlEditorRequired: true, htmlEditorRange: [1, 5000] }
                },
                messages: {
                    verifyCode: { required: "<%=GetResourceString("Validate_VerifyCode_Required", forumsApplication)%>" },
                    subject: { required: "<%=GetResourceString("Validate_InputTitle")%>", rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_Subject_Rangelength", forumsApplication),90)%>" },
                    body: { htmlEditorRequired: "<%=GetResourceString("Validate_Body_HtmlEditorRequired", forumsApplication)%>", htmlEditorRange: "<%=string.Format(GetResourceString("Validate_Pattern_Subject_Rangelength", forumsApplication),5000)%>" }
                }
            });
            $("#postButton").click(function() {
                if (!$("#EditForumPostForm").valid()) {
                    return false;
                }
                else {
                    $("#postButton_ForHide").show();
                    $("#postButton").hide();
                }
            });
        });      

    </script>
</asp:content>
<asp:content id="templateContentRegion" contentplaceholderid="templateContentRegion"
    runat="server">
</asp:content>
