﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<ForumSection>" %>
<asp:content id="mainContentRegion" contentplaceholderid="wideContentRegion" runat="server"></asp:content>
<asp:content id="sidebarContentRegion" contentplaceholderid="templateContentRegion"
    runat="server"></asp:content>
<asp:content contentplaceholderid="subMenusContent" runat="server">
  <%  ViewData["ChannelForumSubMenu"] = ForumSubMenus.ManageSections;
    Html.RenderPartial("Controls/Forums/SubMenu.ascx", ViewData);%>
</asp:content>
<asp:content contentplaceholderid="wideFirstContent" runat="server">
  <%ForumSubMenus forumSubMenu = ViewData.Get<ForumSubMenus>("ChannelForumSubMenu");
    int applicationID = ApplicationIDs.Instance().Forum();
      %>
  <div id="manageMeun" class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <h3 class="tn-helper-reset"> <%=GetResourceString("Action_ForumManage",applicationID)%> </h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <ul class="tn-side-menu">
        <li <%if (ForumSubMenus.ManageThread == forumSubMenu) { Response.Write("class='tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all'"); } %>><a class="tn-menu-text" href=""> <%=GetResourceString("Action_ManageThread",applicationID) %></a></li>
        <li <%if (ForumSubMenus.ManagePost == forumSubMenu) { Response.Write("class='tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all'"); } %>><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageForumPosts","ChannelForum")%>"> <%=GetResourceString("Action_ManagePost", applicationID)%></a></li>
        <li <%if (ForumSubMenus.ManageSections == forumSubMenu) { Response.Write("class='tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all'"); } %>> <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageForumSections", "ChannelForum")%>"> <%=GetResourceString("Action_ManageSections", applicationID)%></a> </li>
        <li <%if (ForumSubMenus.ManageForumCategories == forumSubMenu) { Response.Write("class='tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all'"); } %>><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageForumCategories", "ChannelForum")%>"> <%=GetResourceString("Action_ManageForumCategories", applicationID)%></a></li>
      </ul>
    </div>
  </div>
</asp:content>
<asp:content contentplaceholderid="wideUnitContent" runat="server">
  <%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
        TempData["StatusMessageType"]=null;
    }
    ForumSection section = ViewData.Model;
    int applicationID = ApplicationIDs.Instance().Forum();
    string action = Globals.GetFullUrlInFileHandlerSite(ForumSections.StorageProviderName, SPBUrlHelper.Action("CreateUpdateForumSection", "ChannelForum", new RouteValueDictionary { { "sectionID", section.SectionID } }));
   
%>
  <form  id="editSectionForm" method="post" action="<%=action%>" enctype="multipart/form-data">
    <div class="tn-form tn-label-right">
      <div class="tn-text-heading tn-border-gray tn-border-bottom">
        <h4><%=GetResourceString("Title_EditModuel", applicationID)%></h4>
      </div>
      <div class="tn-form-box">
        <table>
          <tr>
            <th><%=GetResourceString("Label_SectionName", applicationID)%><%=GetResourceString("Common_Colon")%></th>
            <td><span class="tn-form-row">
              <input type="text" class="tn-textbox tn-input-long tn-border-gray" name="forumSectionName" id="forumSectionName" value="<%=section.SectionName %>" />
              </span></td>
          </tr>
          <tr>
            <th><%=GetResourceString("Label_SignPicture",applicationID)%><%=GetResourceString("Common_Colon")%></th>
            <td><span class="tn-form-row">
              <input type="file" class="fileUpload" name="picfile" />
              </span></td>
          </tr>
          <%if (!string.IsNullOrEmpty(section.LogoUrl))
                   { %>
          <tr>
            <th></th>
            <td><span class="tn-form-row">
              <%                   
                        Response.Write(string.Format("<img src=\"{0}\" width=\"110\" height=\"50\" /><br/>", SiteUrls.Instance().ForumSectionLogoUrl(section)));                  
                    %>
              </span></td>
          </tr>
          <%} %>
          <tr>
            <th><%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %></th>
            <td><span class="tn-form-row"> <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Enhanced, "description", section.Description, new RouteValueDictionary { { "id", "description" }, { "style", "width:100%" } }, null, null)%> </span></td>
          </tr>
          <tr>
            <th><%=GetResourceString("Label_BrandRules",applicationID)%><%=GetResourceString("Common_Colon")%></th>
            <td><span class="tn-form-row tn-textarea-wrap">
              <textarea id="rules" name="rules" class="tn-textarea tn-input-long tn-border-gray" rows="4" cols="30"><%=section.Rules %></textarea>
              <span style="display:none"></span>
              </span></td>
          </tr>
          <tr>
            <th><%=GetResourceString("Label_EnableAnonymousPosting",applicationID)%><%=GetResourceString("Common_Colon")%></th>
            <td><span class="tn-form-row"> <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("enableAnonymousPosting", section.EnableAnonymousPosting, new RouteValueDictionary { {"Class" , "radiobutton"} }) %> </span></td>
          </tr>
          <tr>
            <th><%=GetResourceString("Label_threadCategoryStatus",applicationID)%><%=GetResourceString("Common_Colon")%></th>
            <td><span class="tn-form-row"> <%=SPBHtmlHelper.Instance().ShowRadioButtonList<int, string>("threadCategoryStatus", new Dictionary<int, string> { { (int)ThreadCategoryStatuses.Disabled, GetResourceString("Button_Disabled") }, { (int)ThreadCategoryStatuses.NotForceEnabled, GetResourceString("Message_Enabledbutnotenforced", applicationID) }, { (int)ThreadCategoryStatuses.ForceEnabled, GetResourceString("Message_Enableandenforce", applicationID) } }, new RouteValueDictionary { { "class", "radiobutton" } }, (int)Model.ThreadCategoryStatus)%> </span></td>
          </tr>
          <tr>
            <th>&nbsp;</th>
            <td><%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_Save"), ButtonSizes.Default, null, null)%>
              <% if (Request.UrlReferrer != null)
               {%>
              <%=SPBHtmlHelper.Instance().Button(string.Empty, GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary,new RouteValueDictionary() { { "onclick","window.location.href='" + Request.UrlReferrer.AbsoluteUri +"'"} },null)%>
              <%} %></td>
          </tr>
        </table>
      </div>
    </div>
  </form>
  <script type="text/javascript" rel="forceLoad">
    $(document).ready(function() {
      

        $("#editSectionForm").validate({
            rules: {
                forumSectionName: { required: true },               
            },
            messages: {
                forumSectionName: { required: "<%=GetResourceString("Description_Required")%>" },               
            }
        });
        $("#saveButton").click(function() {
            if (!$("#editSectionForm").valid()) {
                return false;
            }
        });
    });
</script>
</asp:content>
